/*
 * Decompiled with CFR 0.152.
 */
package tech.msop.core.mybatis.encrypt.interceptor;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.time.chrono.ChronoLocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.msop.core.mybatis.encrypt.annotation.FieldEncrypt;
import tech.msop.core.mybatis.encrypt.crypto.ICrypto;
import tech.msop.core.mybatis.encrypt.enums.Algorithm;
import tech.msop.core.mybatis.encrypt.enums.CryptoType;
import tech.msop.core.mybatis.encrypt.properties.CryptoProperties;

@Intercepts(value={@Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class}), @Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class, CacheKey.class, BoundSql.class}), @Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class})})
public class CryptoInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(CryptoInterceptor.class);
    private final CryptoProperties cryptoProperties;

    public Object intercept(Invocation invocation) throws Throwable {
        Method method = invocation.getMethod();
        switch (method.getName()) {
            case "update": {
                return this.updateHandle(invocation);
            }
            case "query": {
                return this.selectHandle(invocation);
            }
        }
        return invocation.proceed();
    }

    private Object selectHandle(Invocation invocation) throws Throwable {
        CacheKey cacheKey;
        BoundSql boundSql;
        Object[] args = invocation.getArgs();
        MappedStatement ms = (MappedStatement)args[0];
        Object parameter = args[1];
        RowBounds rowBounds = (RowBounds)args[2];
        ResultHandler resultHandler = (ResultHandler)args[3];
        Executor executor = (Executor)invocation.getTarget();
        this.handleParameterOrResult(parameter, CryptoType.ENCRYPT);
        if (args.length == 4) {
            boundSql = ms.getBoundSql(parameter);
            cacheKey = executor.createCacheKey(ms, parameter, rowBounds, boundSql);
        } else {
            cacheKey = (CacheKey)args[4];
            boundSql = (BoundSql)args[5];
        }
        List resultList = executor.query(ms, parameter, rowBounds, resultHandler, cacheKey, boundSql);
        for (Object o : resultList) {
            this.handleParameterOrResult(o, CryptoType.DECRYPT);
        }
        return resultList;
    }

    private Object updateHandle(Invocation invocation) throws Throwable {
        this.handleParameterOrResult(invocation.getArgs()[1], CryptoType.ENCRYPT);
        return invocation.proceed();
    }

    private void handleParameterOrResult(Object object, CryptoType cryptoType) throws IllegalAccessException {
        HashMap<Field, Object> fieldObjectHashMap = new HashMap<Field, Object>();
        if (object instanceof Map) {
            Map paramMap = (Map)object;
            Set keySet = paramMap.keySet();
            for (Object key2 : keySet) {
                Object o = paramMap.get(key2);
                if (o == null) continue;
                this.handleObject(o, o.getClass(), fieldObjectHashMap);
            }
        } else if (object != null) {
            this.handleObject(object, object.getClass(), fieldObjectHashMap);
        }
        fieldObjectHashMap.keySet().forEach(key -> {
            try {
                this.handleString((Field)key, fieldObjectHashMap.get(key), cryptoType);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    private boolean isBase(Type type) {
        return Boolean.TYPE.equals(type) || Character.TYPE.equals(type) || Long.TYPE.equals(type) || Integer.TYPE.equals(type) || Byte.TYPE.equals(type) || Short.TYPE.equals(type) || Double.TYPE.equals(type) || Float.TYPE.equals(type);
    }

    private boolean isFilter(Object object) {
        return object == null || object instanceof CharSequence || object instanceof Number || object instanceof Collection || object instanceof Date || object instanceof ChronoLocalDate;
    }

    private List<Field> mergeField(Class<?> oClass, List<Field> fields) {
        Class<?> superclass;
        if (fields == null) {
            fields = new ArrayList<Field>();
        }
        if ((superclass = oClass.getSuperclass()) != null && !superclass.equals(Object.class) && superclass.getDeclaredFields().length > 0) {
            this.mergeField(superclass, fields);
        }
        for (Field declaredField : oClass.getDeclaredFields()) {
            int modifiers = declaredField.getModifiers();
            if (Modifier.isStatic(modifiers) || Modifier.isFinal(modifiers) || Modifier.isVolatile(modifiers) || Modifier.isSynchronized(modifiers)) continue;
            fields.add(declaredField);
        }
        return fields;
    }

    private void handleObject(Object obj, Class<?> oClass, HashMap<Field, Object> fieldObjectHashMap) throws IllegalAccessException {
        if (this.isFilter(obj)) {
            return;
        }
        List<Field> fields = this.mergeField(oClass, null);
        for (Field declaredField : fields) {
            if (Modifier.isStatic(declaredField.getModifiers())) continue;
            boolean accessible = declaredField.isAccessible();
            declaredField.setAccessible(true);
            Object value = declaredField.get(obj);
            declaredField.setAccessible(accessible);
            if (value == null || value instanceof Number) continue;
            if (value instanceof String) {
                FieldEncrypt annotation = declaredField.getAnnotation(FieldEncrypt.class);
                if (annotation == null) continue;
                fieldObjectHashMap.put(declaredField, obj);
                continue;
            }
            if (value instanceof Collection) {
                Collection coll = (Collection)value;
                for (Object o : coll) {
                    if (this.isFilter(o)) break;
                    this.handleObject(o, o.getClass(), fieldObjectHashMap);
                }
                continue;
            }
            this.handleObject(value, value.getClass(), fieldObjectHashMap);
        }
    }

    private void handleString(Field field, Object object, CryptoType cryptoType) throws Exception {
        boolean accessible = field.isAccessible();
        field.setAccessible(true);
        Object value = field.get(object);
        FieldEncrypt annotation = field.getAnnotation(FieldEncrypt.class);
        if (annotation != null) {
            String propertiesKey = this.cryptoProperties.getKey();
            log.debug("\u5168\u5c40key\u662f\uff1a" + propertiesKey);
            String annotationKey = annotation.key();
            log.debug("\u6ce8\u89e3key\u662f\uff1a" + annotationKey);
            String key = !"".equals(annotationKey) ? annotationKey : propertiesKey;
            Algorithm algorithm = annotation.algorithm();
            Class<? extends ICrypto> iCryptoImpl = annotation.crypto();
            ICrypto iCrypto = iCryptoImpl.newInstance();
            String valueResult = cryptoType.equals((Object)CryptoType.DECRYPT) ? iCrypto.decrypt(algorithm, String.valueOf(value), key) : iCrypto.encrypt(algorithm, String.valueOf(value), key);
            log.debug("\u539f\u503c\uff1a" + value);
            log.debug("\u73b0\u5728\uff1a" + valueResult);
            field.set(object, String.valueOf(valueResult));
            field.setAccessible(accessible);
        }
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }

    public CryptoInterceptor(CryptoProperties cryptoProperties) {
        this.cryptoProperties = cryptoProperties;
    }
}

