/*
 * Decompiled with CFR 0.152.
 */
package tech.msop.core.mybatis.encrypt.crypto;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.msop.core.mybatis.encrypt.crypto.ICrypto;
import tech.msop.core.mybatis.encrypt.enums.Algorithm;
import tech.msop.core.mybatis.encrypt.utils.AESUtil;
import tech.msop.core.mybatis.encrypt.utils.CryptoUtil;

public class DefaultCrypto
implements ICrypto {
    private static final Logger log = LoggerFactory.getLogger(DefaultCrypto.class);
    private static final String KEY = "edcb87b4-68b1-466b-8f6d-256ef53e50f0";

    @Override
    public String encrypt(Algorithm algorithm, String value, String key) throws Exception {
        String result;
        if (key == null || key.length() == 0) {
            key = KEY;
        }
        switch (algorithm) {
            case MD5: {
                result = CryptoUtil.encryptBASE64(CryptoUtil.encryptMD5(value.getBytes()));
                break;
            }
            case AES: {
                result = AESUtil.encryptBase64(key, value);
                break;
            }
            default: {
                result = AESUtil.encryptBase64(key, value);
            }
        }
        return result;
    }

    @Override
    public String decrypt(Algorithm algorithm, String value, String key) throws Exception {
        String result;
        if (key == null || key.length() == 0) {
            key = KEY;
        }
        try {
            switch (algorithm) {
                case MD5: {
                    log.debug("\u8be5\u7b97\u6cd5\u4e0d\u652f\u6301\u89e3\u5bc6");
                    result = "";
                    break;
                }
                case AES: {
                    result = AESUtil.decryptBase64(key, value);
                    break;
                }
                default: {
                    result = AESUtil.decryptBase64(key, value);
                    break;
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            log.debug("\u503c\uff1a\u2018" + value + "\u2019\u4e0d\u652f\u6301\u89e3\u5bc6");
            result = "";
        }
        return result;
    }
}

