/*
 * Decompiled with CFR 0.152.
 */
package tech.msop.core.http;

import java.io.IOException;
import java.util.function.Predicate;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.springframework.retry.backoff.BackOffPolicy;
import org.springframework.retry.backoff.FixedBackOffPolicy;
import org.springframework.retry.policy.SimpleRetryPolicy;
import org.springframework.retry.support.RetryTemplate;
import tech.msop.core.http.HttpResponse;
import tech.msop.core.http.ResponseSpec;
import tech.msop.core.http.RetryPolicy;

public class RetryInterceptor
implements Interceptor {
    private final RetryPolicy retryPolicy;

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        RetryTemplate template = RetryInterceptor.createRetryTemplate(this.retryPolicy);
        return (Response)template.execute(context -> {
            Response response = chain.proceed(request);
            Predicate<ResponseSpec> respPredicate = this.retryPolicy.getRespPredicate();
            if (respPredicate == null) {
                return response;
            }
            ResponseBody body = response.peekBody(Long.MAX_VALUE);
            try (HttpResponse httpResponse = new HttpResponse(response);){
                if (respPredicate.test(httpResponse)) {
                    throw new IOException("Http Retry ResponsePredicate test Failure.");
                }
            }
            return response.newBuilder().body(body).build();
        });
    }

    private static RetryTemplate createRetryTemplate(RetryPolicy policy) {
        RetryTemplate template = new RetryTemplate();
        SimpleRetryPolicy retryPolicy = new SimpleRetryPolicy();
        retryPolicy.setMaxAttempts(policy.getMaxAttempts());
        FixedBackOffPolicy backOffPolicy = new FixedBackOffPolicy();
        backOffPolicy.setBackOffPeriod(policy.getSleepMillis());
        template.setRetryPolicy((org.springframework.retry.RetryPolicy)retryPolicy);
        template.setBackOffPolicy((BackOffPolicy)backOffPolicy);
        return template;
    }

    public RetryInterceptor(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
    }
}

