/*
 * Decompiled with CFR 0.152.
 */
package tech.msop.core.http;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import okhttp3.Call;
import okhttp3.Request;
import tech.msop.core.http.HttpResponse;
import tech.msop.core.http.ResponseSpec;
import tech.msop.core.tool.utils.Exceptions;

public class Exchange {
    private BiConsumer<Request, IOException> failedBiConsumer = (r, e) -> {};
    private final Call call;

    public Exchange onFailed(BiConsumer<Request, IOException> failConsumer) {
        this.failedBiConsumer = failConsumer;
        return this;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <R> R onResponse(Function<ResponseSpec, R> func) {
        try (HttpResponse response = new HttpResponse(this.call.execute());){
            R r = func.apply(response);
            return r;
        }
        catch (IOException e) {
            throw Exceptions.unchecked((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public <R> R onSuccess(Function<ResponseSpec, R> func) {
        try (HttpResponse response = new HttpResponse(this.call.execute());){
            R r = func.apply(response);
            return r;
        }
        catch (IOException e) {
            this.failedBiConsumer.accept(this.call.request(), e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public <R> R onSuccessful(Function<ResponseSpec, R> func) {
        try (HttpResponse response = new HttpResponse(this.call.execute());){
            if (response.isOk()) {
                R r = func.apply(response);
                return r;
            }
            this.failedBiConsumer.accept(this.call.request(), new IOException(response.toString()));
            return null;
        }
        catch (IOException e) {
            this.failedBiConsumer.accept(this.call.request(), e);
        }
        return null;
    }

    public <R> Optional<R> onSuccessOpt(Function<ResponseSpec, R> func) {
        return Optional.ofNullable(this.onSuccess(func));
    }

    public <R> Optional<R> onSuccessfulOpt(Function<ResponseSpec, R> func) {
        return Optional.ofNullable(this.onSuccessful(func));
    }

    public String asString() {
        return this.onResponse(ResponseSpec::asString);
    }

    public byte[] asBytes() {
        return this.onResponse(ResponseSpec::asBytes);
    }

    public JsonNode asJsonNode() {
        return this.onResponse(ResponseSpec::asJsonNode);
    }

    public <T> T asValue(Class<T> valueType) {
        return (T)this.onResponse(responseSpec -> responseSpec.asValue(valueType));
    }

    public <T> T asValue(TypeReference<T> typeReference) {
        return (T)this.onResponse(responseSpec -> responseSpec.asValue(typeReference));
    }

    public <T> List<T> asList(Class<T> valueType) {
        return this.onResponse(responseSpec -> responseSpec.asList(valueType));
    }

    public <K, V> Map<K, V> asMap(Class<?> keyClass, Class<?> valueType) {
        return this.onResponse(responseSpec -> responseSpec.asMap(keyClass, valueType));
    }

    public <V> Map<String, V> asMap(Class<?> valueType) {
        return this.onResponse(responseSpec -> responseSpec.asMap(valueType));
    }

    public <T> T asDomValue(Class<T> valueType) {
        return (T)this.onResponse(responseSpec -> responseSpec.asDomValue(valueType));
    }

    public <T> List<T> asDomList(Class<T> valueType) {
        return this.onResponse(responseSpec -> responseSpec.asDomList(valueType));
    }

    public File toFile(File file) {
        return this.onResponse(responseSpec -> responseSpec.toFile(file));
    }

    public Path toFile(Path path) {
        return this.onResponse(responseSpec -> responseSpec.toFile(path));
    }

    public Exchange(Call call) {
        this.call = call;
    }
}

