/*
 * Decompiled with CFR 0.152.
 */
package tech.msop.core.http;

import java.io.IOException;
import javax.annotation.ParametersAreNonnullByDefault;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Response;
import tech.msop.core.http.AsyncCall;
import tech.msop.core.http.HttpResponse;

@ParametersAreNonnullByDefault
public class AsyncCallback
implements Callback {
    private final AsyncCall asyncCall;

    AsyncCallback(AsyncCall asyncCall) {
        this.asyncCall = asyncCall;
    }

    public void onFailure(Call call, IOException e) {
        this.asyncCall.onFailure(call.request(), e);
    }

    public void onResponse(Call call, Response response) throws IOException {
        try (HttpResponse httpResponse = new HttpResponse(response);){
            this.asyncCall.onResponse(httpResponse);
            if (response.isSuccessful()) {
                this.asyncCall.onSuccessful(httpResponse);
            } else {
                this.asyncCall.onFailure(call.request(), new IOException(httpResponse.message()));
            }
        }
    }
}

