/*
 * Decompiled with CFR 0.152.
 */
package tech.msop.core.api.crypto.util;

import java.lang.reflect.Method;
import java.util.Objects;
import org.springframework.core.MethodParameter;
import tech.msop.core.api.crypto.annotation.decrypt.ApiDecrypt;
import tech.msop.core.api.crypto.annotation.encrypt.ApiEncrypt;
import tech.msop.core.api.crypto.bean.CryptoInfoBean;
import tech.msop.core.api.crypto.config.ApiCryptoProperties;
import tech.msop.core.api.crypto.enums.CryptoType;
import tech.msop.core.api.crypto.exception.EncryptBodyFailException;
import tech.msop.core.api.crypto.exception.EncryptMethodNotFoundException;
import tech.msop.core.api.crypto.exception.KeyNotConfiguredException;
import tech.msop.core.tool.utils.AesUtil;
import tech.msop.core.tool.utils.ClassUtil;
import tech.msop.core.tool.utils.DesUtil;
import tech.msop.core.tool.utils.RsaUtil;
import tech.msop.core.tool.utils.StringUtil;

public class ApiCryptoUtil {
    public static CryptoInfoBean getEncryptInfo(MethodParameter methodParameter) {
        ApiEncrypt encryptBody = (ApiEncrypt)ClassUtil.getAnnotation((Method)methodParameter.getMethod(), ApiEncrypt.class);
        if (encryptBody == null) {
            return null;
        }
        return new CryptoInfoBean(encryptBody.value(), encryptBody.secretKey());
    }

    public static CryptoInfoBean getDecryptInfo(MethodParameter methodParameter) {
        ApiDecrypt decryptBody = (ApiDecrypt)ClassUtil.getAnnotation((Method)methodParameter.getMethod(), ApiDecrypt.class);
        if (decryptBody == null) {
            return null;
        }
        return new CryptoInfoBean(decryptBody.value(), decryptBody.secretKey());
    }

    public static String encryptData(ApiCryptoProperties properties, byte[] jsonData, CryptoInfoBean infoBean) {
        CryptoType type = infoBean.getType();
        if (type == null) {
            throw new EncryptMethodNotFoundException();
        }
        String secretKey = infoBean.getSecretKey();
        if (type == CryptoType.DES) {
            secretKey = ApiCryptoUtil.checkSecretKey(properties.getDesKey(), secretKey, "DES");
            return DesUtil.encryptToBase64((byte[])jsonData, (String)secretKey);
        }
        if (type == CryptoType.AES) {
            secretKey = ApiCryptoUtil.checkSecretKey(properties.getAesKey(), secretKey, "AES");
            return AesUtil.encryptToBase64((byte[])jsonData, (String)secretKey);
        }
        if (type == CryptoType.RSA) {
            String privateKey = Objects.requireNonNull(properties.getRsaPrivateKey());
            return RsaUtil.encryptByPrivateKeyToBase64((String)privateKey, (byte[])jsonData);
        }
        throw new EncryptBodyFailException();
    }

    public static byte[] decryptData(ApiCryptoProperties properties, byte[] jsonData, CryptoInfoBean infoBean) {
        CryptoType type = infoBean.getType();
        if (type == null) {
            throw new EncryptMethodNotFoundException();
        }
        String secretKey = infoBean.getSecretKey();
        if (type == CryptoType.DES) {
            secretKey = ApiCryptoUtil.checkSecretKey(properties.getDesKey(), secretKey, "DES");
            return DesUtil.decryptFormBase64((byte[])jsonData, (String)secretKey);
        }
        if (type == CryptoType.AES) {
            secretKey = ApiCryptoUtil.checkSecretKey(properties.getAesKey(), secretKey, "AES");
            return AesUtil.decryptFormBase64((byte[])jsonData, (String)secretKey);
        }
        if (type == CryptoType.RSA) {
            String publicKey = Objects.requireNonNull(properties.getRsaPrivateKey());
            return RsaUtil.decryptFromBase64((String)publicKey, (byte[])jsonData);
        }
        throw new EncryptMethodNotFoundException();
    }

    public static String checkSecretKey(String key, String secretKey, String keyName) {
        if (StringUtil.isBlank((CharSequence)key) && StringUtil.isAllBlank((CharSequence[])new CharSequence[]{secretKey})) {
            throw new KeyNotConfiguredException(String.format("%s key is not configured! (%s \u5bc6\u94a5\u672a\u914d\u7f6e)", keyName, keyName));
        }
        return StringUtil.isBlank((CharSequence)secretKey) ? key : secretKey;
    }
}

