/*
 * Decompiled with CFR 0.152.
 */
package tech.msop.core.api.crypto.core;

import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.Order;
import org.springframework.http.MediaType;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;
import tech.msop.core.api.crypto.annotation.encrypt.ApiEncrypt;
import tech.msop.core.api.crypto.bean.CryptoInfoBean;
import tech.msop.core.api.crypto.config.ApiCryptoProperties;
import tech.msop.core.api.crypto.exception.EncryptBodyFailException;
import tech.msop.core.api.crypto.util.ApiCryptoUtil;
import tech.msop.core.tool.jackson.JsonUtil;
import tech.msop.core.tool.utils.ClassUtil;

@Order(value=1)
@AutoConfiguration
@ControllerAdvice
@ConditionalOnProperty(value={"xg.api.crypto.enabled"}, havingValue="true", matchIfMissing=true)
public class ApiEncryptResponseBodyAdvice
implements ResponseBodyAdvice<Object> {
    private static final Logger log = LoggerFactory.getLogger(ApiEncryptResponseBodyAdvice.class);
    private final ApiCryptoProperties properties;

    public boolean supports(MethodParameter returnType, @NonNull Class converterType) {
        return ClassUtil.isAnnotated((Method)returnType.getMethod(), ApiEncrypt.class);
    }

    @Nullable
    public Object beforeBodyWrite(Object body, @NonNull MethodParameter returnType, @NonNull MediaType selectedContentType, @NonNull Class selectedConverterType, @NonNull ServerHttpRequest request, @NonNull ServerHttpResponse response) {
        if (body == null) {
            return null;
        }
        response.getHeaders().setContentType(MediaType.TEXT_PLAIN);
        CryptoInfoBean cryptoInfoBean = ApiCryptoUtil.getEncryptInfo(returnType);
        if (cryptoInfoBean != null) {
            byte[] bodyJsonBytes = JsonUtil.toJsonAsBytes((Object)body);
            return ApiCryptoUtil.encryptData(this.properties, bodyJsonBytes, cryptoInfoBean);
        }
        throw new EncryptBodyFailException();
    }

    public ApiEncryptResponseBodyAdvice(ApiCryptoProperties properties) {
        this.properties = properties;
    }
}

