/*
 * Decompiled with CFR 0.152.
 */
package tech.msop.core.api.crypto.config;

import java.util.List;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import tech.msop.core.api.crypto.config.ApiCryptoProperties;
import tech.msop.core.api.crypto.core.ApiDecryptParamResolver;

@AutoConfiguration
@EnableConfigurationProperties(value={ApiCryptoProperties.class})
@ConditionalOnProperty(value={"xg.api.crypto.enabled"}, havingValue="true", matchIfMissing=true)
public class ApiCryptoConfiguration
implements WebMvcConfigurer {
    private final ApiCryptoProperties apiCryptoProperties;

    public void addArgumentResolvers(List<HandlerMethodArgumentResolver> resolvers) {
        resolvers.add(new ApiDecryptParamResolver(this.apiCryptoProperties));
    }

    public ApiCryptoConfiguration(ApiCryptoProperties apiCryptoProperties) {
        this.apiCryptoProperties = apiCryptoProperties;
    }
}

