/*
 * Decompiled with CFR 0.152.
 */
package tech.msop.core.actuate.config;

import java.util.HashSet;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cache.CacheManager;
import org.springframework.context.annotation.Bean;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import tech.msop.core.actuate.handler.HttpCacheInterceptor;
import tech.msop.core.actuate.handler.HttpCacheService;
import tech.msop.core.actuate.properties.MsHttpCacheProperties;

@AutoConfiguration
@EnableConfigurationProperties(value={MsHttpCacheProperties.class})
@ConditionalOnProperty(value={"ms.http.cache.enabled"}, havingValue="true")
public class MsCacheConfiguration
implements WebMvcConfigurer {
    private static final String DEFAULT_STATIC_PATH_PATTERN = "/**";
    private final WebMvcProperties webMvcProperties;
    private final MsHttpCacheProperties properties;
    private final CacheManager cacheManager;

    @Bean
    public HttpCacheService httpCacheService() {
        return new HttpCacheService(this.properties, this.cacheManager);
    }

    public void addInterceptors(InterceptorRegistry registry) {
        HashSet<String> excludePatterns = new HashSet<String>(this.properties.getExcludePatterns());
        String staticPathPattern = this.webMvcProperties.getStaticPathPattern();
        if (!DEFAULT_STATIC_PATH_PATTERN.equals(staticPathPattern.trim())) {
            excludePatterns.add(staticPathPattern);
        }
        HttpCacheInterceptor httpCacheInterceptor = new HttpCacheInterceptor(this.httpCacheService());
        registry.addInterceptor((HandlerInterceptor)httpCacheInterceptor).addPathPatterns(this.properties.getIncludePatterns().toArray(new String[0])).excludePathPatterns(excludePatterns.toArray(new String[0]));
    }

    public MsCacheConfiguration(WebMvcProperties webMvcProperties, MsHttpCacheProperties properties, CacheManager cacheManager) {
        this.webMvcProperties = webMvcProperties;
        this.properties = properties;
        this.cacheManager = cacheManager;
    }
}

