/*
 * Decompiled with CFR 0.152.
 */
package tech.molecules.leet.util;

import java.awt.Color;
import java.awt.Paint;
import java.util.HashMap;
import java.util.Map;
import net.mahdilamb.colormap.Colormap;
import net.mahdilamb.colormap.Colormaps;
import net.mahdilamb.colormap.FluidColormap;
import org.jfree.chart.renderer.PaintScale;
import tech.molecules.leet.table.NexusTableModel;
import tech.molecules.leet.table.NumericalDatasource;

public class ColorMapHelper {
    public static Map<String, Color> evaluateColorValues(Colormap cm, NexusTableModel ntm, NumericalDatasource nd) {
        HashMap<String, Double> vi = new HashMap<String, Double>();
        for (String ri : ntm.getVisibleRows()) {
            if (!nd.hasValue(ri)) continue;
            vi.put(ri, nd.getValue(ri));
        }
        return ColorMapHelper.evaluateColorValues(cm, vi);
    }

    public static Map<String, Color> evaluateColorValues(Colormap cm, Map<String, Double> val) {
        double c_min = Double.POSITIVE_INFINITY;
        double c_max = Double.NEGATIVE_INFINITY;
        for (String ci : val.keySet()) {
            Double cvi = val.get(ci);
            if (cvi == null) {
                cvi = Double.NaN;
            }
            if (!Double.isFinite(cvi)) continue;
            c_min = Math.min(cvi, c_min);
            c_max = Math.max(cvi, c_max);
        }
        double paintscale_min = c_min - Math.max(0.001, (c_max - c_min) * 0.01);
        double paintscale_max = c_max + Math.max(0.001, (c_max - c_min) * 0.01);
        if (cm == null) {
            cm = Colormaps.get((String)"Jet");
        }
        FluidColormap fcm = Colormaps.fluidColormap((Colormap)cm);
        fcm.setMinValue(Float.valueOf((float)paintscale_min));
        fcm.setMaxValue(Float.valueOf((float)paintscale_max));
        HashMap<String, Color> cv = new HashMap<String, Color>();
        for (String ci : val.keySet()) {
            if (Double.isNaN(val.get(ci))) continue;
            cv.put(ci, fcm.get(val.get(ci).doubleValue()));
        }
        return cv;
    }

    public static Color createRandomColor() {
        double ri = Math.random();
        return Colormaps.get((String)"Plotly").get(ri);
    }

    public static class SpectrumPaintScale
    implements PaintScale {
        private static final float H1 = 0.25f;
        private static final float H2 = 0.75f;
        private final double lowerBound;
        private final double upperBound;

        public SpectrumPaintScale(double lowerBound, double upperBound) {
            this.lowerBound = lowerBound;
            this.upperBound = upperBound;
        }

        public double getLowerBound() {
            return this.lowerBound;
        }

        public double getUpperBound() {
            return this.upperBound;
        }

        public Paint getPaint(double value) {
            float scaledValue = (float)(value / (this.getUpperBound() - this.getLowerBound()));
            float scaledH = 0.25f + scaledValue * 0.5f;
            return Color.getHSBColor(scaledH, 1.0f, 1.0f);
        }
    }

    public static class PaintScaleFromColormap
    implements PaintScale {
        private Colormap cm;
        private double lb;
        private double ub;
        double transparency;
        Color nanColor;

        public PaintScaleFromColormap(Colormap cm, double lb, double ub, double transparency, Color nanColor) {
            this.cm = cm;
            this.lb = lb;
            this.ub = ub;
            this.transparency = transparency;
            this.nanColor = nanColor;
        }

        public double getLowerBound() {
            return this.lb;
        }

        public double getUpperBound() {
            return this.ub;
        }

        public Paint getPaint(double v) {
            if (Double.isNaN(v) && this.nanColor != null) {
                return this.nanColor;
            }
            double va = (v - this.lb) / (this.ub - this.lb);
            Color ca = this.cm.get(va);
            return new Color(ca.getRed(), ca.getGreen(), ca.getBlue(), (int)(255.0 * this.transparency));
        }
    }
}

