/*
 * Decompiled with CFR 0.152.
 */
package tech.molecules.leet.table.io;

import com.actelion.research.chem.io.DWARFileParser;
import com.actelion.research.gui.VerticalFlowLayout;
import com.formdev.flatlaf.FlatLightLaf;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import tech.molecules.leet.table.MultiNumericDataColumn;
import tech.molecules.leet.table.NColumn;
import tech.molecules.leet.table.NDataProvider;
import tech.molecules.leet.table.NStructureDataProvider;
import tech.molecules.leet.table.NexusTableModel;
import tech.molecules.leet.table.StringColumn;
import tech.molecules.leet.table.StructureColumn;
import tech.molecules.leet.table.io.DWARSimpleWrapper;
import tech.molecules.leet.workbench.JWorkbench;
import tech.molecules.leet.workbench.WorkbenchModel;

public class JDWARImportPanel
extends JPanel {
    private String filepath;
    private NexusTableModel importedModel = null;
    private List<ColumnImportPanel> importPanels = new ArrayList<ColumnImportPanel>();
    private Consumer<NexusTableModel> callback = null;

    public void autoconfigure_A() {
        for (ColumnImportPanel ci : this.importPanels) {
            DWARFileParser ain = new DWARFileParser(this.filepath);
            int zn = 0;
            while (zn < 50 && ain.next()) {
                String di = "";
                di = ci.specialField ? ain.getSpecialFieldData(ain.getSpecialFieldIndex(ci.name)) : ain.getFieldData(ain.getFieldIndex(ci.name));
                boolean can_parse_structure = new DWARSimpleWrapper.StructureColumnImporter(ci.name, ci.specialField).canParse(di);
                if (can_parse_structure) {
                    ci.jbImport.setSelectedIndex(2);
                    break;
                }
                boolean can_parse_numeric = new DWARSimpleWrapper.MultiNumericColumnImporter(ci.name, ci.specialField).canParse(di);
                if (!can_parse_numeric) continue;
                ci.jbImport.setSelectedIndex(1);
                break;
            }
            ain.close();
        }
    }

    private void setImportedModel(NexusTableModel ntm) {
        this.importedModel = ntm;
        if (this.callback != null) {
            this.callback.accept(this.importedModel);
        }
    }

    public JDWARImportPanel(final String filepath, Consumer<NexusTableModel> callback) {
        this.filepath = filepath;
        this.callback = callback;
        DWARFileParser in = new DWARFileParser(filepath);
        String[] fields = in.getFieldNames();
        ArrayList sfields = new ArrayList(in.getSpecialFieldMap().keySet());
        JScrollPane jsp = new JScrollPane();
        JPanel ja = new JPanel();
        jsp.setViewportView(ja);
        ja.setLayout((LayoutManager)new VerticalFlowLayout());
        for (String fi : fields) {
            ColumnImportPanel ci = new ColumnImportPanel(fi, false);
            ja.add(ci);
            this.importPanels.add(ci);
        }
        for (String fi : sfields) {
            ColumnImportPanel ci = new ColumnImportPanel(fi, true);
            ja.add(ci);
            this.importPanels.add(ci);
        }
        this.setLayout(new BorderLayout());
        this.add((Component)jsp, "Center");
        JButton jbLoad = new JButton("Import");
        this.add((Component)jbLoad, "South");
        this.autoconfigure_A();
        jbLoad.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List<DWARSimpleWrapper.DWARColumnImporter> importers = JDWARImportPanel.this.importPanels.stream().filter(fi -> fi.getImporter() != null).map(fi -> fi.getImporter()).collect(Collectors.toList());
                DWARSimpleWrapper wrapper = new DWARSimpleWrapper(filepath, importers);
                wrapper.loadFile();
                NexusTableModel ntm = wrapper.getNexusTableModel();
                JDWARImportPanel.this.setImportedModel(ntm);
            }
        });
    }

    public static void showImportDialog() {
    }

    public static void main(String[] args) {
        FlatLightLaf.setup();
        try {
            UIManager.setLookAndFeel((LookAndFeel)new FlatLightLaf());
        }
        catch (Exception ex) {
            System.err.println("Failed to initialize LaF");
        }
        JFrame fi = new JFrame();
        fi.getContentPane();
        fi.getContentPane().setLayout(new BorderLayout());
        fi.setSize(600, 600);
        fi.setVisible(true);
        DWARImportAction action = new DWARImportAction(fi, "C:\\datasets\\hit_expansion_similarities.dwar");
        action.actionPerformed(new ActionEvent(fi, 1234, "importDWAR"));
        WorkbenchModel model = new WorkbenchModel(action.getTableModel());
        JWorkbench jwb = new JWorkbench(model);
        fi.getContentPane().add(jwb);
        fi.revalidate();
    }

    public static class DWARImportAction
    extends AbstractAction {
        private Frame owner;
        private NexusTableModel ntm;
        private String filepath;

        public DWARImportAction(Frame owner, String filepath) {
            this.owner = owner;
            this.filepath = filepath;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JDialog jd = new JDialog(this.owner, true);
            JDWARImportPanel importPanel = new JDWARImportPanel(this.filepath, x -> {
                this.ntm = x;
                jd.dispose();
            });
            jd.getContentPane().setLayout(new BorderLayout());
            jd.getContentPane().add((Component)importPanel, "Center");
            jd.setSize(600, 600);
            jd.setVisible(true);
        }

        public NexusTableModel getTableModel() {
            return this.ntm;
        }
    }

    class ColumnImportPanel
    extends JPanel {
        String name;
        boolean specialField;
        JLabel jlName;
        JComboBox<ImportOption> jbImport;

        public ColumnImportPanel(String name, boolean special) {
            this.name = name;
            this.specialField = special;
            this.initImportPanel();
        }

        private void initImportPanel() {
            this.setLayout(new FlowLayout());
            this.jlName = new JLabel(this.name);
            this.jbImport = new JComboBox();
            this.jbImport.addItem(new ImportOption<NDataProvider.NStringDataProvider, StringColumn>("String", new DWARSimpleWrapper.StringColumnImporter(this.name, this.specialField)));
            this.jbImport.addItem(new ImportOption<NDataProvider.NMultiNumericDataProvider, MultiNumericDataColumn>("Numeric", new DWARSimpleWrapper.MultiNumericColumnImporter(this.name, this.specialField)));
            this.jbImport.addItem(new ImportOption<NStructureDataProvider, StructureColumn>("Structure", new DWARSimpleWrapper.StructureColumnImporter(this.name, this.specialField)));
            this.jbImport.addItem(new ImportOption("No import", null));
            this.add(this.jlName);
            this.add(this.jbImport);
        }

        public DWARSimpleWrapper.DWARColumnImporter getImporter() {
            return ((ImportOption)this.jbImport.getSelectedItem()).importer;
        }
    }

    public static class ImportOption<U extends NDataProvider, T extends NColumn> {
        public final String name;
        public final DWARSimpleWrapper.DWARColumnImporter<U, T> importer;

        public ImportOption(String name, DWARSimpleWrapper.DWARColumnImporter<U, T> importer) {
            this.name = name;
            this.importer = importer;
        }

        public String toString() {
            return this.name;
        }
    }
}

