/*
 * Decompiled with CFR 0.152.
 */
package tech.molecules.leet.table.io;

import com.actelion.research.chem.IDCodeParser;
import com.actelion.research.chem.SmilesParser;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.io.DWARFileParser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.tuple.Pair;
import tech.molecules.leet.table.DefaultMultiNumericDataProvider;
import tech.molecules.leet.table.DefaultStringDataProvider;
import tech.molecules.leet.table.DefaultStructureDataProvider;
import tech.molecules.leet.table.MultiNumericDataColumn;
import tech.molecules.leet.table.NColumn;
import tech.molecules.leet.table.NDataProvider;
import tech.molecules.leet.table.NStructureDataProvider;
import tech.molecules.leet.table.NexusTableModel;
import tech.molecules.leet.table.StringColumn;
import tech.molecules.leet.table.StructureColumn;

public class DWARSimpleWrapper {
    private List<DWARColumnImporter> importers;
    private String pathDWAR;
    private NexusTableModel ntm = new NexusTableModel();

    public DWARSimpleWrapper(String file, List<DWARColumnImporter> columns) {
        this.pathDWAR = file;
        this.importers = columns;
    }

    public void loadFile() {
        this.ntm = new NexusTableModel();
        DWARFileParser dwarIn = new DWARFileParser(this.pathDWAR);
        String[] fields = dwarIn.getFieldNames();
        TreeMap sfields = dwarIn.getSpecialFieldMap();
        for (DWARColumnImporter ci : this.importers) {
            ci.prepare(dwarIn);
        }
        ArrayList<String> all_rowkeys = new ArrayList<String>();
        int zi = 0;
        while (dwarIn.next()) {
            String ki = "" + zi;
            all_rowkeys.add(ki);
            for (DWARColumnImporter ci : this.importers) {
                ci.readLine(ki, dwarIn);
            }
            ++zi;
        }
        for (DWARColumnImporter ci : this.importers) {
            ci.postprocess(dwarIn);
        }
        this.ntm.setAllRows(all_rowkeys);
        for (int za = 0; za < this.importers.size(); ++za) {
            this.ntm.setNexusColumnWithDataProvider(za, (Pair<NColumn, NDataProvider>)Pair.of(this.importers.get(za).getColumn(), this.importers.get(za).getDataProvider()));
        }
    }

    public NexusTableModel getNexusTableModel() {
        return this.ntm;
    }

    public static class StringColumnImporter
    implements DWARColumnImporter<NDataProvider.NStringDataProvider, StringColumn> {
        private String colname;
        private boolean specialfield;
        private int cidx = -1;
        private DefaultStringDataProvider dsdp = null;
        Map<String, String> stringdata = new HashMap<String, String>();

        public StringColumnImporter(String colname, boolean specialfield) {
            this.colname = colname;
            this.specialfield = specialfield;
        }

        @Override
        public boolean canParse(String data) {
            return true;
        }

        @Override
        public void prepare(DWARFileParser dw) {
            this.cidx = !this.specialfield ? dw.getFieldIndex(this.colname) : dw.getSpecialFieldIndex(this.colname);
            this.stringdata = new HashMap<String, String>();
        }

        @Override
        public void readLine(String key, DWARFileParser dw) {
            String ni = this.specialfield ? dw.getSpecialFieldData(this.cidx) : dw.getFieldData(this.cidx);
            this.stringdata.put(key, ni);
        }

        @Override
        public void postprocess(DWARFileParser dw) {
            this.dsdp = new DefaultStringDataProvider(this.stringdata);
        }

        @Override
        public NDataProvider.NStringDataProvider getDataProvider() {
            return this.dsdp;
        }

        @Override
        public StringColumn getColumn() {
            return new StringColumn(this.colname);
        }
    }

    public static class MultiNumericColumnImporter
    implements DWARColumnImporter<NDataProvider.NMultiNumericDataProvider, MultiNumericDataColumn> {
        private String colname;
        private boolean specialfield;
        private int cidx = -1;
        private DefaultMultiNumericDataProvider mndp = null;
        Map<String, double[]> numdata = new HashMap<String, double[]>();

        public MultiNumericColumnImporter(String colname, boolean specialf) {
            this.colname = colname;
            this.specialfield = specialf;
        }

        @Override
        public boolean canParse(String data) {
            double[] dval = this.parseNumericData(data.trim());
            if (dval.length == 0) {
                return false;
            }
            return Arrays.stream(dval).anyMatch(di -> !Double.isNaN(di));
        }

        @Override
        public void prepare(DWARFileParser dw) {
            this.cidx = !this.specialfield ? dw.getFieldIndex(this.colname) : dw.getSpecialFieldIndex(this.colname);
            this.numdata = new HashMap<String, double[]>();
        }

        @Override
        public void readLine(String key, DWARFileParser dw) {
            String ni = this.specialfield ? dw.getSpecialFieldData(this.cidx) : dw.getFieldData(this.cidx);
            ni = ni.trim();
            double[] dval = this.parseNumericData(ni);
            this.numdata.put(key, dval);
        }

        private double[] parseNumericData(String ni) {
            if (ni.isEmpty()) {
                return new double[0];
            }
            String[] splits = ni.split("; ");
            double[] dval = new double[splits.length];
            for (int zi = 0; zi < splits.length; ++zi) {
                dval[zi] = Double.NaN;
                try {
                    dval[zi] = Double.parseDouble(splits[zi]);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return dval;
        }

        @Override
        public void postprocess(DWARFileParser dw) {
            this.mndp = new DefaultMultiNumericDataProvider(this.numdata);
        }

        @Override
        public NDataProvider.NMultiNumericDataProvider getDataProvider() {
            return this.mndp;
        }

        @Override
        public MultiNumericDataColumn getColumn() {
            return new MultiNumericDataColumn(this.colname);
        }
    }

    public static class StructureColumnImporter
    implements DWARColumnImporter<NStructureDataProvider, StructureColumn> {
        private String colname;
        private boolean specialfield;
        private int cidx = -1;
        private IDCodeParser icp = new IDCodeParser(true);
        private DefaultStructureDataProvider dsdp = null;
        private List<String[]> structuredata = new ArrayList<String[]>();

        public StructureColumnImporter(String colname, boolean specialfield) {
            this.colname = colname;
            this.specialfield = specialfield;
        }

        @Override
        public boolean canParse(String data) {
            StereoMolecule mi = this.parseMoleculeData(data);
            return mi != null;
        }

        @Override
        public void prepare(DWARFileParser dw) {
            this.cidx = !this.specialfield ? dw.getFieldIndex(this.colname) : dw.getSpecialFieldIndex(this.colname);
            this.structuredata = new ArrayList<String[]>();
        }

        @Override
        public void readLine(String key, DWARFileParser dw) {
            String di = this.specialfield ? dw.getSpecialFieldData(this.cidx) : dw.getFieldData(this.cidx);
            StereoMolecule mi = this.parseMoleculeData(di = di.trim());
            if (mi != null) {
                this.structuredata.add(new String[]{key, mi.getIDCode()});
            } else {
                this.structuredata.add(new String[]{key, ""});
            }
        }

        private StereoMolecule parseMoleculeData(String di) {
            StereoMolecule mi = null;
            boolean parsed = false;
            if (!di.isEmpty()) {
                StereoMolecule mi2 = new StereoMolecule();
                try {
                    this.icp.parse(mi2, di);
                    mi2.ensureHelperArrays(31);
                    parsed = mi2.getAtoms() > 0;
                    mi = mi2;
                }
                catch (Exception ex) {
                    mi = null;
                }
                if (!parsed) {
                    try {
                        mi = new SmilesParser().parseMolecule(di);
                        mi.ensureHelperArrays(31);
                        boolean bl = parsed = mi.getAtoms() > 0;
                        if (parsed) {
                            System.out.println("mkay");
                        }
                    }
                    catch (Exception ex) {
                        mi = null;
                    }
                }
            }
            if (parsed) {
                return mi;
            }
            return null;
        }

        @Override
        public void postprocess(DWARFileParser dw) {
            this.dsdp = new DefaultStructureDataProvider(this.structuredata);
        }

        @Override
        public NStructureDataProvider getDataProvider() {
            return this.dsdp;
        }

        @Override
        public StructureColumn getColumn() {
            return new StructureColumn(true);
        }
    }

    public static interface DWARColumnImporter<U extends NDataProvider, T extends NColumn> {
        public void prepare(DWARFileParser var1);

        public void readLine(String var1, DWARFileParser var2);

        public void postprocess(DWARFileParser var1);

        public boolean canParse(String var1);

        public U getDataProvider();

        public T getColumn();
    }
}

