/*
 * Decompiled with CFR 0.152.
 */
package tech.molecules.leet.table.gui;

import com.actelion.research.chem.IDCodeParser;
import com.actelion.research.chem.Molecule;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.coords.CoordinateInventor;
import com.actelion.research.chem.reaction.ReactionEncoder;
import com.actelion.research.gui.table.ChemistryRenderPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.AbstractCellEditor;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import tech.molecules.leet.table.NexusTable;

public class LeetChemistryCellRenderer
extends AbstractCellEditor
implements TableCellEditor,
ListCellRenderer,
TableCellRenderer {
    private MyChemistryRenderPanel mRenderPanel = new MyChemistryRenderPanel();
    private boolean mIsEnabled;
    private boolean mAlternateBackground;
    private Object lastValue = null;

    public LeetChemistryCellRenderer() {
        this(null);
    }

    public LeetChemistryCellRenderer(Dimension preferredSize) {
        if (preferredSize != null) {
            this.mRenderPanel.setPreferredSize(preferredSize);
        }
    }

    public void setAlternateRowBackground(boolean b) {
        this.mAlternateBackground = b;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.lastValue = value;
        return this.getTableCellRendererComponent(table, value, isSelected, false, row, column);
    }

    @Override
    public Object getCellEditorValue() {
        return this.lastValue;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean hasFocus) {
        this.mIsEnabled = list.isEnabled();
        return this.getCellRendererComponent(null, value, isSelected, hasFocus, index);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
        this.mIsEnabled = table.isEnabled();
        return this.getCellRendererComponent(table, value, isSelected, hasFocus, row);
    }

    private Component getCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row) {
        JPanel pi = null;
        if (table instanceof NexusTable) {
            NexusTable nt = (NexusTable)table;
            NexusTable.NexusInteractiveEditorInfrastructure editorInfra = nt.createInteractiveEditorInfrastructure(row);
            pi = editorInfra.panel;
        } else {
            pi = new JPanel();
        }
        pi.setLayout(new BorderLayout());
        pi.add((Component)((Object)this.mRenderPanel), "Center");
        this.mRenderPanel.setOpaque(false);
        if (value == null) {
            return new JLabel("NoStructure");
        }
        if (value instanceof String) {
            try {
                String s = (String)value;
                if (s.length() == 0) {
                    return new JLabel("NoStructure");
                }
                int productIndex = s.indexOf(33);
                if (productIndex > 0 && s.charAt(productIndex - 1) == ' ') {
                    productIndex = -1;
                }
                if (productIndex != -1) {
                    this.mRenderPanel.setChemistry(ReactionEncoder.decode((String)((String)value), (boolean)true));
                }
                int index = s.indexOf(10);
                if (index == -1) {
                    index = s.indexOf(32);
                    if (index == -1) {
                        this.mRenderPanel.setChemistry(new IDCodeParser(true).getCompactMolecule(s));
                    }
                    this.mRenderPanel.setChemistry(new IDCodeParser(true).getCompactMolecule(s.substring(0, index), s.substring(index + 1)));
                }
                StereoMolecule mol = new StereoMolecule();
                new IDCodeParser(true).parse(mol, s.substring(0, index));
                do {
                    s = s.substring(index + 1);
                    index = s.indexOf(10);
                    mol.addMolecule((Molecule)new IDCodeParser(true).getCompactMolecule(index == -1 ? s : s.substring(0, index)));
                } while (index != -1);
                new CoordinateInventor().invent(mol);
                this.mRenderPanel.setChemistry(mol);
            }
            catch (Exception e) {
                if (value instanceof String && ((String)value).trim().isEmpty()) {
                    return new JLabel("<NoData>");
                }
                System.out.println("exception: input string: " + value);
                return new JLabel("<ERROR>");
            }
        } else {
            this.mRenderPanel.setChemistry(value);
        }
        return pi;
    }

    private class MyChemistryRenderPanel
    extends ChemistryRenderPanel {
        private MyChemistryRenderPanel() {
        }

        public void setSelected(boolean isSelected) {
        }
    }
}

