/*
 * Decompiled with CFR 0.152.
 */
package tech.molecules.leet.table.gui;

import com.actelion.research.chem.IDCodeParser;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.gui.JStructureView;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.border.LineBorder;
import net.mahdilamb.colormap.Colormap;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import tech.molecules.leet.table.NDataProvider;

public class JStructureGridPanel
extends JPanel {
    private List<JGridPanel> panels = new ArrayList<JGridPanel>();
    private JPopupMenu myComponentPopupMenu;
    private NDataProvider.StructureWithID mouseOverStructure;

    public JStructureGridPanel(List<NDataProvider.StructureWithID> idcs, int x, int y) {
        this.setData(idcs, x, y, null, new ArrayList<Pair<String, Map<String, String>>>(), new ArrayList<Triple<String, Map<String, Double>, Colormap>>());
    }

    public List<NDataProvider.StructureWithID> getSelected() {
        List la = this.panels.stream().filter(pi -> pi.isSelected()).map(pi -> pi.getStructure()).collect(Collectors.toList());
        return new ArrayList<NDataProvider.StructureWithID>(la);
    }

    public JStructureGridPanel(List<NDataProvider.StructureWithID> idcs, int x, int y, Map<String, List<Color>> color_annotations, List<Pair<String, Map<String, String>>> annotations, List<Triple<String, Map<String, Double>, Colormap>> numerical_data) {
        this.setData(idcs, x, y, color_annotations, annotations, numerical_data);
    }

    public JPanel getThisJPanel() {
        return this;
    }

    public void setData(List<NDataProvider.StructureWithID> structures, int x, int y, Map<String, List<Color>> color_annotations, List<Pair<String, Map<String, String>>> annotations, List<Triple<String, Map<String, Double>, Colormap>> numerical_data) {
        this.removeAll();
        IDCodeParser icp = new IDCodeParser();
        this.setLayout(new GridLayout(x, y));
        this.panels.clear();
        for (int zi = 0; zi < Math.min(structures.size(), x * y); ++zi) {
            List<Color> lc2;
            StereoMolecule mi = new StereoMolecule();
            try {
                icp.parse(mi, structures.get((int)zi).structure[0], structures.get((int)zi).structure[1]);
            }
            catch (Exception ex) {
                System.out.println("[ERROR] problem with idcode?..");
            }
            final JStructureView jva = new JStructureView(mi);
            jva.setBackground(new Color(255, 255, 255, 0));
            final JGridPanel gp = new JGridPanel(this, structures.get(zi), (JComponent)jva);
            if (color_annotations != null && (lc2 = color_annotations.get(structures.get(zi))) != null && lc2.size() > 0) {
                gp.setBackgroundColors(lc2);
            }
            this.panels.add(gp);
            this.add(gp);
            final NDataProvider.StructureWithID fsi = structures.get(zi);
            jva.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    JStructureGridPanel.this.setMouseOverStructure(fsi);
                    if (e.getButton() == 3) {
                        JStructureGridPanel.this.myComponentPopupMenu.show((Component)jva, e.getX(), e.getY());
                    } else {
                        gp.toggleSelection();
                    }
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    System.out.println("mouse entered " + gp);
                }

                @Override
                public void mouseExited(MouseEvent e) {
                }
            });
            gp.setComponentPopupMenu(this.getComponentPopupMenu());
        }
        this.revalidate();
    }

    public NDataProvider.StructureWithID getStructureMouseOver() {
        return this.mouseOverStructure;
    }

    public void setContextMenu(JPopupMenu jpop) {
        this.myComponentPopupMenu = jpop;
    }

    private void setMouseOverStructure(NDataProvider.StructureWithID s) {
        this.mouseOverStructure = s;
    }

    public static class JGridPanel
    extends JPanel {
        private JStructureGridPanel parent;
        private NDataProvider.StructureWithID structure;
        private boolean selected = false;
        private JComponent component;
        private List<Color> backgroundColors;

        public JGridPanel(final JStructureGridPanel parent, final NDataProvider.StructureWithID structure, JComponent c) {
            this.parent = parent;
            this.structure = structure;
            this.component = c;
            this.setLayout(new BorderLayout());
            this.add((Component)c, "Center");
            this.select(false);
            this.addMouseListener(new MouseListener(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    parent.setMouseOverStructure(structure);
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    parent.setMouseOverStructure(structure);
                    if (e.getButton() == 3 && this.isSelected()) {
                        this.getComponentPopupMenu().show(this.getThisJPanel(), e.getX(), e.getY());
                    } else {
                        this.toggleSelection();
                    }
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                }

                @Override
                public void mouseExited(MouseEvent e) {
                }
            });
        }

        @Override
        protected void paintComponent(Graphics g_) {
            super.paintComponent(g_);
            Graphics2D g = (Graphics2D)g_;
            if (this.backgroundColors != null && this.backgroundColors.size() > 0) {
                int nbc = this.backgroundColors.size();
                if (nbc == 1) {
                    Color ca_1 = this.backgroundColors.get(0);
                    Color ca = new Color(ca_1.getRed(), ca_1.getGreen(), ca_1.getBlue(), 40);
                    Color cb = new Color(ca_1.getRed(), ca_1.getGreen(), ca_1.getBlue(), 100);
                    g.setPaint(new GradientPaint(0.0f, 0.0f, ca, this.getWidth(), this.getHeight(), cb));
                    g.fillRect(0, 0, this.getWidth(), this.getHeight());
                } else {
                    for (int zi = 0; zi < nbc; ++zi) {
                        Color ca_1 = this.backgroundColors.get(zi);
                        Color ca = new Color(ca_1.getRed(), ca_1.getGreen(), ca_1.getBlue(), 40);
                        Color cb = new Color(ca_1.getRed(), ca_1.getGreen(), ca_1.getBlue(), 100);
                        int pxa = (int)((double)zi * (1.0 * (double)this.getWidth() / (double)nbc));
                        int pxb = (int)((double)(zi + 1) * (1.0 * (double)this.getWidth() / (double)nbc));
                        g.setPaint(new GradientPaint(pxa, 0.0f, ca, pxb, this.getHeight(), cb));
                        g.fillRect(pxa, 0, pxb - pxa, this.getHeight());
                    }
                }
            } else {
                Color ca = Color.white;
                Color cb = new Color(245, 250, 250);
                g.setPaint(new GradientPaint(0.0f, 0.0f, ca, this.getWidth(), this.getHeight(), cb));
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
        }

        public JPanel getThisJPanel() {
            return this;
        }

        @Override
        public void setComponentPopupMenu(JPopupMenu popup) {
            super.setComponentPopupMenu(popup);
            this.component.setComponentPopupMenu(popup);
        }

        public void select(boolean selected) {
            this.selected = selected;
            if (this.selected) {
                this.setBorder(new LineBorder(Color.red.darker(), 2));
            } else {
                this.setBorder(new LineBorder(Color.white, 2));
            }
            this.repaint();
        }

        public void toggleSelection() {
            this.select(!this.selected);
        }

        public boolean isSelected() {
            return this.selected;
        }

        public NDataProvider.StructureWithID getStructure() {
            return this.structure;
        }

        public void setBackgroundColors(List<Color> ci) {
            this.backgroundColors = new ArrayList<Color>(ci);
        }
    }
}

