/*
 * Decompiled with CFR 0.152.
 */
package tech.molecules.leet.table.gui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class JSlimRangeSlider
extends JPanel {
    private double a;
    private double b;
    private double rangeA;
    private double rangeB;
    private boolean draggingHandle = false;
    private int draggedHandle = -1;
    private int mouseOverHandle = -1;
    int sizeHandle = 10;
    Paint paintSelectedInterval = new Color(20, 200, 20);
    Paint paintNonselectedInterval = new Color(40, 40, 40);
    Stroke strokeNonselectedInterval = new BasicStroke(1.0f);
    Paint paintHandleMouseOver = new Color(224, 60, 20);
    Paint paintHandleMouseNotOver = new Color(20, 240, 40);
    private List<ChangeListener> listeners = new ArrayList<ChangeListener>();

    public JSlimRangeSlider(double a, double b) {
        this.setOpaque(false);
        this.setPreferredSize(new Dimension(120, 30));
        this.setAB(a, b);
        this.setRange(a, b);
        SlimRangeSliderMouseAndMouseMotionListener li = new SlimRangeSliderMouseAndMouseMotionListener();
        this.addMouseListener(li);
        this.addMouseMotionListener(li);
    }

    public void setAB(double a, double b) {
        this.a = a;
        this.b = b;
        this.setRange(this.rangeA, this.rangeB);
    }

    public void setRange(double ra, double rb) {
        this.rangeA = Math.min(this.b, Math.max(ra, this.a));
        this.rangeB = Math.min(this.b, Math.max(rb, this.a));
    }

    public double transformXToRangePos(double x) {
        return this.a + (this.b - this.a) * ((x - 0.5 * (double)this.sizeHandle) / (double)(this.getWidth() - this.sizeHandle));
    }

    public double transformRangePosToX(double rangepos) {
        return 0.5 * (double)this.sizeHandle + (rangepos - this.a) / (this.b - this.a) * (double)(this.getWidth() - this.sizeHandle);
    }

    public double[] getRange() {
        return new double[]{this.rangeA, this.rangeB};
    }

    public void addChangeListener(ChangeListener cl) {
        this.listeners.add(cl);
    }

    public void removeChangeListener(ChangeListener cl) {
        this.listeners.remove(cl);
    }

    private void fireChangeEvent() {
        for (ChangeListener cli : this.listeners) {
            cli.stateChanged(new ChangeEvent(this));
        }
    }

    private int isMouseOverHandle(Point p) {
        if (this.getHandleA().contains(p)) {
            return 0;
        }
        if (this.getHandleB().contains(p)) {
            return 1;
        }
        return -1;
    }

    private Rectangle getHandleA() {
        double interv = this.b - this.a;
        double xa = this.transformRangePosToX(this.rangeA);
        double ya = this.getHeight() / 2;
        return new Rectangle((int)(xa - 0.5 * (double)this.sizeHandle), (int)(ya - 0.5 * (double)this.sizeHandle), this.sizeHandle, this.sizeHandle);
    }

    private Rectangle getHandleB() {
        double interv = this.b - this.a;
        double xa = this.transformRangePosToX(this.rangeB);
        double ya = this.getHeight() / 2;
        return new Rectangle((int)(xa - 0.5 * (double)this.sizeHandle), (int)(ya - 0.5 * (double)this.sizeHandle), this.sizeHandle, this.sizeHandle);
    }

    public JSlimRangeSlider getThis() {
        return this;
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setStroke(this.strokeNonselectedInterval);
        g2.setPaint(this.paintNonselectedInterval);
        g2.drawLine(0, this.getHeight() / 2, this.getWidth(), this.getHeight() / 2);
        g2.setStroke(new BasicStroke(this.sizeHandle / 2));
        g2.setPaint(this.paintSelectedInterval);
        double interv = this.b - this.a;
        double xa = this.transformRangePosToX(this.rangeA);
        double xb = this.transformRangePosToX(this.rangeB);
        g2.drawLine((int)xa, this.getHeight() / 2, (int)xb, this.getHeight() / 2);
        g2.setPaint(this.paintHandleMouseNotOver);
        Rectangle hra = this.getHandleA();
        Rectangle hrb = this.getHandleB();
        g2.fillRect(hra.x, hra.y, hra.width, hra.height);
        g2.fillRect(hrb.x, hrb.y, hrb.width, hrb.height);
        g2.setPaint(this.paintHandleMouseOver);
        if (this.mouseOverHandle == 0) {
            g2.fill(hra);
        }
        if (this.mouseOverHandle == 1) {
            g2.fill(hrb);
        }
    }

    public static void main(String[] args) {
        JFrame fi = new JFrame("Test");
        fi.setSize(600, 400);
        JSlimRangeSlider slider = new JSlimRangeSlider(40.0, 200.0);
        fi.getContentPane().add(slider);
        slider.setSize(300, 100);
        fi.setVisible(true);
        fi.setDefaultCloseOperation(3);
    }

    class SlimRangeSliderMouseAndMouseMotionListener
    implements MouseListener,
    MouseMotionListener {
        SlimRangeSliderMouseAndMouseMotionListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                JDialog jDialog = new JDialog();
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            int new_handle = JSlimRangeSlider.this.isMouseOverHandle(e.getPoint());
            if (new_handle >= 0) {
                JSlimRangeSlider.this.draggedHandle = new_handle;
                JSlimRangeSlider.this.draggingHandle = true;
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (JSlimRangeSlider.this.draggedHandle >= 0) {
                JSlimRangeSlider.this.draggingHandle = false;
                JSlimRangeSlider.this.draggedHandle = -1;
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (JSlimRangeSlider.this.draggingHandle) {
                double interv = JSlimRangeSlider.this.b - JSlimRangeSlider.this.a;
                if (JSlimRangeSlider.this.draggedHandle == 0) {
                    double new_ra = JSlimRangeSlider.this.transformXToRangePos(e.getX());
                    new_ra = Math.min(new_ra, JSlimRangeSlider.this.rangeB);
                    new_ra = Math.max(new_ra, JSlimRangeSlider.this.a);
                    JSlimRangeSlider.this.rangeA = new_ra;
                } else if (JSlimRangeSlider.this.draggedHandle == 1) {
                    double new_ra = JSlimRangeSlider.this.transformXToRangePos(e.getX());
                    new_ra = Math.max(new_ra, JSlimRangeSlider.this.rangeA);
                    new_ra = Math.min(new_ra, JSlimRangeSlider.this.b);
                    JSlimRangeSlider.this.rangeB = new_ra;
                }
            }
            JSlimRangeSlider.this.repaint();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JSlimRangeSlider.this.fireChangeEvent();
                }
            });
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (!JSlimRangeSlider.this.draggingHandle) {
                int new_handle = JSlimRangeSlider.this.isMouseOverHandle(e.getPoint());
                if (JSlimRangeSlider.this.mouseOverHandle != new_handle) {
                    JSlimRangeSlider.this.mouseOverHandle = new_handle;
                    JSlimRangeSlider.this.repaint();
                }
            }
        }
    }
}

