/*
 * Decompiled with CFR 0.152.
 */
package tech.molecules.leet.table.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import tech.molecules.leet.table.NClassification;
import tech.molecules.leet.table.NDataProvider;
import tech.molecules.leet.table.NexusTableModel;
import tech.molecules.leet.table.gui.JStructureGridPanel;

public class JSimpleClusterView
extends JPanel
implements NexusTableModel.NexusTableModelListener {
    private NDataProvider.StructureDataProvider dataProvider;
    private NClassification model;
    JScrollPane jsp_ClusterList;
    JTable jt_ClusterTable;
    JScrollPane jsp_Structures;
    JStructureGridPanel jp_Structures;

    public JSimpleClusterView(NDataProvider.StructureDataProvider dataProvider, NClassification column) {
        this.dataProvider = dataProvider;
        this.model = column;
        this.reinit();
    }

    private void showCluster(NClassification.NClass c) {
        int lines = c.getMembers().size() / 3 + 1;
        List<NDataProvider.StructureWithID> structures = c.getMembers().stream().sorted().map(si -> this.dataProvider.getStructureData((String)si)).collect(Collectors.toList());
        this.jp_Structures.setData(structures, 3, lines, null, null, null);
        this.jp_Structures.repaint();
    }

    private void reinit() {
        this.removeAll();
        this.setLayout(new BorderLayout());
        this.jsp_ClusterList = new JScrollPane();
        this.jt_ClusterTable = new JTable(new NClassification.ClassificationTableModel(this.model));
        this.jt_ClusterTable.setSelectionMode(0);
        this.jt_ClusterTable.getColumnModel().getColumn(2).setCellRenderer(new ColorRenderer(false));
        this.jt_ClusterTable.getColumnModel().getColumn(0).setPreferredWidth(this.getPreferredNameColumnWidth());
        this.jt_ClusterTable.getColumnModel().getColumn(1).setPreferredWidth(this.getPreferredSmallColumnWidth());
        this.jt_ClusterTable.getColumnModel().getColumn(1).setMaxWidth(this.getPreferredSmallColumnWidth());
        this.jt_ClusterTable.getColumnModel().getColumn(2).setMaxWidth(this.getPreferredSmallColumnWidth());
        this.jsp_ClusterList.setViewportView(this.jt_ClusterTable);
        this.add((Component)this.jsp_ClusterList, "West");
        this.jsp_Structures = new JScrollPane();
        this.jp_Structures = new JStructureGridPanel(new ArrayList<NDataProvider.StructureWithID>(), 4, 4);
        this.jsp_Structures.setViewportView(this.jp_Structures);
        this.add((Component)this.jsp_Structures, "Center");
        this.model.addClassificationListener(new NClassification.ClassificationListener(){

            @Override
            public void classificationChanged() {
                if (JSimpleClusterView.this.jt_ClusterTable.getSelectedRow() >= 0) {
                    JSimpleClusterView.this.showCluster(JSimpleClusterView.this.model.getClasses().get(JSimpleClusterView.this.jt_ClusterTable.getSelectedRow()));
                }
                JSimpleClusterView.this.jt_ClusterTable.repaint();
                JSimpleClusterView.this.jp_Structures.repaint();
                JSimpleClusterView.this.revalidate();
            }

            @Override
            public void classChanged(NClassification.NClass ci) {
            }
        });
        this.jt_ClusterTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (JSimpleClusterView.this.jt_ClusterTable.getSelectedRow() >= 0) {
                    JSimpleClusterView.this.showCluster(JSimpleClusterView.this.model.getClasses().get(JSimpleClusterView.this.jt_ClusterTable.getSelectedRow()));
                }
            }
        });
        this.revalidate();
    }

    private int getPreferredNameColumnWidth() {
        return new JLabel((String)"abcd_abcd_abcd").getPreferredSize().width;
    }

    private int getPreferredSmallColumnWidth() {
        return new JLabel((String)"ColorColor").getPreferredSize().width;
    }

    @Override
    public void nexusTableStructureChanged() {
        this.reinit();
    }

    public class ColorRenderer
    extends JLabel
    implements TableCellRenderer {
        boolean isBordered = true;

        public ColorRenderer(boolean isBordered) {
            this.isBordered = isBordered;
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object color, boolean isSelected, boolean hasFocus, int row, int column) {
            Color newColor = (Color)color;
            this.setBackground(newColor);
            return this;
        }
    }
}

