/*
 * Decompiled with CFR 0.152.
 */
package tech.molecules.leet.table.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import tech.molecules.leet.table.NColumn;
import tech.molecules.leet.table.NexusTableModel;
import tech.molecules.leet.table.NumericalDatasource;

public class JNumericalDataSourceSelector
extends JPanel {
    private NumericalDataSourceSelectorModel model;
    private SELECTOR_MODE selectorMode;
    private JScrollPane jsp;
    private JTree jt;
    private JButton jtb2;
    private JMenu jm;
    private JMenuBar jmb;
    private List<SelectionListener> selListeners = new ArrayList<SelectionListener>();

    public JNumericalDataSourceSelector(NumericalDataSourceSelectorModel model, SELECTOR_MODE mode) {
        this.model = model;
        this.selectorMode = mode;
        if (mode.equals((Object)SELECTOR_MODE.Tree)) {
            this.initTree();
        } else if (mode.equals((Object)SELECTOR_MODE.Menu) || mode.equals((Object)SELECTOR_MODE.OnlyJMenu)) {
            this.initMenu();
        }
    }

    private void initTree() {
        this.removeAll();
        this.jsp = new JScrollPane();
        this.setLayout(new BorderLayout());
        this.add((Component)this.jsp, "Center");
        this.jt = new JTree();
        if (this.model.getTreeModel() != null) {
            this.jt.setModel(this.model.getTreeModel());
        }
        this.jsp.setViewportView(this.jt);
        this.jt.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                if (((DefaultMutableTreeNode)JNumericalDataSourceSelector.this.jt.getLastSelectedPathComponent()).isLeaf()) {
                    JNumericalDataSourceSelector.this.model.setSelectedDatasource((NumericalDatasource)((DefaultMutableTreeNode)JNumericalDataSourceSelector.this.jt.getLastSelectedPathComponent()).getUserObject());
                }
            }
        });
    }

    public JMenu getMenu() {
        return this.jm;
    }

    private void initMenu() {
        this.removeAll();
        this.setLayout(new BorderLayout());
        this.jm = null;
        JMenu ji = new JMenu();
        this.addChildrenToMenu(ji, (DefaultMutableTreeNode)this.model.getTreeModel().getRoot());
        this.jm = ji;
        if (!this.selectorMode.equals((Object)SELECTOR_MODE.OnlyJMenu)) {
            this.jmb = new JMenuBar();
            this.jmb.add(this.jm);
            this.add((Component)this.jmb, "North");
        }
    }

    private void addChildrenToMenu(JMenuItem jmi, DefaultMutableTreeNode dmtn) {
        for (int zi = 0; zi < dmtn.getChildCount(); ++zi) {
            DefaultMutableTreeNode ni = (DefaultMutableTreeNode)dmtn.getChildAt(zi);
            if (ni.isLeaf()) {
                ((JMenu)jmi).add(new SelectAction((NumericalDatasource)ni.getUserObject()));
                continue;
            }
            JMenu jmnew = new JMenu(ni.getUserObject().toString());
            jmi.add(jmnew);
            this.addChildrenToMenu(jmnew, ni);
        }
    }

    public void addSelectionListener(SelectionListener li) {
        this.selListeners.add(li);
    }

    private void fireSelectionChangedEvent() {
        for (SelectionListener li : this.selListeners) {
            li.selectionChanged();
        }
    }

    public NumericalDataSourceSelectorModel getModel() {
        return this.model;
    }

    public static Triple<JPanel, Supplier<NumericalDatasource>, Consumer<NumericalDatasource>> getSelectorPanel2(NexusTableModel ntm, Frame owner) {
        JPanel pi = new JPanel();
        pi.setLayout(new FlowLayout(0));
        final JTextField jti = new JTextField(18);
        jti.setText("");
        final NumericalDataSourceSelectorModel ndsm = new NumericalDataSourceSelectorModel(ntm);
        Supplier<NumericalDatasource> nds_supplier = () -> ndsm.getSelectedDatasource();
        JNumericalDataSourceSelector jndsm = new JNumericalDataSourceSelector(ndsm, SELECTOR_MODE.Menu);
        pi.add(jti);
        pi.add(jndsm);
        Consumer<NumericalDatasource> nds_consumer = nds -> jti.setText(nds.getName());
        jndsm.addSelectionListener(new SelectionListener(){

            @Override
            public void selectionChanged() {
                jti.setText(ndsm.getSelectedDatasource().toString());
            }
        });
        return Triple.of((Object)pi, nds_supplier, nds_consumer);
    }

    public static Triple<JPanel, Supplier<NumericalDatasource>, Consumer<NumericalDatasource>> getSelectorPanel(NexusTableModel ntm, final Frame owner) {
        JPanel pi = new JPanel();
        pi.setLayout(new FlowLayout(0));
        final JTextField jti = new JTextField(18);
        jti.setText("");
        JButton jb = new JButton("Set Numerical DS");
        final NumericalDataSourceSelectorModel ndsm = new NumericalDataSourceSelectorModel(ntm);
        Supplier<NumericalDatasource> nds_supplier = () -> ndsm.getSelectedDatasource();
        jb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final JDialog jd = new JDialog(owner, true);
                JNumericalDataSourceSelector jndsm = new JNumericalDataSourceSelector(ndsm, SELECTOR_MODE.Tree);
                jndsm.setPreferredSize(new Dimension(200, 320));
                jd.getContentPane().setLayout(new BorderLayout());
                jd.getContentPane().add((Component)jndsm, "Center");
                JPanel bottom = new JPanel();
                bottom.setLayout(new FlowLayout(2));
                JButton jok = new JButton("OK");
                bottom.add(jok);
                jd.getContentPane().add((Component)bottom, "South");
                jok.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        jti.setText(ndsm.getSelectedDatasource().getName());
                        jd.setVisible(false);
                    }
                });
                jd.pack();
                jd.setVisible(true);
            }
        });
        pi.add(jti);
        pi.add(jb);
        Consumer<NumericalDatasource> nds_consumer = nds -> jti.setText(nds.getName());
        return Triple.of((Object)pi, nds_supplier, nds_consumer);
    }

    public static Pair<JButton, Supplier<NumericalDatasource>> getAccessButton(NexusTableModel ntm, final Frame owner) {
        JButton jb = new JButton("Set Numerical DS");
        final NumericalDataSourceSelectorModel ndsm = new NumericalDataSourceSelectorModel(ntm);
        Supplier<NumericalDatasource> nds_supplier = () -> ndsm.getSelectedDatasource();
        jb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final JDialog jd = new JDialog(owner, true);
                JNumericalDataSourceSelector jndsm = new JNumericalDataSourceSelector(ndsm, SELECTOR_MODE.Tree);
                jd.getContentPane().setLayout(new BorderLayout());
                jd.getContentPane().add((Component)jndsm, "Center");
                JPanel bottom = new JPanel();
                bottom.setLayout(new FlowLayout(2));
                JButton jok = new JButton("OK");
                bottom.add(jok);
                jd.getContentPane().add((Component)bottom, "South");
                jok.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        jd.setVisible(false);
                    }
                });
                jd.pack();
                jd.setVisible(true);
            }
        });
        return Pair.of((Object)jb, nds_supplier);
    }

    public static interface SelectionListener {
        public void selectionChanged();
    }

    private class SelectAction
    extends AbstractAction {
        private NumericalDatasource ndi;

        public SelectAction(NumericalDatasource ndi) {
            super(ndi.getName());
            this.ndi = ndi;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JNumericalDataSourceSelector.this.model.setSelectedDatasource(this.ndi);
            JNumericalDataSourceSelector.this.fireSelectionChangedEvent();
        }
    }

    public static enum SELECTOR_MODE {
        Tree,
        Menu,
        OnlyJMenu;

    }

    public static class NumericalDataSourceSelectorModel {
        private NexusTableModel ntm;
        private NumericalDatasource selectedDatasource;

        public NumericalDataSourceSelectorModel(NexusTableModel ntm) {
            this.ntm = ntm;
        }

        public DefaultTreeModel getTreeModel() {
            DefaultMutableTreeNode root = new DefaultMutableTreeNode();
            Map<NColumn, Map<String, NumericalDatasource>> cols = this.ntm.collectNumericDataSources();
            for (NColumn ci : cols.keySet().stream().sorted((x, y) -> x.getName().compareTo(y.getName())).collect(Collectors.toList())) {
                DefaultMutableTreeNode ncol = new DefaultMutableTreeNode(ci.getName());
                root.add(ncol);
                for (String si : cols.get(ci).keySet().stream().sorted().collect(Collectors.toList())) {
                    ncol.add(new DefaultMutableTreeNode(cols.get(ci).get(si)));
                }
            }
            DefaultTreeModel dtm = new DefaultTreeModel(root);
            return dtm;
        }

        public void setSelectedDatasource(NumericalDatasource nd) {
            this.selectedDatasource = nd;
        }

        public NumericalDatasource getSelectedDatasource() {
            return this.selectedDatasource;
        }
    }
}

