/*
 * Decompiled with CFR 0.152.
 */
package tech.molecules.leet.table.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import tech.molecules.leet.table.NexusTable;
import tech.molecules.leet.table.NexusTableModel;
import tech.molecules.leet.table.gui.JNumericalDataSourceSelector;
import tech.molecules.leet.util.ColorMapHelper;

public class JNexusTopPanel
extends JPanel {
    private NexusTable table;
    private JPanel j_main;
    private JPanel j_left;
    private JPanel j_center;
    private JPanel j_right;
    private JMenuBar jmb;
    private JLabel jl_rowcount;
    private JSlider jsl_size;

    public JNexusTopPanel(NexusTable t) {
        this.table = t;
        this.reinit();
        this.initListeners();
        this.updateData();
    }

    private void reinit() {
        this.removeAll();
        this.setLayout(new BorderLayout());
        this.j_main = new JPanel();
        this.j_main.setLayout(new BorderLayout());
        this.add((Component)this.j_main, "Center");
        this.j_left = new JPanel();
        this.j_left.setLayout(new FlowLayout());
        this.j_main.add((Component)this.j_left, "West");
        this.j_right = new JPanel();
        this.j_right.setLayout(new FlowLayout());
        this.j_main.add((Component)this.j_right, "East");
        this.j_center = new JPanel();
        this.j_center.setLayout(new FlowLayout());
        this.j_main.add((Component)this.j_center, "Center");
        this.jmb = new JMenuBar();
        this.j_left.add(this.jmb);
        this.jl_rowcount = new JLabel();
        this.j_right.add(this.jl_rowcount);
        this.jsl_size = new JSlider(16, 400);
        this.jsl_size.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JNexusTopPanel.this.table.setRowHeight(JNexusTopPanel.this.jsl_size.getValue());
            }
        });
        this.j_right.add(this.jsl_size);
    }

    private void initListeners() {
        this.table.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                JNexusTopPanel.this.updateUI();
            }
        });
        ((NexusTableModel)this.table.getModel()).addNexusListener(new NexusTableModel.NexusTableModelListener(){

            @Override
            public void nexusTableStructureChanged() {
                JNexusTopPanel.this.updateData();
            }
        });
    }

    private void reinitMenu() {
        this.jmb.removeAll();
        JMenu jm_color = new JMenu("Coloring");
        if (this.table.getTableModel() != null) {
            final JNumericalDataSourceSelector jndss = new JNumericalDataSourceSelector(new JNumericalDataSourceSelector.NumericalDataSourceSelectorModel(this.table.getTableModel()), JNumericalDataSourceSelector.SELECTOR_MODE.Menu);
            jm_color.add(jndss.getMenu());
            jndss.addSelectionListener(new JNumericalDataSourceSelector.SelectionListener(){

                @Override
                public void selectionChanged() {
                    JNexusTopPanel.this.table.getTableModel().setHighlightColors(ColorMapHelper.evaluateColorValues(null, JNexusTopPanel.this.table.getTableModel(), jndss.getModel().getSelectedDatasource()));
                }
            });
        }
        this.jmb.add(jm_color);
    }

    public void setSliderManually(int size) {
        this.jsl_size.setValue(size);
    }

    public void updateData() {
        this.jl_rowcount.setText(String.format("Rows: %d Visible: %d", this.table.getTableModel().getAllRows().size(), this.table.getTableModel().getVisibleRows().size()));
        this.jsl_size.setValue(this.table.getRowHeight());
        this.reinitMenu();
    }
}

