/*
 * Decompiled with CFR 0.152.
 */
package tech.molecules.leet.table.gui;

import com.actelion.research.gui.VerticalFlowLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class JExtendedSlider
extends JPanel {
    JLabel jTitle;
    JPanel jLowerPanel;
    JSlider jSlider;
    JTextField jValA;
    JTextField jValB;
    double vA;
    double vStep;

    public JExtendedSlider(String title, double[] range, int steps) {
        this.init(title, range, steps);
    }

    public JSlider getSlider() {
        return this.jSlider;
    }

    public double getSliderValue() {
        return this.vA + this.vStep * (double)this.jSlider.getValue();
    }

    private void init(String title, double[] range, int steps) {
        this.vA = range[0];
        this.vStep = (range[1] - range[0]) / (double)steps;
        this.setLayout((LayoutManager)new VerticalFlowLayout());
        this.jTitle = new JLabel(title);
        this.add(this.jTitle);
        this.jLowerPanel = new JPanel();
        this.jLowerPanel.setLayout(new BorderLayout());
        this.jValA = new JTextField(4);
        this.jValA.setEditable(false);
        this.jSlider = new JSlider(0, steps);
        this.add(this.jSlider);
        this.add(this.jLowerPanel);
        this.jLowerPanel.add((Component)this.jValA, "West");
        this.jValA.setText(String.format("%.2f", range[0]));
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.maybeShowPopupMenu(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.maybeShowPopupMenu(e);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            private void maybeShowPopupMenu(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    JPopupMenu popup = new JPopupMenu();
                    JMenuItem setRange = new JMenuItem("Set Range..");
                    popup.add(setRange);
                    setRange.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                        }
                    });
                }
            }
        });
        this.jSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                String sfa = String.format("%.2f", JExtendedSlider.this.vA + JExtendedSlider.this.vStep * (double)JExtendedSlider.this.jSlider.getValue());
                JExtendedSlider.this.jValA.setText(sfa);
            }
        });
    }
}

