/*
 * Decompiled with CFR 0.152.
 */
package tech.molecules.leet.table.gui;

import com.actelion.research.chem.ExtendedMolecule;
import com.actelion.research.chem.IsomericSmilesCreator;
import com.actelion.research.chem.Molecule;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.gui.editor.SwingEditorPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import tech.molecules.leet.chem.ChemUtils;

public class JExtendedEditorPanel
extends JPanel {
    private SwingEditorPanel mEditorPanel;
    private JPanel mTop;
    private JPanel mTop_Right;
    private JMenuBar jmb_Main;
    private JMenu jm_Tools;

    public JExtendedEditorPanel() {
        this.reinit();
    }

    private void reinit() {
        this.removeAll();
        StereoMolecule mi = new StereoMolecule();
        mi.setFragment(true);
        this.mEditorPanel = new SwingEditorPanel(new StereoMolecule());
        this.setLayout(new BorderLayout());
        this.add((Component)this.mEditorPanel, "Center");
        this.mTop = new JPanel();
        this.mTop_Right = new JPanel();
        this.mTop.setLayout(new BorderLayout());
        this.add((Component)this.mTop, "North");
        this.mTop.add((Component)this.mTop_Right, "East");
        this.initToolsMenu();
        this.mTop_Right.setLayout(new FlowLayout(2));
        this.jmb_Main = new JMenuBar();
        this.mTop_Right.add(this.jmb_Main);
        this.jmb_Main.add(this.jm_Tools);
    }

    private void initToolsMenu() {
        this.jm_Tools = new JMenu("Tools");
        JMenuItem paste = new JMenuItem("Paste");
        JMenu export_expanded = new JMenu("Export..");
        JMenuItem copy_idcode = new JMenuItem("Copy IDCode");
        JMenuItem copy_smiles = new JMenuItem("Copy Smiles");
        this.jm_Tools.add(paste);
        this.jm_Tools.add(export_expanded);
        export_expanded.add(copy_idcode);
        export_expanded.add(copy_smiles);
        paste.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    String str_data = (String)Toolkit.getDefaultToolkit().getSystemClipboard().getData(DataFlavor.stringFlavor);
                    StereoMolecule m_parsed = ChemUtils.tryParseChemistry((String)str_data);
                    if (m_parsed != null) {
                        StereoMolecule mi = new StereoMolecule((Molecule)JExtendedEditorPanel.this.mEditorPanel.getDrawArea().getMolecule());
                        mi.ensureHelperArrays(31);
                        mi.addFragment((ExtendedMolecule)m_parsed, 0, null);
                        JExtendedEditorPanel.this.mEditorPanel.getDrawArea().setMolecule(m_parsed);
                        JExtendedEditorPanel.this.mEditorPanel.cleanStructure();
                    }
                }
                catch (UnsupportedFlavorException ex) {
                    System.out.println("[WARN] exception");
                }
                catch (IOException ex) {
                    System.out.println("[WARN] exception");
                }
            }
        });
        copy_idcode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String idc = JExtendedEditorPanel.this.mEditorPanel.getDrawArea().getMolecule().getIDCode();
                StringSelection stringSelection = new StringSelection(idc);
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(stringSelection, null);
            }
        });
        copy_smiles.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IsomericSmilesCreator isc = new IsomericSmilesCreator(JExtendedEditorPanel.this.mEditorPanel.getDrawArea().getMolecule());
                String smiles = isc.getSmiles();
                StringSelection stringSelection = new StringSelection(smiles);
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(stringSelection, null);
            }
        });
    }

    public SwingEditorPanel getSwingEditorPanel() {
        return this.mEditorPanel;
    }

    public JMenuBar getMenuBar() {
        return this.jmb_Main;
    }

    private class JExtendedDrawPanelBar {
        private JExtendedDrawPanelBar() {
        }
    }
}

