/*
 * Decompiled with CFR 0.152.
 */
package tech.molecules.leet.table.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.function.Consumer;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.tuple.Pair;
import tech.molecules.leet.table.DefaultClustering;

public class JClusterAndColorConfig
extends JPanel {
    private JLabel jl_cluster;
    private JLabel jl_color;
    private JTextField jtf;
    private JButton jb_col;
    private boolean okPressed = false;
    private Consumer<Pair<String, Color>> callback;

    public boolean wasOK() {
        return this.okPressed;
    }

    public JClusterAndColorConfig(String name, Color col, Consumer<Pair<String, Color>> callback) {
        this.callback = callback;
        this.reinit(name, col);
    }

    private JPanel getThisPanel() {
        return this;
    }

    public String getNewName() {
        return this.jtf.getText();
    }

    public Color getNewColor() {
        return this.jb_col.getBackground();
    }

    private void reinit(String name, Color col) {
        this.removeAll();
        this.setLayout(new BorderLayout());
        JPanel top = new JPanel();
        top.setLayout(new FlowLayout());
        this.jl_cluster = new JLabel("Cluster name: ");
        this.jtf = new JTextField(name, 20);
        this.jl_color = new JLabel("Color: ");
        this.jb_col = new JButton();
        this.jb_col.setPreferredSize(new Dimension(60, 60));
        this.jb_col.setBackground(col);
        this.jb_col.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color c_new = JColorChooser.showDialog(JClusterAndColorConfig.this.getThisPanel(), "Pick color", JClusterAndColorConfig.this.jtf.getBackground());
                JClusterAndColorConfig.this.reinit(JClusterAndColorConfig.this.getNewName(), c_new);
            }
        });
        top.add(this.jl_cluster);
        top.add(this.jtf);
        top.add(this.jb_col);
        JPanel bottom = new JPanel();
        bottom.setLayout(new FlowLayout(2));
        JButton jb_ok = new JButton("OK");
        JButton jb_cancel = new JButton("Cancel");
        jb_ok.setEnabled(true);
        jb_cancel.setEnabled(true);
        bottom.add(jb_ok);
        bottom.add(jb_cancel);
        this.add((Component)top, "Center");
        this.add((Component)bottom, "South");
        jb_cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JClusterAndColorConfig.this.okPressed = false;
                JClusterAndColorConfig.this.callback.accept(null);
            }
        });
        jb_ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JClusterAndColorConfig.this.okPressed = true;
                JClusterAndColorConfig.this.callback.accept(Pair.of((Object)JClusterAndColorConfig.this.getNewName(), (Object)JClusterAndColorConfig.this.getNewColor()));
            }
        });
    }

    public static Pair<String, Color> showDialog(Component parent, DefaultClustering.DefaultClass cluster) {
        JDialog di = new JDialog(SwingUtilities.getWindowAncestor(parent), "Define cluster", Dialog.ModalityType.APPLICATION_MODAL);
        di.setDefaultCloseOperation(2);
        ArrayList newValues = new ArrayList();
        JClusterAndColorConfig pcluster = new JClusterAndColorConfig(cluster.getName(), cluster.getColor(), x -> {
            newValues.add(x);
            di.dispose();
        });
        di.setLocationRelativeTo(parent);
        di.setContentPane(pcluster);
        di.pack();
        di.setVisible(true);
        if (pcluster.wasOK()) {
            return Pair.of((Object)pcluster.getNewName(), (Object)pcluster.getNewColor());
        }
        return null;
    }
}

