/*
 * Decompiled with CFR 0.152.
 */
package tech.molecules.leet.table.gui;

import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class JActivatableTextField
extends JPanel {
    private JCheckBox jba;
    private JLabel jla;
    private JTextField jtf;
    private Function<String, Boolean> validator;
    Consumer callback;

    public JActivatableTextField(String name, boolean activated, String text, int columns, Function<String, Boolean> validator, final Consumer callback) {
        this.validator = validator;
        this.callback = callback;
        if (this.validator == null) {
            this.validator = s -> true;
        }
        if (this.callback == null) {
            this.callback = s -> {};
        }
        this.setLayout(new FlowLayout());
        this.jba = new JCheckBox();
        this.jla = new JLabel(name + " ");
        this.jtf = new JTextField(columns);
        this.jtf.setText(text);
        this.add(this.jba);
        this.add(this.jla);
        this.add(this.jtf);
        this.jba.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JActivatableTextField.this.jtf.setEnabled(JActivatableTextField.this.jba.isSelected());
                callback.accept(null);
            }
        });
        this.jtf.setEnabled(activated);
        this.jba.setSelected(activated);
        this.jtf.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                JActivatableTextField.this.checkValidity();
                callback.accept(null);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                JActivatableTextField.this.checkValidity();
                callback.accept(null);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                JActivatableTextField.this.checkValidity();
                callback.accept(null);
            }
        });
    }

    private void checkValidity() {
        if (!this.validator.apply(this.jtf.getText()).booleanValue()) {
            this.jtf.setBackground(Color.red.brighter());
        } else {
            this.jtf.setBackground(UIManager.getColor("TextField.background"));
        }
    }

    public String getText() {
        return this.jtf.getText();
    }

    public boolean isActivated() {
        return this.jba.isSelected();
    }
}

