/*
 * Decompiled with CFR 0.152.
 */
package tech.molecules.leet.table.gui;

import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;

public class InteractiveJTable
extends JTable {
    private final MouseAdapter twoStageEditingListener = new MouseAdapter(){

        @Override
        public void mouseMoved(MouseEvent e) {
            InteractiveJTable.this.possiblySwitchEditors(e);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            InteractiveJTable.this.possiblySwitchEditors(e);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            InteractiveJTable.this.possiblySwitchEditors(e);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            InteractiveJTable.this.possiblySwitchEditors(e);
        }
    };

    private void possiblySwitchEditors(MouseEvent e) {
        Point p = e.getPoint();
        if (p != null) {
            int row = this.rowAtPoint(p);
            int col = this.columnAtPoint(p);
            if (row != this.getEditingRow() || col != this.getEditingColumn()) {
                TableCellEditor editor;
                if (this.isEditing() && (editor = this.getCellEditor()) instanceof TwoStageTableCellEditor && !((TwoStageTableCellEditor)editor).isInStageTwo() && !editor.stopCellEditing()) {
                    editor.cancelCellEditing();
                }
                if (!this.isEditing() && row != -1 && this.isCellEditable(row, col)) {
                    this.editCellAt(row, col);
                }
            }
        }
    }

    public static interface TwoStageTableCellEditor
    extends TableCellEditor {
        public boolean isFullyEngaged();

        public boolean isInStageTwo();
    }
}

