/*
 * Decompiled with CFR 0.152.
 */
package tech.molecules.leet.table.chem;

import com.actelion.research.chem.IDCodeParser;
import com.actelion.research.chem.StereoMolecule;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import tech.molecules.leet.chem.mutator.properties.ChemPropertyCounts;
import tech.molecules.leet.table.NColumn;
import tech.molecules.leet.table.NDataProvider;
import tech.molecules.leet.table.NStructureDataProvider;
import tech.molecules.leet.table.NexusTableModel;
import tech.molecules.leet.table.gui.JExtendedSlimRangeSlider;
import tech.molecules.leet.table.gui.JSlimRangeSlider;

public class NexusChemPropertiesFilter
implements NColumn.NexusRowFilter<NStructureDataProvider> {
    private NexusTableModel model;
    private boolean removeConnectors = true;
    private NColumn<NDataProvider.StructureWithID, NStructureDataProvider> col;
    private List<ChemPropertyCounts.ChemPropertyCount> consideredCounts = new ArrayList<ChemPropertyCounts.ChemPropertyCount>();
    private Map<ChemPropertyCounts.ChemPropertyCount, int[]> ranges = new HashMap<ChemPropertyCounts.ChemPropertyCount, int[]>();
    private Map<ChemPropertyCounts.ChemPropertyCount, JExtendedSlimRangeSlider> bounds = new HashMap<ChemPropertyCounts.ChemPropertyCount, JExtendedSlimRangeSlider>();
    private JPanel jFilterPanel;

    public NexusChemPropertiesFilter(NColumn<NDataProvider.StructureWithID, NStructureDataProvider> column) {
        this.col = column;
        this.setConsideredCounts(Arrays.asList(ChemPropertyCounts.COUNTS_ALL));
    }

    public void setRemoveConnectors(boolean remove) {
        this.removeConnectors = remove;
    }

    public void setConsideredCounts(List<ChemPropertyCounts.ChemPropertyCount> counts) {
        this.consideredCounts = counts;
    }

    @Override
    public String getFilterName() {
        return "Chemical Properties Filter";
    }

    @Override
    public BitSet filterNexusRows(NStructureDataProvider data, List<String> ids, BitSet filtered) {
        BitSet filtered_2 = (BitSet)filtered.clone();
        IDCodeParser icp = new IDCodeParser();
        for (int zi = 0; zi < ids.size(); ++zi) {
            if (!filtered.get(zi)) continue;
            StereoMolecule mi = new StereoMolecule();
            NDataProvider.StructureWithID s = data.getStructureData(ids.get(zi));
            icp.parse(mi, s.structure[0], s.structure[1]);
            mi.ensureHelperArrays(31);
            for (ChemPropertyCounts.ChemPropertyCount ci : this.consideredCounts) {
                double[] ri;
                int mci = (Integer)ci.evaluator.apply(mi);
                JSlimRangeSlider sli = this.bounds.get(ci).getRangeSlider();
                if (sli == null) {
                    System.out.println("[ERROR] range slider in filter missing..");
                }
                if ((double)mci >= (ri = sli.getRange())[0] && (double)mci <= ri[1]) continue;
                filtered.set(zi, false);
                filtered_2.set(zi, false);
            }
        }
        return filtered_2;
    }

    @Override
    public double getApproximateFilterSpeed() {
        return 0.4;
    }

    @Override
    public void setupFilter(NexusTableModel model, NStructureDataProvider dp) {
        this.model = model;
        this.initRanges(model);
        this.initGUI();
    }

    private void initRanges(NexusTableModel model) {
        NStructureDataProvider data = model.getDatasetForColumn(this.col);
        IDCodeParser icp = new IDCodeParser();
        for (ChemPropertyCounts.ChemPropertyCount ci : this.consideredCounts) {
            int min = 1000000;
            int max = -1000000;
            for (String ri : model.getAllRows()) {
                StereoMolecule mi = new StereoMolecule();
                icp.parse(mi, data.getStructureData((String)ri).structure[0]);
                mi.ensureHelperArrays(31);
                int cci = (Integer)ci.evaluator.apply(mi);
                min = Math.min(min, cci);
                max = Math.max(max, cci);
            }
            this.ranges.put(ci, new int[]{min, max});
        }
    }

    @Override
    public boolean isReady() {
        return true;
    }

    private void initGUI() {
        this.jFilterPanel = new JPanel();
        this.jFilterPanel.setLayout(new BorderLayout());
        int totalNumberOfProperties = this.consideredCounts.size();
        JPanel jp = new JPanel();
        int rows = 4;
        int cols = 4;
        jp.setLayout(new GridLayout(rows, cols));
        for (int zi = 0; zi < this.consideredCounts.size(); ++zi) {
            JExtendedSlimRangeSlider jsi = new JExtendedSlimRangeSlider(this.consideredCounts.get((int)zi).name, new double[]{this.ranges.get(this.consideredCounts.get(zi))[0], this.ranges.get(this.consideredCounts.get(zi))[1]});
            this.bounds.put(this.consideredCounts.get(zi), jsi);
            jp.add(jsi);
            jsi.getRangeSlider().addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    NexusChemPropertiesFilter.this.model.updateFiltering();
                }
            });
        }
        this.jFilterPanel.add((Component)jp, "Center");
    }

    @Override
    public JPanel getFilterGUI() {
        return this.jFilterPanel;
    }
}

