/*
 * Decompiled with CFR 0.152.
 */
package tech.molecules.leet.table.chart;

import com.formdev.flatlaf.FlatLightLaf;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Paint;
import java.awt.Stroke;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeSet;
import javax.swing.JFrame;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.chart.renderer.GrayPaintScale;
import org.jfree.chart.renderer.PaintScale;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYShapeRenderer;
import org.jfree.data.general.DefaultKeyedValuesDataset;
import org.jfree.data.general.KeyedValuesDataset;
import org.jfree.data.xy.AbstractXYDataset;
import org.jfree.data.xy.AbstractXYZDataset;
import org.knowm.xchart.SwingWrapper;
import org.knowm.xchart.XYChart;
import org.knowm.xchart.XYChartBuilder;
import org.knowm.xchart.XYSeries;
import org.knowm.xchart.internal.chartpart.Chart;
import org.knowm.xchart.style.XYStyler;
import tech.molecules.leet.table.NColumn;
import tech.molecules.leet.table.NDataProvider;
import tech.molecules.leet.table.NSimilarityColumn;
import tech.molecules.leet.table.NexusTableModel;

public class XYChartCreator {
    public static void createChart(NexusTableModel ntm, XYChartConfig conf) {
        String lx = conf.xCol.getName() + ":" + conf.xDS;
        String ly = conf.yCol.getName() + ":" + conf.yDS;
        XYChart chart = ((XYChartBuilder)((XYChartBuilder)((XYChartBuilder)new XYChartBuilder().width(600)).height(600)).title("test")).xAxisTitle(lx).yAxisTitle(ly).build();
        ((XYStyler)chart.getStyler()).setDefaultSeriesRenderStyle(XYSeries.XYSeriesRenderStyle.Scatter);
        double[] ddx = XYChartCreator.evaluateNumericalDS(conf.dataset, conf.xCol, conf.xDS, ntm.getAllRows());
        double[] ddy = XYChartCreator.evaluateNumericalDS(conf.dataset, conf.yCol, conf.yDS, ntm.getAllRows());
        chart.addSeries("all", ddx, ddy);
        new SwingWrapper((Chart)chart).displayChart();
    }

    public static void createChart2() {
        ArrayList<String> keys_a = new ArrayList<String>();
        DefaultKeyedValuesDataset data_x = new DefaultKeyedValuesDataset();
        DefaultKeyedValuesDataset data_y = new DefaultKeyedValuesDataset();
        DefaultKeyedValuesDataset data_z = new DefaultKeyedValuesDataset();
        Random r = new Random();
        for (int zi = 0; zi < 4000; ++zi) {
            keys_a.add("data_" + zi);
            data_x.setValue((Comparable)keys_a.get(zi), r.nextDouble());
            data_y.setValue((Comparable)keys_a.get(zi), r.nextDouble());
            data_z.setValue((Comparable)keys_a.get(zi), data_x.getValue((Comparable)keys_a.get(zi)).doubleValue() + data_y.getValue((Comparable)keys_a.get(zi)).doubleValue());
        }
        CombinedKeyedXYDataset data = new CombinedKeyedXYDataset((KeyedValuesDataset)data_x, (KeyedValuesDataset)data_y);
        CombinedKeyedXYZDataset data2 = new CombinedKeyedXYZDataset((KeyedValuesDataset)data_x, (KeyedValuesDataset)data_y, (KeyedValuesDataset)data_z);
        JFreeChart chart = ChartFactory.createScatterPlot((String)"test", (String)"x", (String)"y", data2);
        XYShapeRenderer renderer = new XYShapeRenderer();
        renderer.setPaintScale((PaintScale)new GrayPaintScale());
        chart.getXYPlot().setRenderer((XYItemRenderer)renderer);
        chart.getXYPlot().getChart().getXYPlot().setDomainCrosshairPaint((Paint)new Color(100, 100, 100));
        chart.getXYPlot().getChart().getXYPlot().setDomainCrosshairStroke((Stroke)new BasicStroke(1.0f));
        chart.getXYPlot().getChart().getXYPlot().setDomainCrosshairVisible(true);
        chart.getXYPlot().getChart().getXYPlot().setRangeCrosshairPaint((Paint)new Color(100, 100, 100));
        chart.getXYPlot().getChart().getXYPlot().setRangeCrosshairStroke((Stroke)new BasicStroke(1.0f));
        chart.getXYPlot().getChart().getXYPlot().setRangeCrosshairVisible(true);
        ChartPanel cp = new ChartPanel(chart);
        cp.addChartMouseListener(new ChartMouseListener(){

            public void chartMouseClicked(ChartMouseEvent chartMouseEvent) {
            }

            public void chartMouseMoved(ChartMouseEvent chartMouseEvent) {
                ChartEntity ent = chartMouseEvent.getEntity();
                if (ent != null && ent instanceof XYItemEntity) {
                    System.out.println("Entity: " + ent.toString());
                }
            }
        });
        JFrame fi = new JFrame();
        fi.setDefaultCloseOperation(3);
        fi.getContentPane().setLayout(new BorderLayout());
        fi.getContentPane().add((Component)cp, "Center");
        fi.setSize(400, 400);
        fi.setVisible(true);
    }

    public static void main(String[] args) {
        FlatLightLaf.setup();
        try {
            UIManager.setLookAndFeel((LookAndFeel)new FlatLightLaf());
        }
        catch (Exception ex) {
            System.err.println("Failed to initialize LaF");
        }
        XYChartCreator.createChart2();
    }

    public static double[] evaluateNumericalDS(NDataProvider nd, NColumn c, String ds, List<String> rids) {
        double[] results = new double[rids.size()];
        Map numds = c.getNumericalDataSources();
        for (int zi = 0; zi < rids.size(); ++zi) {
            results[zi] = numds.get(ds).getValue(rids.get(zi));
        }
        return results;
    }

    public static double[][] evaluateSimilarityDS(NDataProvider nd, NSimilarityColumn c, List<String> rids) {
        double[][] results = new double[rids.size()][rids.size()];
        for (int zi = 0; zi < rids.size() - 1; ++zi) {
            for (int zj = zi; zj < rids.size(); ++zj) {
                results[zi][zj] = c.evaluateValue(nd, rids.get(zi), rids.get(zj));
                results[zj][zi] = results[zi][zj];
            }
        }
        return results;
    }

    public static class CombinedKeyedXYZDataset<T extends Comparable>
    extends AbstractXYZDataset
    implements KeyedValuesDataset {
        private List<T> keys = new ArrayList<T>();
        private KeyedValuesDataset dx;
        private KeyedValuesDataset dy;
        private KeyedValuesDataset dz;
        private Map<T, Integer> indeces;

        public CombinedKeyedXYZDataset(KeyedValuesDataset x, KeyedValuesDataset y, KeyedValuesDataset z) {
            this.setKeyedXYZ(x, y, z);
        }

        public void setZ(KeyedValuesDataset zn) {
            this.dz = zn;
            this.fireDatasetChanged();
        }

        public void setKeyedXYZ(KeyedValuesDataset x, KeyedValuesDataset y, KeyedValuesDataset z) {
            TreeSet all_keys = new TreeSet();
            all_keys.addAll(x.getKeys());
            all_keys.addAll(y.getKeys());
            all_keys.addAll(z.getKeys());
            this.keys = new ArrayList<T>(all_keys);
            HashMap<T, Integer> mapToIndeces = new HashMap<T, Integer>();
            for (int zi = 0; zi < this.keys.size(); ++zi) {
                mapToIndeces.put((Comparable)this.keys.get(zi), zi);
            }
            this.indeces = mapToIndeces;
            this.dx = x;
            this.dy = y;
            this.dz = z;
        }

        public int getSeriesCount() {
            return 1;
        }

        public Comparable getSeriesKey(int i) {
            return Integer.valueOf(1);
        }

        public int getItemCount(int i) {
            return this.keys.size();
        }

        public Number getX(int i, int i1) {
            return this.dx.getValue((Comparable)this.keys.get(i1));
        }

        public Number getY(int i, int i1) {
            return this.dy.getValue((Comparable)this.keys.get(i1));
        }

        public Number getZ(int i, int i1) {
            return this.dz.getValue((Comparable)this.keys.get(i1));
        }

        public T getKey(int i) {
            return (T)((Comparable)this.keys.get(i));
        }

        public int getIndex(Comparable comparable) {
            return this.keys.indexOf(comparable);
        }

        public List<T> getKeys() {
            return this.keys;
        }

        public Number getValue(Comparable comparable) {
            return this.dx.getValue(comparable);
        }

        public int getItemCount() {
            return this.keys.size();
        }

        public Number getValue(int i) {
            return this.dx.getValue((Comparable)this.keys.get(i));
        }
    }

    public static class CombinedKeyedXYDataset<T extends Comparable>
    extends AbstractXYDataset {
        List<T> keys = new ArrayList<T>();
        KeyedValuesDataset dx;
        KeyedValuesDataset dy;

        public CombinedKeyedXYDataset(KeyedValuesDataset x, KeyedValuesDataset y) {
            this.setKeyedXY(x, y);
        }

        public void setKeyedXY(KeyedValuesDataset x, KeyedValuesDataset y) {
            TreeSet all_keys = new TreeSet();
            all_keys.addAll(x.getKeys());
            all_keys.addAll(y.getKeys());
            this.keys = new ArrayList<T>(all_keys);
            this.dx = x;
            this.dy = y;
        }

        public int getSeriesCount() {
            return 1;
        }

        public Comparable getSeriesKey(int i) {
            return Integer.valueOf(1);
        }

        public int getItemCount(int i) {
            return this.keys.size();
        }

        public Number getX(int i, int i1) {
            return this.dx.getValue((Comparable)this.keys.get(i1));
        }

        public Number getY(int i, int i1) {
            return this.dy.getValue((Comparable)this.keys.get(i1));
        }
    }

    public static class XYChartConfig {
        public final NDataProvider dataset;
        public final NColumn xCol;
        public final String xDS;
        public final NColumn yCol;
        public final String yDS;

        public XYChartConfig(NDataProvider dataset, NColumn xCol, String xDS, NColumn yCol, String yDS) {
            this.dataset = dataset;
            this.xCol = xCol;
            this.xDS = xDS;
            this.yCol = yCol;
            this.yDS = yDS;
        }
    }
}

