/*
 * Decompiled with CFR 0.152.
 */
package tech.molecules.leet.table.chart;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import net.mahdilamb.colormap.Colormap;
import net.mahdilamb.colormap.Colormaps;
import org.apache.commons.lang3.tuple.Pair;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.annotations.XYAnnotation;
import org.jfree.chart.annotations.XYDrawableAnnotation;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.StandardEntityCollection;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.PaintScale;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYShapeRenderer;
import org.jfree.chart.ui.Drawable;
import org.jfree.data.general.DatasetChangeListener;
import org.jfree.data.general.DatasetGroup;
import org.jfree.data.general.DefaultKeyedValuesDataset;
import org.jfree.data.general.KeyedValuesDataset;
import tech.molecules.leet.table.NexusTableModel;
import tech.molecules.leet.table.NumericalDatasource;
import tech.molecules.leet.table.chart.CircleDrawer;
import tech.molecules.leet.table.chart.JFreeChartScatterPlot;
import tech.molecules.leet.table.chart.MultiCircleDrawer;
import tech.molecules.leet.table.chart.XYChartCreator;
import tech.molecules.leet.util.ColorMapHelper;

public class ScatterPlotModel {
    private NexusTableModel ntm;
    private KeyedValuesDataset dataX;
    private KeyedValuesDataset dataY;
    private DefaultKeyedValuesDataset dataCol;
    double coloringLB = 0.0;
    double coloringUB = 1.0;
    private Set<String> dataHighlight;
    private Set<String> dataSelection;
    private boolean isMouseContextMenuShown = false;
    private List<XYAnnotation> highlightAnnotations = new ArrayList<XYAnnotation>();
    private List<XYAnnotation> selectionAnnotations = new ArrayList<XYAnnotation>();
    private List<XYAnnotation> multiClassAnnotations = new ArrayList<XYAnnotation>();
    private XYShapeRenderer renderer;
    private Colormap colormap;
    private int highlightNNearestNeighbors = 6;
    List<JFreeChartScatterPlot.ScatterPlotListener> listeners = new ArrayList<JFreeChartScatterPlot.ScatterPlotListener>();
    private XYChartCreator.CombinedKeyedXYZDataset<String> data;
    private JFreeChart chart;

    public ScatterPlotModel(NexusTableModel ntm, KeyedValuesDataset x, KeyedValuesDataset y) {
        this.ntm = ntm;
        this.dataX = x;
        this.dataY = y;
        this.reinitPlot();
    }

    public ScatterPlotModel(NexusTableModel ntm, NumericalDatasource nd_x, NumericalDatasource nd_y) {
        this.ntm = ntm;
        this.dataX = new JFreeChartScatterPlot.NumericalDatasourceKeyedDataset(ntm, nd_x);
        this.dataY = new JFreeChartScatterPlot.NumericalDatasourceKeyedDataset(ntm, nd_y);
        this.reinitPlot();
    }

    public boolean setMouseOverClass(NexusTableModel.SelectionType st) {
        return this.ntm.registerSelectionType(st);
    }

    public void setColor(DefaultKeyedValuesDataset data_color) {
        this.dataCol = data_color;
        HashMap<String, Double> cold = new HashMap<String, Double>();
        for (String si : this.ntm.getAllRows()) {
            cold.put(si, data_color.getValue((Comparable)((Object)si)).doubleValue());
        }
        this.setColorValues(cold);
    }

    public void setColorExpclicit(PaintScale colors, Map<String, Integer> values) {
        ((XYShapeRenderer)this.getChart().getXYPlot().getRenderer()).setPaintScale(colors);
        for (String si : this.ntm.getAllRows()) {
            this.dataCol.setValue((Comparable)((Object)si), (Number)values.get(si));
        }
        this.data.setZ((KeyedValuesDataset)this.dataCol);
    }

    public void setColorValues(Map<String, Double> col) {
        double c_min = Double.POSITIVE_INFINITY;
        double c_max = Double.NEGATIVE_INFINITY;
        for (String ci : this.ntm.getAllRows()) {
            Double cvi = col.get(ci);
            if (cvi == null) {
                cvi = Double.NaN;
            }
            System.out.println("v: " + cvi);
            this.dataCol.setValue((Comparable)((Object)ci), (Number)cvi);
            if (!Double.isFinite(cvi)) continue;
            c_min = Math.min(cvi, c_min);
            c_max = Math.max(cvi, c_max);
        }
        double paintscale_min = c_min - Math.max(0.001, (c_max - c_min) * 0.01);
        double paintscale_max = c_max + Math.max(0.001, (c_max - c_min) * 0.01);
        Colormap cm = Colormaps.get((String)"Jet");
        if (this.colormap != null) {
            cm = this.colormap;
        }
        ColorMapHelper.PaintScaleFromColormap psfc = new ColorMapHelper.PaintScaleFromColormap(cm, paintscale_min, paintscale_max, 0.75, new Color(180, 200, 210, 80));
        ((XYShapeRenderer)this.getChart().getXYPlot().getRenderer()).setPaintScale((PaintScale)psfc);
        this.data.setZ((KeyedValuesDataset)this.dataCol);
    }

    public void setColorValues(NumericalDatasource nds) {
        HashMap<String, Double> cvalues = new HashMap<String, Double>();
        for (String ri : this.ntm.getAllRows()) {
            if (!nds.hasValue(ri)) continue;
            cvalues.put(ri, nds.getValue(ri));
        }
        this.setColorValues(cvalues);
    }

    public NexusTableModel getNexusTableModel() {
        return this.ntm;
    }

    public void setColormap(Colormap colormap) {
        this.colormap = colormap;
        this.setColor(this.dataCol);
    }

    public String getKeyForXYEntity(XYItemEntity entity) {
        return this.data.getKey(entity.getItem());
    }

    public void setHighlightNNearestNeighbors(int n) {
        this.highlightNNearestNeighbors = n;
    }

    public void setSelection(Set<String> selection) {
        this.dataSelection = new HashSet<String>(selection);
        this.selectionAnnotations.stream().forEach(ai -> this.getXYPlot().removeAnnotation(ai));
        HashSet hix = new HashSet(selection.stream().map(hi -> this.getIndexForKey((String)hi)).collect(Collectors.toList()));
        this.selectionAnnotations.clear();
        Iterator iterator = hix.iterator();
        while (iterator.hasNext()) {
            int hi2 = (Integer)iterator.next();
            double px = this.data.getX(0, hi2).doubleValue();
            double py = this.data.getY(0, hi2).doubleValue();
            System.out.println("selection: " + px + " / " + py + " idx=" + hi2);
            CircleDrawer circleDrawer = new CircleDrawer(Color.cyan, new BasicStroke(2.0f), new Color(50, 160, 240, 140));
            XYDrawableAnnotation hlan = new XYDrawableAnnotation(px, py, 16.0, 16.0, (Drawable)circleDrawer);
            this.selectionAnnotations.add((XYAnnotation)hlan);
            this.getXYPlot().addAnnotation((XYAnnotation)hlan, true);
        }
    }

    public void setHighlight(Set<String> highlight, boolean fireEvent) {
        this.dataHighlight = highlight;
        this.highlightAnnotations.stream().forEach(ai -> this.chart.getXYPlot().removeAnnotation(ai));
        HashSet hix = new HashSet(highlight.stream().map(hi -> this.getIndexForKey((String)hi)).collect(Collectors.toList()));
        this.highlightAnnotations.clear();
        Iterator iterator = hix.iterator();
        while (iterator.hasNext()) {
            int hi2 = (Integer)iterator.next();
            double px = this.data.getX(0, hi2).doubleValue();
            double py = this.data.getY(0, hi2).doubleValue();
            System.out.println("highlight: " + px + " / " + py + " idx=" + hi2);
            CircleDrawer circleDrawer = new CircleDrawer(Color.red, new BasicStroke(2.0f), new Color(214, 120, 120, 120));
            XYDrawableAnnotation hlan = new XYDrawableAnnotation(px, py, 16.0, 16.0, (Drawable)circleDrawer);
            this.highlightAnnotations.add((XYAnnotation)hlan);
            this.getXYPlot().addAnnotation((XYAnnotation)hlan, true);
        }
        if (fireEvent) {
            this.fireHighlightingChangedEvent(new NexusTableModel.NexusHighlightingChangedEvent(this, highlight));
        }
    }

    public static double[] java2dToChart(ChartPanel cp, XYPlot plot, double px, double py) {
        Rectangle2D plotArea = cp.getScreenDataArea();
        double chartX = plot.getDomainAxis().java2DToValue(px, plotArea, plot.getDomainAxisEdge());
        double chartY = plot.getRangeAxis().java2DToValue(py, plotArea, plot.getRangeAxisEdge());
        return new double[]{chartX, chartY};
    }

    public Map<String, Double> getHighlightMap(Collection<String> highlight) {
        HashMap<String, Double> hmap = new HashMap<String, Double>();
        for (String ri : this.ntm.getVisibleRows()) {
            hmap.put(ri, highlight.contains(ri) ? 1.0 : -1.0);
        }
        return hmap;
    }

    public Map<String, Double> getHighlightMap(EntityCollection entityCollection, EntityCollection toHighlight) {
        HashMap<String, Double> hmap = new HashMap<String, Double>();
        for (int zi = 0; zi < entityCollection.getEntityCount(); ++zi) {
            if (!(entityCollection.getEntity(zi) instanceof XYItemEntity)) continue;
            String ki = this.getKeyForXYEntity((XYItemEntity)entityCollection.getEntity(zi));
            if (toHighlight.getEntities().contains(entityCollection.getEntity(zi))) {
                hmap.put(ki, 1.0);
                continue;
            }
            hmap.put(ki, 0.0);
        }
        return hmap;
    }

    public static EntityCollection getNNearestEntities(EntityCollection entityCollection, int px, int py, int n) {
        StandardEntityCollection ec = new StandardEntityCollection();
        Collection entities = entityCollection.getEntities();
        ArrayList<Pair> entitiesWithD = new ArrayList<Pair>();
        for (int i = 0; i < entities.size(); ++i) {
            if (!(entityCollection.getEntity(i) instanceof XYItemEntity)) continue;
            XYItemEntity entity = (XYItemEntity)entityCollection.getEntity(i);
            double cx = entity.getArea().getBounds().getCenterX();
            double cy = entity.getArea().getBounds().getCenterY();
            entitiesWithD.add(Pair.of((Object)(((double)px - cx) * ((double)px - cx) + ((double)py - cy) * ((double)py - cy)), (Object)entity));
        }
        entitiesWithD.sort((x, y) -> Double.compare((Double)x.getLeft(), (Double)y.getLeft()));
        for (int zi = 0; zi < n; ++zi) {
            ec.add((ChartEntity)((Pair)entitiesWithD.get(zi)).getRight());
        }
        return ec;
    }

    public int getHighlightNNearestNeighbors() {
        return this.highlightNNearestNeighbors;
    }

    public void addScatterPlotListener(JFreeChartScatterPlot.ScatterPlotListener li) {
        this.listeners.add(li);
    }

    public void removeScatterPlotListener(JFreeChartScatterPlot.ScatterPlotListener li) {
        this.listeners.remove(li);
    }

    private void fireHighlightingChangedEvent(NexusTableModel.NexusHighlightingChangedEvent event) {
        for (JFreeChartScatterPlot.ScatterPlotListener li : this.listeners) {
            li.highlightingChanged(event);
        }
    }

    public String getKeyForIndex(int i) {
        return this.data.getKey(i);
    }

    public int getIndexForKey(String key) {
        return this.data.getIndex((Comparable)((Object)key));
    }

    public JFreeChart getChart() {
        if (this.chart == null) {
            this.reinitPlot();
        }
        return this.chart;
    }

    public XYPlot getXYPlot() {
        return this.chart.getXYPlot();
    }

    public void reinitPlot() {
        KeyedValuesDataset px = this.dataX;
        KeyedValuesDataset py = this.dataY;
        DefaultKeyedValuesDataset cc = this.dataCol;
        if (cc == null) {
            Random rand = new Random();
            DefaultKeyedValuesDataset ccn = new DefaultKeyedValuesDataset();
            for (Object ri : px.getKeys()) {
                ccn.setValue((Comparable)((Object)((String)ri)), rand.nextDouble());
            }
            cc = ccn;
            this.dataCol = ccn;
        }
        this.data = new XYChartCreator.CombinedKeyedXYZDataset(px, py, (KeyedValuesDataset)cc);
        this.chart = ChartFactory.createScatterPlot(null, null, null, this.data);
        this.chart.setBorderVisible(true);
        this.chart.setBorderPaint((Paint)Color.orange.darker());
        this.chart.setBorderStroke((Stroke)new BasicStroke(2.0f));
        this.renderer = new XYShapeRenderer();
        this.renderer.setPaintScale((PaintScale)new ColorMapHelper.SpectrumPaintScale(0.0, 1.0));
        this.chart.getXYPlot().setRenderer((XYItemRenderer)this.renderer);
    }

    public XYShapeRenderer getXYShapeRenderer() {
        return this.renderer;
    }

    public void setRendererShapeSize(int size) {
        Ellipse2D.Double ci = new Ellipse2D.Double(-size / 2, -size / 2, size, size);
        this.renderer.setSeriesShape(0, (Shape)ci);
    }

    public void setMultipleAnnotations(Map<String, List<Integer>> classes, Map<Integer, Paint> paints) {
        this.multiClassAnnotations.stream().forEach(ai -> this.getXYPlot().removeAnnotation(ai));
        this.multiClassAnnotations = new ArrayList<XYAnnotation>();
        HashSet hix = new HashSet(classes.keySet().stream().map(hi -> Pair.of((Object)hi, (Object)this.getIndexForKey((String)hi))).collect(Collectors.toList()));
        for (Pair pii : hix) {
            int hi2 = (Integer)pii.getRight();
            String struc = (String)pii.getLeft();
            double px = this.data.getX(0, hi2).doubleValue();
            double py = this.data.getY(0, hi2).doubleValue();
            System.out.println("multiclass: " + px + " / " + py + " idx=" + hi2);
            List<Paint> paints_i = classes.get(struc).stream().map(si -> (Paint)paints.get(si)).collect(Collectors.toList());
            MultiCircleDrawer circleDrawer = new MultiCircleDrawer(paints_i, new BasicStroke(2.0f));
            XYDrawableAnnotation hlan = new XYDrawableAnnotation(px, py, 16.0, 16.0, (Drawable)circleDrawer);
            this.multiClassAnnotations.add((XYAnnotation)hlan);
            this.getXYPlot().addAnnotation((XYAnnotation)hlan, true);
        }
    }

    public void setWithoutAxisAndLegend() {
        this.chart.removeLegend();
        this.chart.getXYPlot().setBackgroundPaint((Paint)Color.black);
        this.chart.setBackgroundPaint((Paint)Color.black);
        this.chart.getXYPlot().setDomainGridlinesVisible(false);
        this.chart.getXYPlot().setRangeGridlinesVisible(false);
        this.chart.getXYPlot().getDomainAxis().setVisible(false);
        this.chart.getXYPlot().getRangeAxis().setVisible(false);
    }

    public class SetClusteringAnnotationsAction
    extends AbstractAction {
        private List<Pair<Color, List<String>>> clustering;

        public SetClusteringAnnotationsAction(String name, List<Pair<Color, List<String>>> clustering) {
            super(name);
            this.clustering = clustering;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            HashMap<Integer, Paint> paints = new HashMap<Integer, Paint>();
            HashMap<String, List<Integer>> clustered = new HashMap<String, List<Integer>>();
            for (int zi = 0; zi < this.clustering.size(); ++zi) {
                Pair<Color, List<String>> pci = this.clustering.get(zi);
                paints.put(zi, (Paint)pci.getLeft());
                for (String struci : (List)pci.getRight()) {
                    if (!clustered.containsKey(struci)) {
                        clustered.put(struci, new ArrayList());
                    }
                    ((List)clustered.get(struci)).add(zi);
                }
            }
            ScatterPlotModel.this.setMultipleAnnotations(clustered, paints);
        }
    }

    public static class SetColorNumericalDatasource
    extends AbstractAction {
        private List<ScatterPlotModel> fcs;
        private NumericalDatasource nds;

        public SetColorNumericalDatasource(List<ScatterPlotModel> fcs, NumericalDatasource nds) {
            super(nds.getName());
            this.fcs = fcs;
            this.nds = nds;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (ScatterPlotModel fc2 : this.fcs) {
                fc2.setColorValues(this.nds);
            }
        }
    }

    public static class SetPointSizeAction
    extends AbstractAction {
        private List<ScatterPlotModel> fcs;
        private int size;

        public SetPointSizeAction(List<ScatterPlotModel> fcs, int size) {
            super("Set point size to " + String.format("%d", size));
            this.fcs = fcs;
            this.size = size;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (ScatterPlotModel fc2 : this.fcs) {
                fc2.setRendererShapeSize(this.size);
            }
        }
    }

    public static class NumericalDatasourceKeyedDataset<U>
    implements KeyedValuesDataset {
        private NexusTableModel ntm;
        private NumericalDatasource<U> nds;
        private List<DatasetChangeListener> listeners = new ArrayList<DatasetChangeListener>();
        private DatasetGroup group;

        public NumericalDatasourceKeyedDataset(NexusTableModel ntm, NumericalDatasource<U> nds) {
            this.ntm = ntm;
            this.nds = nds;
            this.reinit();
        }

        private void reinit() {
        }

        public Comparable getKey(int i) {
            return (Comparable)((Object)this.ntm.getVisibleRows().get(i));
        }

        public int getIndex(Comparable comparable) {
            return this.ntm.getVisibleRows().indexOf(comparable);
        }

        public List getKeys() {
            return this.ntm.getVisibleRows();
        }

        public Number getValue(Comparable comparable) {
            if (this.nds.hasValue((String)((Object)comparable))) {
                return this.nds.getValue((String)((Object)comparable));
            }
            return null;
        }

        public int getItemCount() {
            return this.ntm.getVisibleRows().size();
        }

        public Number getValue(int i) {
            String ri = this.ntm.getVisibleRows().get(i);
            if (this.nds.hasValue(ri)) {
                return this.nds.getValue(ri);
            }
            return null;
        }

        public void addChangeListener(DatasetChangeListener datasetChangeListener) {
            this.listeners.add(datasetChangeListener);
        }

        public void removeChangeListener(DatasetChangeListener datasetChangeListener) {
            this.listeners.remove(datasetChangeListener);
        }

        public DatasetGroup getGroup() {
            return this.group;
        }

        public void setGroup(DatasetGroup datasetGroup) {
            this.group = datasetGroup;
        }
    }

    public static interface ScatterPlotListener {
        public void highlightingChanged(NexusTableModel.NexusHighlightingChangedEvent var1);

        public void selectionChanged(NexusTableModel.NexusSelectionChangedEvent var1);
    }
}

