/*
 * Decompiled with CFR 0.152.
 */
package tech.molecules.leet.table.chart;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.util.List;
import org.jfree.chart.ui.Drawable;

public class MultiCircleDrawer
implements Drawable {
    private List<Paint> outlinePaints;
    private Stroke outlineStroke;

    public MultiCircleDrawer(List<Paint> outlinePaints, Stroke outlineStroke) {
        this.outlinePaints = outlinePaints;
        this.outlineStroke = outlineStroke;
    }

    public void draw(Graphics2D g2, Rectangle2D area) {
        g2.setStroke(this.outlineStroke);
        double currentDegree = 0.0;
        double degreePerArc = 360.0 / (double)this.outlinePaints.size();
        if (this.outlinePaints.size() == 2) {
            currentDegree = 90.0;
        }
        if (this.outlinePaints.size() == 3) {
            currentDegree = 120.0;
        }
        for (Paint pi : this.outlinePaints) {
            g2.setPaint(pi);
            int ax = (int)area.getX();
            int ay = (int)area.getY();
            int aw = (int)area.getWidth();
            int ah = (int)area.getHeight();
            g2.drawArc(ax, ay, aw, ah, (int)currentDegree, (int)degreePerArc);
            currentDegree += degreePerArc;
            currentDegree %= 360.0;
        }
    }
}

