/*
 * Decompiled with CFR 0.152.
 */
package tech.molecules.leet.table.chart;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import tech.molecules.leet.table.NexusTableModel;
import tech.molecules.leet.table.chart.ScatterPlotModel;
import tech.molecules.leet.table.gui.JNumericalDataSourceSelector;

public class JScatterPlotConfigurationMenuBar
extends JMenuBar {
    private NexusTableModel ntm;
    private List<ScatterPlotModel> models = new ArrayList<ScatterPlotModel>();

    public void addModel(ScatterPlotModel mi) {
        this.models.add(mi);
    }

    public boolean removeModel(ScatterPlotModel mi) {
        return this.models.remove(mi);
    }

    public JScatterPlotConfigurationMenuBar(NexusTableModel ntm) {
        this.ntm = ntm;
        this.init();
    }

    private void init() {
    }

    public static void initMenuBar(JMenuBar jmb, NexusTableModel ntm, final List<ScatterPlotModel> scatterplots) {
        JMenu jmsize = new JMenu("Marker");
        jmsize.add(new ScatterPlotModel.SetPointSizeAction(scatterplots, 2));
        jmsize.add(new ScatterPlotModel.SetPointSizeAction(scatterplots, 4));
        jmsize.add(new ScatterPlotModel.SetPointSizeAction(scatterplots, 8));
        jmsize.add(new ScatterPlotModel.SetPointSizeAction(scatterplots, 16));
        jmb.add(jmsize);
        JMenu jmcolor = new JMenu("Color");
        final JNumericalDataSourceSelector jndss = new JNumericalDataSourceSelector(new JNumericalDataSourceSelector.NumericalDataSourceSelectorModel(ntm), JNumericalDataSourceSelector.SELECTOR_MODE.OnlyJMenu);
        JMenu jnds = jndss.getMenu();
        jnds.setText("From Numerical Datasource");
        jmcolor.add(jnds);
        jndss.addSelectionListener(new JNumericalDataSourceSelector.SelectionListener(){

            @Override
            public void selectionChanged() {
                for (ScatterPlotModel jf : scatterplots) {
                    jf.setColorValues(jndss.getModel().getSelectedDatasource());
                }
            }
        });
        jmb.add(jmcolor);
    }
}

