/*
 * Decompiled with CFR 0.152.
 */
package tech.molecules.leet.table.chart;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.XYItemEntity;
import tech.molecules.leet.table.chart.JScatterPlotConfigurationMenuBar;
import tech.molecules.leet.table.chart.ScatterPlotModel;

public class JFreeChartScatterPlot2
extends JPanel {
    private ScatterPlotModel model;
    private ChartPanel cp;
    private boolean initMenuBar;
    private JMenuBar jmb;

    public JFreeChartScatterPlot2(ScatterPlotModel mi) {
        this(mi, true);
    }

    public JFreeChartScatterPlot2(ScatterPlotModel mi, boolean createMenuBar) {
        this.model = mi;
        this.initMenuBar = createMenuBar;
        this.init();
    }

    public ChartPanel getChartPanel() {
        return this.cp;
    }

    private void init() {
        JFreeChart chart = this.model.getChart();
        this.cp = new ChartPanel(chart);
        this.jmb = new JMenuBar();
        this.removeAll();
        this.setLayout(new BorderLayout());
        this.add((Component)this.cp, "Center");
        if (this.initMenuBar) {
            this.jmb = new JMenuBar();
            JScatterPlotConfigurationMenuBar.initMenuBar(this.jmb, this.model.getNexusTableModel(), Collections.singletonList(this.model));
            this.add((Component)this.jmb, "North");
        }
        this.cp.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                if (!JFreeChartScatterPlot2.this.contains(e.getX(), e.getY())) {
                    JFreeChartScatterPlot2.this.model.setHighlight(new HashSet<String>(), true);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }
        });
        this.cp.addChartMouseListener(new ChartMouseListener(){

            public void chartMouseClicked(ChartMouseEvent chartMouseEvent) {
            }

            public void chartMouseMoved(ChartMouseEvent chartMouseEvent) {
                int highlightNNearestNeighbors;
                ChartEntity ent = chartMouseEvent.getEntity();
                if (ent != null && ent instanceof XYItemEntity) {
                    System.out.println("Entity: " + ent.toString());
                }
                if ((highlightNNearestNeighbors = JFreeChartScatterPlot2.this.model.getHighlightNNearestNeighbors()) >= 1) {
                    EntityCollection all_e = JFreeChartScatterPlot2.this.cp.getChartRenderingInfo().getEntityCollection();
                    EntityCollection ec = ScatterPlotModel.getNNearestEntities(all_e, chartMouseEvent.getTrigger().getX(), chartMouseEvent.getTrigger().getY(), highlightNNearestNeighbors);
                    System.out.println("to highlight: ");
                    for (Object cei : ec.getEntities()) {
                        System.out.println("nearest: " + cei.toString());
                    }
                    List h_keys = ec.getEntities().stream().map(ei -> JFreeChartScatterPlot2.this.model.getKeyForXYEntity((XYItemEntity)ei)).collect(Collectors.toList());
                    JFreeChartScatterPlot2.this.model.setHighlight(new HashSet<String>(h_keys), true);
                }
            }
        });
    }

    public double[] getPositionOfKey(String ski) {
        int ki = this.getModel().getIndexForKey(ski);
        double kpx = this.cp.getChartRenderingInfo().getEntityCollection().getEntity(ki).getArea().getBounds2D().getCenterX();
        double kpy = this.cp.getChartRenderingInfo().getEntityCollection().getEntity(ki).getArea().getBounds2D().getCenterY();
        return new double[]{kpx, kpy};
    }

    public ScatterPlotModel getModel() {
        return this.model;
    }
}

