/*
 * Decompiled with CFR 0.152.
 */
package tech.molecules.leet.table.chart;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import net.mahdilamb.colormap.Colormap;
import net.mahdilamb.colormap.Colormaps;
import org.apache.commons.lang3.tuple.Pair;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.annotations.XYAnnotation;
import org.jfree.chart.annotations.XYDrawableAnnotation;
import org.jfree.chart.annotations.XYPolygonAnnotation;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.StandardEntityCollection;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.PaintScale;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYShapeRenderer;
import org.jfree.chart.ui.Drawable;
import org.jfree.data.general.DatasetChangeListener;
import org.jfree.data.general.DatasetGroup;
import org.jfree.data.general.DefaultKeyedValuesDataset;
import org.jfree.data.general.KeyedValuesDataset;
import tech.molecules.leet.table.NColumn;
import tech.molecules.leet.table.NexusTableModel;
import tech.molecules.leet.table.NumericalDatasource;
import tech.molecules.leet.table.chart.CircleDrawer;
import tech.molecules.leet.table.chart.JFreeChartPlotLasso;
import tech.molecules.leet.table.chart.MultiCircleDrawer;
import tech.molecules.leet.table.chart.XYChartCreator;

public class JFreeChartScatterPlot
extends JPanel {
    private ChartPanel cp;
    private NexusTableModel ntm;
    private KeyedValuesDataset dataX;
    private KeyedValuesDataset dataY;
    private DefaultKeyedValuesDataset dataCol;
    double coloringLB = 0.0;
    double coloringUB = 1.0;
    private Set<String> dataHighlight;
    private Set<String> dataSelection;
    private Colormap colormap;
    private boolean isMouseContextMenuShown = false;
    private List<XYAnnotation> highlightAnnotations = new ArrayList<XYAnnotation>();
    private List<XYAnnotation> selectionAnnotations = new ArrayList<XYAnnotation>();
    private List<XYAnnotation> multiClassAnnotations = new ArrayList<XYAnnotation>();
    private Map<String, Double> lastColorValues;
    private XYChartCreator.CombinedKeyedXYZDataset<String> data;
    private int highlightNNearestNeighbors = 6;
    List<ScatterPlotListener> listeners = new ArrayList<ScatterPlotListener>();

    public JFreeChartScatterPlot(NexusTableModel ntm, KeyedValuesDataset x, KeyedValuesDataset y) {
        this.ntm = ntm;
        this.dataX = x;
        this.dataY = y;
        this.updatePlot();
    }

    public JFreeChartScatterPlot(NexusTableModel ntm, NumericalDatasource nd_x, NumericalDatasource nd_y) {
        this.ntm = ntm;
        this.dataX = new NumericalDatasourceKeyedDataset(ntm, nd_x);
        this.dataY = new NumericalDatasourceKeyedDataset(ntm, nd_y);
        this.updatePlot();
    }

    public void setColor(DefaultKeyedValuesDataset data_color) {
        this.dataCol = data_color;
        HashMap<String, Double> cold = new HashMap<String, Double>();
        for (String si : this.ntm.getAllRows()) {
            cold.put(si, data_color.getValue((Comparable)((Object)si)).doubleValue());
        }
        this.setColorValues(cold);
    }

    public void setColormap(Colormap colormap) {
        this.colormap = colormap;
        this.setColor(this.dataCol);
    }

    public double[] getPositionOfKey(String ski) {
        int ki = this.getIndexForKey(ski);
        double kpx = this.cp.getChartRenderingInfo().getEntityCollection().getEntity(ki).getArea().getBounds2D().getCenterX();
        double kpy = this.cp.getChartRenderingInfo().getEntityCollection().getEntity(ki).getArea().getBounds2D().getCenterY();
        return new double[]{kpx, kpy};
    }

    public void setSelection(Set<String> selection) {
        this.dataSelection = new HashSet<String>(selection);
        this.selectionAnnotations.stream().forEach(ai -> this.cp.getChart().getXYPlot().removeAnnotation(ai));
        HashSet hix = new HashSet(selection.stream().map(hi -> this.getIndexForKey((String)hi)).collect(Collectors.toList()));
        this.selectionAnnotations.clear();
        Iterator iterator = hix.iterator();
        while (iterator.hasNext()) {
            int hi2 = (Integer)iterator.next();
            double px = this.data.getX(0, hi2).doubleValue();
            double py = this.data.getY(0, hi2).doubleValue();
            System.out.println("selection: " + px + " / " + py + " idx=" + hi2);
            CircleDrawer circleDrawer = new CircleDrawer(Color.cyan, new BasicStroke(2.0f), new Color(50, 160, 240, 140));
            XYDrawableAnnotation hlan = new XYDrawableAnnotation(px, py, 16.0, 16.0, (Drawable)circleDrawer);
            this.selectionAnnotations.add((XYAnnotation)hlan);
            this.cp.getChart().getXYPlot().addAnnotation((XYAnnotation)hlan, true);
        }
    }

    public void setHighlight(Set<String> highlight, boolean fireEvent) {
        this.dataHighlight = highlight;
        this.highlightAnnotations.stream().forEach(ai -> this.cp.getChart().getXYPlot().removeAnnotation(ai));
        HashSet hix = new HashSet(highlight.stream().map(hi -> this.getIndexForKey((String)hi)).collect(Collectors.toList()));
        this.highlightAnnotations.clear();
        Iterator iterator = hix.iterator();
        while (iterator.hasNext()) {
            int hi2 = (Integer)iterator.next();
            double px = this.data.getX(0, hi2).doubleValue();
            double py = this.data.getY(0, hi2).doubleValue();
            System.out.println("highlight: " + px + " / " + py + " idx=" + hi2);
            CircleDrawer circleDrawer = new CircleDrawer(Color.red, new BasicStroke(2.0f), new Color(214, 120, 120, 120));
            XYDrawableAnnotation hlan = new XYDrawableAnnotation(px, py, 16.0, 16.0, (Drawable)circleDrawer);
            this.highlightAnnotations.add((XYAnnotation)hlan);
            this.cp.getChart().getXYPlot().addAnnotation((XYAnnotation)hlan, true);
        }
        if (fireEvent) {
            // empty if block
        }
    }

    public void setMultipleAnnotations(Map<String, List<Integer>> classes, Map<Integer, Paint> paints) {
        this.multiClassAnnotations.stream().forEach(ai -> this.cp.getChart().getXYPlot().removeAnnotation(ai));
        this.multiClassAnnotations = new ArrayList<XYAnnotation>();
        HashSet hix = new HashSet(classes.keySet().stream().map(hi -> Pair.of((Object)hi, (Object)this.getIndexForKey((String)hi))).collect(Collectors.toList()));
        for (Pair pii : hix) {
            int hi2 = (Integer)pii.getRight();
            String struc = (String)pii.getLeft();
            double px = this.data.getX(0, hi2).doubleValue();
            double py = this.data.getY(0, hi2).doubleValue();
            System.out.println("multiclass: " + px + " / " + py + " idx=" + hi2);
            List<Paint> paints_i = classes.get(struc).stream().map(si -> (Paint)paints.get(si)).collect(Collectors.toList());
            MultiCircleDrawer circleDrawer = new MultiCircleDrawer(paints_i, new BasicStroke(2.0f));
            XYDrawableAnnotation hlan = new XYDrawableAnnotation(px, py, 16.0, 16.0, (Drawable)circleDrawer);
            this.multiClassAnnotations.add((XYAnnotation)hlan);
            this.cp.getChart().getXYPlot().addAnnotation((XYAnnotation)hlan, true);
        }
    }

    public void setColorValues(Map<String, Double> col) {
        double c_min = Double.POSITIVE_INFINITY;
        double c_max = Double.NEGATIVE_INFINITY;
        for (String ci : this.ntm.getAllRows()) {
            Double cvi = col.get(ci);
            if (cvi == null) {
                cvi = Double.NaN;
            }
            System.out.println("v: " + cvi);
            this.dataCol.setValue((Comparable)((Object)ci), (Number)cvi);
            if (!Double.isFinite(cvi)) continue;
            c_min = Math.min(cvi, c_min);
            c_max = Math.max(cvi, c_max);
        }
        double paintscale_min = c_min - Math.max(0.001, (c_max - c_min) * 0.01);
        double paintscale_max = c_max + Math.max(0.001, (c_max - c_min) * 0.01);
        Colormap cm = Colormaps.get((String)"Jet");
        if (this.colormap != null) {
            cm = this.colormap;
        }
        PaintScaleFromColormap psfc = new PaintScaleFromColormap(cm, paintscale_min, paintscale_max, 0.75, new Color(180, 200, 210, 80));
        ((XYShapeRenderer)this.cp.getChart().getXYPlot().getRenderer()).setPaintScale((PaintScale)psfc);
        this.data.setZ((KeyedValuesDataset)this.dataCol);
    }

    public String getKeyForIndex(int i) {
        return this.data.getKey(i);
    }

    public int getIndexForKey(String key) {
        return this.data.getIndex((Comparable)((Object)key));
    }

    public void setColoringByNexusColumn(NColumn nc) {
        HashMap<String, Double> col_values = new HashMap<String, Double>();
        Map numds = nc.getNumericalDataSources();
        for (String si : this.ntm.getAllRows()) {
            col_values.put(si, numds.get("").getValue(si));
        }
        this.setColorValues(col_values);
    }

    public void setContextMenu(JPopupMenu jpop) {
        this.cp.setPopupMenu(jpop);
    }

    public String getKeyForXYEntity(XYItemEntity entity) {
        return this.data.getKey(entity.getItem());
    }

    public void updatePlot() {
        KeyedValuesDataset px = this.dataX;
        KeyedValuesDataset py = this.dataY;
        DefaultKeyedValuesDataset cc = this.dataCol;
        if (cc == null) {
            Random rand = new Random();
            DefaultKeyedValuesDataset ccn = new DefaultKeyedValuesDataset();
            for (String ri : this.ntm.getAllRows()) {
                ccn.setValue((Comparable)((Object)ri), rand.nextDouble());
            }
            cc = ccn;
            this.dataCol = ccn;
        }
        this.data = new XYChartCreator.CombinedKeyedXYZDataset(px, py, (KeyedValuesDataset)cc);
        JFreeChart chart = ChartFactory.createScatterPlot(null, null, null, this.data);
        chart.removeLegend();
        chart.getXYPlot().setBackgroundPaint((Paint)Color.black);
        chart.setBackgroundPaint((Paint)Color.black);
        chart.getXYPlot().setDomainGridlinesVisible(false);
        chart.getXYPlot().setRangeGridlinesVisible(false);
        chart.getXYPlot().getDomainAxis().setVisible(false);
        chart.getXYPlot().getRangeAxis().setVisible(false);
        chart.setBorderVisible(true);
        chart.setBorderPaint((Paint)Color.orange.darker());
        chart.setBorderStroke((Stroke)new BasicStroke(2.0f));
        XYShapeRenderer renderer = new XYShapeRenderer();
        renderer.setPaintScale((PaintScale)new SpectrumPaintScale(0.0, 1.0));
        chart.getXYPlot().setRenderer((XYItemRenderer)renderer);
        this.cp = new ChartPanel(chart);
        this.removeAll();
        this.setLayout(new BorderLayout());
        this.add((Component)this.cp, "Center");
        this.cp.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                if (!JFreeChartScatterPlot.this.contains(e.getX(), e.getY())) {
                    JFreeChartScatterPlot.this.setHighlight(new HashSet<String>(), true);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }
        });
        this.cp.addChartMouseListener(new ChartMouseListener(){

            public void chartMouseClicked(ChartMouseEvent chartMouseEvent) {
                if (chartMouseEvent.getTrigger().getButton() == 3) {
                    JFreeChartScatterPlot.this.isMouseContextMenuShown = true;
                }
            }

            public void chartMouseMoved(ChartMouseEvent chartMouseEvent) {
                ChartEntity ent = chartMouseEvent.getEntity();
                if (ent != null && ent instanceof XYItemEntity) {
                    System.out.println("Entity: " + ent.toString());
                }
                if (JFreeChartScatterPlot.this.highlightNNearestNeighbors >= 1) {
                    EntityCollection all_e = JFreeChartScatterPlot.this.cp.getChartRenderingInfo().getEntityCollection();
                    EntityCollection ec = JFreeChartScatterPlot.getNNearestEntities(all_e, chartMouseEvent.getTrigger().getX(), chartMouseEvent.getTrigger().getY(), JFreeChartScatterPlot.this.highlightNNearestNeighbors);
                    System.out.println("to highlight: ");
                    for (Object cei : ec.getEntities()) {
                        System.out.println("nearest: " + cei.toString());
                    }
                    List h_keys = ec.getEntities().stream().map(ei -> JFreeChartScatterPlot.this.getKeyForXYEntity((XYItemEntity)ei)).collect(Collectors.toList());
                    JFreeChartScatterPlot.this.setHighlight(new HashSet<String>(h_keys), true);
                }
            }
        });
        LassoMouseListener lassoML = new LassoMouseListener();
        this.cp.addChartMouseListener((ChartMouseListener)lassoML);
    }

    public void setHighlightNNearestNeighbors(int n) {
        this.highlightNNearestNeighbors = n;
    }

    public static double[] java2dToChart(ChartPanel cp, XYPlot plot, double px, double py) {
        Rectangle2D plotArea = cp.getScreenDataArea();
        double chartX = plot.getDomainAxis().java2DToValue(px, plotArea, plot.getDomainAxisEdge());
        double chartY = plot.getRangeAxis().java2DToValue(py, plotArea, plot.getRangeAxisEdge());
        return new double[]{chartX, chartY};
    }

    public Map<String, Double> getHighlightMap(Collection<String> highlight) {
        HashMap<String, Double> hmap = new HashMap<String, Double>();
        for (String ri : this.ntm.getVisibleRows()) {
            hmap.put(ri, highlight.contains(ri) ? 1.0 : -1.0);
        }
        return hmap;
    }

    public Map<String, Double> getHighlightMap(EntityCollection entityCollection, EntityCollection toHighlight) {
        HashMap<String, Double> hmap = new HashMap<String, Double>();
        for (int zi = 0; zi < entityCollection.getEntityCount(); ++zi) {
            if (!(entityCollection.getEntity(zi) instanceof XYItemEntity)) continue;
            String ki = this.getKeyForXYEntity((XYItemEntity)entityCollection.getEntity(zi));
            if (toHighlight.getEntities().contains(entityCollection.getEntity(zi))) {
                hmap.put(ki, 1.0);
                continue;
            }
            hmap.put(ki, 0.0);
        }
        return hmap;
    }

    public static EntityCollection getNNearestEntities(EntityCollection entityCollection, int px, int py, int n) {
        StandardEntityCollection ec = new StandardEntityCollection();
        Collection entities = entityCollection.getEntities();
        ArrayList<Pair> entitiesWithD = new ArrayList<Pair>();
        for (int i = 0; i < entities.size(); ++i) {
            if (!(entityCollection.getEntity(i) instanceof XYItemEntity)) continue;
            XYItemEntity entity = (XYItemEntity)entityCollection.getEntity(i);
            double cx = entity.getArea().getBounds().getCenterX();
            double cy = entity.getArea().getBounds().getCenterY();
            entitiesWithD.add(Pair.of((Object)(((double)px - cx) * ((double)px - cx) + ((double)py - cy) * ((double)py - cy)), (Object)entity));
        }
        entitiesWithD.sort((x, y) -> Double.compare((Double)x.getLeft(), (Double)y.getLeft()));
        for (int zi = 0; zi < n; ++zi) {
            ec.add((ChartEntity)((Pair)entitiesWithD.get(zi)).getRight());
        }
        return ec;
    }

    public void addScatterPlotListener(ScatterPlotListener li) {
        this.listeners.add(li);
    }

    public void removeScatterPlotListener(ScatterPlotListener li) {
        this.listeners.remove(li);
    }

    private void fireHighlightingChangedEvent(NexusTableModel.NexusHighlightingChangedEvent event) {
        for (ScatterPlotListener li : this.listeners) {
            li.highlightingChanged(event);
        }
    }

    public static class NumericalDatasourceKeyedDataset<U>
    implements KeyedValuesDataset {
        private NexusTableModel ntm;
        private NumericalDatasource<U> nds;
        private List<DatasetChangeListener> listeners = new ArrayList<DatasetChangeListener>();
        private DatasetGroup group;

        public NumericalDatasourceKeyedDataset(NexusTableModel ntm, NumericalDatasource<U> nds) {
            this.ntm = ntm;
            this.nds = nds;
            this.reinit();
        }

        private void reinit() {
        }

        public Comparable getKey(int i) {
            return (Comparable)((Object)this.ntm.getVisibleRows().get(i));
        }

        public int getIndex(Comparable comparable) {
            return this.ntm.getVisibleRows().indexOf(comparable);
        }

        public List getKeys() {
            return this.ntm.getVisibleRows();
        }

        public Number getValue(Comparable comparable) {
            if (this.nds.hasValue((String)((Object)comparable))) {
                return this.nds.getValue((String)((Object)comparable));
            }
            return null;
        }

        public int getItemCount() {
            return this.ntm.getVisibleRows().size();
        }

        public Number getValue(int i) {
            String ri = this.ntm.getVisibleRows().get(i);
            if (this.nds.hasValue(ri)) {
                return this.nds.getValue(ri);
            }
            return null;
        }

        public void addChangeListener(DatasetChangeListener datasetChangeListener) {
            this.listeners.add(datasetChangeListener);
        }

        public void removeChangeListener(DatasetChangeListener datasetChangeListener) {
            this.listeners.remove(datasetChangeListener);
        }

        public DatasetGroup getGroup() {
            return this.group;
        }

        public void setGroup(DatasetGroup datasetGroup) {
            this.group = datasetGroup;
        }
    }

    private static class SpectrumPaintScale
    implements PaintScale {
        private static final float H1 = 0.25f;
        private static final float H2 = 0.75f;
        private final double lowerBound;
        private final double upperBound;

        public SpectrumPaintScale(double lowerBound, double upperBound) {
            this.lowerBound = lowerBound;
            this.upperBound = upperBound;
        }

        public double getLowerBound() {
            return this.lowerBound;
        }

        public double getUpperBound() {
            return this.upperBound;
        }

        public Paint getPaint(double value) {
            float scaledValue = (float)(value / (this.getUpperBound() - this.getLowerBound()));
            float scaledH = 0.25f + scaledValue * 0.5f;
            return Color.getHSBColor(scaledH, 1.0f, 1.0f);
        }
    }

    private static class PaintScaleFromColormap
    implements PaintScale {
        private Colormap cm;
        private double lb;
        private double ub;
        double transparency;
        Color nanColor;

        public PaintScaleFromColormap(Colormap cm, double lb, double ub, double transparency, Color nanColor) {
            this.cm = cm;
            this.lb = lb;
            this.ub = ub;
            this.transparency = transparency;
            this.nanColor = nanColor;
        }

        public double getLowerBound() {
            return this.lb;
        }

        public double getUpperBound() {
            return this.ub;
        }

        public Paint getPaint(double v) {
            if (Double.isNaN(v) && this.nanColor != null) {
                return this.nanColor;
            }
            double va = (v - this.lb) / (this.ub - this.lb);
            Color ca = this.cm.get(va);
            return new Color(ca.getRed(), ca.getGreen(), ca.getBlue(), (int)(255.0 * this.transparency));
        }
    }

    public class LassoMouseListener
    implements ChartMouseListener {
        private LASSO_STATE state = LASSO_STATE.NONE;
        JFreeChartPlotLasso lasso = null;
        XYPolygonAnnotation lassoAnnotation = null;

        public void chartMouseClicked(ChartMouseEvent chartMouseEvent) {
            if (chartMouseEvent.getTrigger().isShiftDown() && this.state == LASSO_STATE.NONE) {
                double[] xy = new double[]{chartMouseEvent.getTrigger().getPoint().x, chartMouseEvent.getTrigger().getPoint().y};
                this.state = LASSO_STATE.DRAGGING;
                this.lasso = new JFreeChartPlotLasso(xy[0], xy[1]);
                System.out.println("start drag..");
                Path2D lpath = (Path2D)this.lasso.getPath().clone();
                if (this.lassoAnnotation != null) {
                    chartMouseEvent.getChart().getXYPlot().removeAnnotation((XYAnnotation)this.lassoAnnotation);
                }
                this.lassoAnnotation = this.createAnnotationFromPath(lpath);
                chartMouseEvent.getChart().getXYPlot().addAnnotation((XYAnnotation)this.lassoAnnotation);
            } else if (this.state == LASSO_STATE.DRAGGING) {
                this.state = LASSO_STATE.NONE;
                this.lasso.close();
                EntityCollection all_e = JFreeChartScatterPlot.this.cp.getChartRenderingInfo().getEntityCollection();
                EntityCollection ec = this.lasso.getContainedEntities(all_e);
                System.out.println("selected entities: " + ec.getEntities().size());
                chartMouseEvent.getChart().getXYPlot().removeAnnotation((XYAnnotation)this.lassoAnnotation);
                this.lassoAnnotation = null;
            }
        }

        public double[] dumpPathIteratorCoords(PathIterator pathIterator) {
            ArrayList<Double> path = new ArrayList<Double>();
            float[] coords = new float[6];
            while (!pathIterator.isDone()) {
                switch (pathIterator.currentSegment(coords)) {
                    case 0: {
                        path.add(Double.valueOf(coords[0]));
                        path.add(Double.valueOf(coords[1]));
                        break;
                    }
                    case 1: {
                        path.add(Double.valueOf(coords[0]));
                        path.add(Double.valueOf(coords[1]));
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 3: {
                        break;
                    }
                }
                pathIterator.next();
            }
            return path.stream().mapToDouble(xi -> xi).toArray();
        }

        private XYPolygonAnnotation createAnnotationFromPath(Path2D path) {
            path.closePath();
            PathIterator pi = path.getPathIterator(AffineTransform.getScaleInstance(1.0, 1.0));
            double[] points = this.dumpPathIteratorCoords(pi);
            double[] points_chart = new double[points.length];
            for (int zi = 0; zi < points_chart.length / 2; ++zi) {
                double[] pxi = JFreeChartScatterPlot.java2dToChart(JFreeChartScatterPlot.this.cp, JFreeChartScatterPlot.this.cp.getChart().getXYPlot(), points[2 * zi + 0], points[2 * zi + 1]);
                points_chart[zi * 2 + 0] = pxi[0];
                points_chart[zi * 2 + 1] = pxi[1];
            }
            XYPolygonAnnotation poly_annotation = new XYPolygonAnnotation(points_chart);
            return poly_annotation;
        }

        public double[] getXY(ChartMouseEvent chartMouseEvent) {
            Point2D p = JFreeChartScatterPlot.this.cp.translateScreenToJava2D(chartMouseEvent.getTrigger().getPoint());
            Rectangle2D plotArea = JFreeChartScatterPlot.this.cp.getScreenDataArea();
            XYPlot plot = (XYPlot)chartMouseEvent.getChart().getPlot();
            double chartX = plot.getDomainAxis().java2DToValue(p.getX(), plotArea, plot.getDomainAxisEdge());
            double chartY = plot.getRangeAxis().java2DToValue(p.getY(), plotArea, plot.getRangeAxisEdge());
            return new double[]{chartX, chartY};
        }

        public void chartMouseMoved(ChartMouseEvent chartMouseEvent) {
            if (this.state == LASSO_STATE.DRAGGING) {
                double[] pxy = new double[]{chartMouseEvent.getTrigger().getPoint().x, chartMouseEvent.getTrigger().getPoint().y};
                this.lasso.addPoint(pxy[0], pxy[1]);
                Path2D lpath = (Path2D)this.lasso.getPath().clone();
                chartMouseEvent.getChart().getXYPlot().removeAnnotation((XYAnnotation)this.lassoAnnotation);
                this.lassoAnnotation = this.createAnnotationFromPath(lpath);
                chartMouseEvent.getChart().getXYPlot().addAnnotation((XYAnnotation)this.lassoAnnotation);
            }
        }
    }

    public static enum LASSO_STATE {
        NONE,
        DRAGGING;

    }

    public static interface ScatterPlotListener {
        public void highlightingChanged(NexusTableModel.NexusHighlightingChangedEvent var1);

        public void selectionChanged(NexusTableModel.NexusSelectionChangedEvent var1);
    }

    public class SetColormapAction
    extends AbstractAction {
        private Colormap cm;

        public SetColormapAction(String name, Colormap cm) {
            super(name);
            this.cm = cm;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JFreeChartScatterPlot.this.setColormap(this.cm);
        }
    }

    public class SetColoringAction
    extends AbstractAction {
        private Map<String, Double> nd;

        public SetColoringAction(String name, Map<String, Double> data) {
            super(name);
            this.nd = data;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JFreeChartScatterPlot.this.setColorValues(this.nd);
        }
    }

    public class SetClusteringAnnotationsAction
    extends AbstractAction {
        private List<Pair<Color, List<String>>> clustering;

        public SetClusteringAnnotationsAction(String name, List<Pair<Color, List<String>>> clustering) {
            super(name);
            this.clustering = clustering;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            HashMap<Integer, Paint> paints = new HashMap<Integer, Paint>();
            HashMap<String, List<Integer>> clustered = new HashMap<String, List<Integer>>();
            for (int zi = 0; zi < this.clustering.size(); ++zi) {
                Pair<Color, List<String>> pci = this.clustering.get(zi);
                paints.put(zi, (Paint)pci.getLeft());
                for (String struci : (List)pci.getRight()) {
                    if (!clustered.containsKey(struci)) {
                        clustered.put(struci, new ArrayList());
                    }
                    ((List)clustered.get(struci)).add(zi);
                }
            }
            JFreeChartScatterPlot.this.setMultipleAnnotations(clustered, paints);
        }
    }
}

