/*
 * Decompiled with CFR 0.152.
 */
package tech.molecules.leet.table.chart;

import java.awt.geom.Path2D;
import java.util.Collection;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.StandardEntityCollection;

public class JFreeChartPlotLasso {
    private Path2D poly = new Path2D.Double();
    private EntityCollection ec = null;

    public JFreeChartPlotLasso(double x, double y) {
        this.poly.moveTo(x, y);
    }

    public EntityCollection getContainedEntities(EntityCollection entityCollection) {
        if (this.ec == null) {
            this.ec = new StandardEntityCollection();
            Collection entities = entityCollection.getEntities();
            for (int i = 0; i < entities.size(); ++i) {
                ChartEntity entity = entityCollection.getEntity(i);
                if (!this.poly.intersects(entity.getArea().getBounds())) continue;
                this.ec.add(entity);
            }
        }
        return this.ec;
    }

    public EntityCollection getContainedEntities() {
        return this.ec;
    }

    public void addPoint(double x, double y) {
        this.poly.lineTo(x, y);
    }

    public void close() {
        this.poly.closePath();
    }

    public Path2D getPath() {
        return this.poly;
    }
}

