/*
 * Decompiled with CFR 0.152.
 */
package tech.molecules.leet.table.action;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.JPanel;
import tech.molecules.leet.table.NColumn;
import tech.molecules.leet.table.NDataProvider;
import tech.molecules.leet.table.NexusTableModel;
import tech.molecules.leet.table.NumericalDatasource;
import tech.molecules.leet.table.action.CreateXYScatterPlotActionConfig;
import tech.molecules.leet.table.chart.JFreeChartScatterPlot2;
import tech.molecules.leet.table.chart.ScatterPlotModel;

public class CreateXYScatterPlotActionModel {
    private NexusTableModel ntm;
    private CreateXYScatterPlotActionConfig conf;

    public CreateXYScatterPlotActionModel(NexusTableModel ntm, CreateXYScatterPlotActionConfig conf) {
        this.ntm = ntm;
        this.conf = conf;
    }

    public void setConfig(CreateXYScatterPlotActionConfig conf) {
        this.conf = conf;
    }

    public CreateXYScatterPlotActionModel(NexusTableModel ntm, JPanel plotpanel) throws Exception {
        this.ntm = ntm;
        this.conf = this.inventConfig(plotpanel);
    }

    public NexusTableModel getNTM() {
        return this.ntm;
    }

    public CreateXYScatterPlotActionConfig getConfig() {
        return this.conf;
    }

    public void performAction() {
        this.conf.getPlotPanel().setLayout(new BorderLayout());
        ScatterPlotModel spm = new ScatterPlotModel(this.ntm, this.conf.getNd_x(), this.conf.getNd_y());
        spm.setHighlightNNearestNeighbors(1);
        JFreeChartScatterPlot2 jfcsp = new JFreeChartScatterPlot2(spm);
        this.conf.getPlotPanel().add((Component)jfcsp, "Center");
    }

    public CreateXYScatterPlotActionConfig inventConfig(JPanel plotpanel) throws Exception {
        Map<NColumn, Map<String, NumericalDatasource>> nds = this.ntm.collectNumericDataSources();
        ArrayList found = new ArrayList();
        for (NColumn ci : nds.keySet()) {
            found.addAll(ci.getNumericalDataSources().values());
        }
        if (found.size() < 2) {
            throw new Exception("Not enough numerical datasources in dataset");
        }
        NumericalDatasource ndx = (NumericalDatasource)found.get(0);
        NColumn ncx = ((NumericalDatasource)found.get(0)).getColumn();
        NumericalDatasource ndy = (NumericalDatasource)found.get(found.size() - 1);
        NColumn ncy = ((NumericalDatasource)found.get(found.size() - 1)).getColumn();
        return new CreateXYScatterPlotActionConfig(plotpanel, (NDataProvider)this.ntm.getDatasetForColumn(ncx), (NDataProvider)this.ntm.getDatasetForColumn(ncy), ndx, ndy);
    }
}

