/*
 * Decompiled with CFR 0.152.
 */
package tech.molecules.leet.table.action;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.function.Supplier;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import tech.molecules.leet.table.NexusTableModel;
import tech.molecules.leet.table.action.CreateXYScatterPlotActionGUI;
import tech.molecules.leet.table.action.CreateXYScatterPlotActionModel;

public class CreateXYScatterPlotAction
extends AbstractAction {
    private NexusTableModel ntm;
    private Supplier<JPanel> plotPanel;
    private Frame owner;
    private CreateXYScatterPlotActionModel model;
    private CreateXYScatterPlotActionGUI gui;

    public CreateXYScatterPlotAction(NexusTableModel ntm, Supplier<JPanel> plotPanel, Frame owner) {
        super("Create XY Plot");
        this.ntm = ntm;
        this.plotPanel = plotPanel;
        this.owner = owner;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JPanel targetPanel = this.plotPanel.get();
        try {
            this.model = new CreateXYScatterPlotActionModel(this.ntm, targetPanel);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this.owner, ex.getMessage());
        }
        this.gui = new CreateXYScatterPlotActionGUI(this.model, this.owner);
        JDialog jd = new JDialog(this.owner, true);
        jd.getContentPane().setLayout(new BorderLayout());
        jd.getContentPane().add((Component)this.gui.getActionGUI(), "Center");
        JPanel bottom = new JPanel();
        bottom.setLayout(new FlowLayout(2));
        JButton jb_close = new JButton("OK");
        bottom.add(jb_close);
        jb_close.addActionListener(actionEvent -> jd.dispose());
        jd.getContentPane().add((Component)bottom, "South");
        jd.pack();
        jd.setVisible(true);
        this.model.setConfig(this.gui.getConfig(this.model.getNTM(), targetPanel));
        this.model.performAction();
    }
}

