/*
 * Decompiled with CFR 0.152.
 */
package tech.molecules.leet.table;

import com.actelion.research.chem.IDCodeParser;
import com.actelion.research.chem.SSSearcher;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.descriptor.DescriptorHandlerLongFFP512;
import com.actelion.research.gui.JEditableStructureView;
import com.actelion.research.gui.StructureListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import tech.molecules.leet.chem.BitSetUtils;
import tech.molecules.leet.chem.ChemUtils;
import tech.molecules.leet.table.NColumn;
import tech.molecules.leet.table.NDataProvider;
import tech.molecules.leet.table.NStructureDataProvider;
import tech.molecules.leet.table.NexusTableModel;
import tech.molecules.leet.table.NumericalDatasource;
import tech.molecules.leet.table.gui.LeetChemistryCellRenderer;

public class StructureColumn
implements NColumn<NStructureDataProvider, NDataProvider.StructureWithID> {
    private NStructureDataProvider dp;
    private boolean loadFFPs = false;
    private boolean loadFFPsComplete = false;
    private Map<String, long[]> fps_FFP = new HashMap<String, long[]>();
    private List<NColumn.ColumnDataListener> listeners = new ArrayList<NColumn.ColumnDataListener>();
    public static String ROW_FILTER_SS = "rowfilter_ss";
    private List<NStructureDataProvider> providers = new ArrayList<NStructureDataProvider>();

    public StructureColumn(boolean loadFFPs) {
        this.loadFFPs = loadFFPs;
    }

    @Override
    public void setDataProvider(NStructureDataProvider dataprovider) {
        this.dp = dataprovider;
    }

    @Override
    public NStructureDataProvider getDataProvider() {
        return this.dp;
    }

    @Override
    public void startAsyncReinitialization(NexusTableModel ntm) {
        if (this.loadFFPs) {
            this.loadFFPsComplete = false;
            this.loadFFPsAync(this.dp, ntm);
        }
    }

    private void loadFFPsAync(NStructureDataProvider dataprovider, NexusTableModel ntm) {
        ExecutorService esa = Executors.newCachedThreadPool();
        List<String> all_rows = ntm.getAllRows();
        final ArrayList fti = new ArrayList();
        for (int zi = 0; zi < all_rows.size(); ++zi) {
            final String rowkey = all_rows.get(zi);
            final String midc = dataprovider.getStructureData((String)all_rows.get((int)zi)).structure[0];
            fti.add(esa.submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    StereoMolecule mi = ChemUtils.parseIDCode((String)midc);
                    long[] ffpi = (long[])DescriptorHandlerLongFFP512.getDefaultInstance().getThreadSafeCopy().createDescriptor((Object)mi);
                    Map map = StructureColumn.this.fps_FFP;
                    synchronized (map) {
                        StructureColumn.this.fps_FFP.put(rowkey, ffpi);
                    }
                }
            }));
        }
        esa.submit(new Runnable(){

            @Override
            public void run() {
                for (Future fi : fti) {
                    try {
                        fi.get();
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                    catch (ExecutionException e) {
                        throw new RuntimeException(e);
                    }
                }
                StructureColumn.this.loadFFPsComplete = true;
            }
        });
    }

    @Override
    public String getName() {
        return "Structure";
    }

    @Override
    public NDataProvider.StructureWithID getData(String rowid) {
        return this.dp.getStructureData(rowid);
    }

    @Override
    public Map<String, NumericalDatasource<NStructureDataProvider>> getNumericalDataSources() {
        return new HashMap<String, NumericalDatasource<NStructureDataProvider>>();
    }

    public TableCellRenderer getCellRenderer() {
        return new StructureCellRenderer();
    }

    @Override
    public TableCellEditor getCellEditor() {
        return new StructureCellRenderer();
    }

    @Override
    public void addColumnDataListener(NColumn.ColumnDataListener cdl) {
        this.listeners.add(cdl);
    }

    @Override
    public boolean removeColumnDataListener(NColumn.ColumnDataListener cdl) {
        return this.listeners.remove(cdl);
    }

    @Override
    public List<String> getRowFilterTypes() {
        ArrayList<String> rfs = new ArrayList<String>();
        rfs.add(ROW_FILTER_SS);
        return rfs;
    }

    @Override
    public NColumn.NexusRowFilter<NStructureDataProvider> createRowFilter(NexusTableModel tableModel, String name) {
        if (name.equals(ROW_FILTER_SS)) {
            return new SubstructureRowFilter();
        }
        return null;
    }

    public class SubstructureRowFilter
    implements NColumn.NexusRowFilter<NStructureDataProvider> {
        private NexusTableModel ntm;
        private StereoMolecule filterStructure = null;
        private long[] filterStructureFFP = new long[16];

        @Override
        public String getFilterName() {
            return ROW_FILTER_SS;
        }

        @Override
        public BitSet filterNexusRows(NStructureDataProvider data, List<String> ids, BitSet filtered) {
            if (!this.isReady() || this.filterStructure == null) {
                return (BitSet)filtered.clone();
            }
            IDCodeParser icp = new IDCodeParser();
            SSSearcher sss = new SSSearcher();
            BitSet f2 = (BitSet)filtered.clone();
            sss.setFragment(this.filterStructure);
            for (int zi = 0; zi < ids.size(); ++zi) {
                if (!f2.get(zi)) continue;
                boolean fphit = BitSetUtils.test_subset((long[])this.filterStructureFFP, (long[])((long[])StructureColumn.this.fps_FFP.get(ids.get(zi))));
                if (fphit) {
                    StereoMolecule mmi = new StereoMolecule();
                    icp.parse(mmi, data.getStructureData((String)ids.get((int)zi)).structure[0]);
                    sss.setMolecule(mmi);
                    f2.set(zi, sss.isFragmentInMolecule());
                    continue;
                }
                f2.set(zi, false);
            }
            return f2;
        }

        @Override
        public double getApproximateFilterSpeed() {
            return 0.2;
        }

        @Override
        public void setupFilter(NexusTableModel model, NStructureDataProvider dp) {
            this.ntm = model;
            if (!StructureColumn.this.loadFFPs) {
                StructureColumn.this.loadFFPs = true;
                StructureColumn.this.startAsyncReinitialization(model);
            }
        }

        @Override
        public JPanel getFilterGUI() {
            return new JSSFilterpanel();
        }

        @Override
        public boolean isReady() {
            return StructureColumn.this.loadFFPsComplete;
        }

        public void setFilterStructure(StereoMolecule mi) {
            this.filterStructure = mi;
            if (!this.filterStructure.isFragment()) {
                this.filterStructure.setFragment(true);
            }
            this.filterStructureFFP = (long[])DescriptorHandlerLongFFP512.getDefaultInstance().getThreadSafeCopy().createDescriptor((Object)this.filterStructure);
            this.ntm.updateFiltering();
        }

        class JSSFilterpanel
        extends JPanel {
            public JSSFilterpanel() {
                JEditableStructureView ssview = new JEditableStructureView();
                ssview.setAllowQueryFeatures(true);
                this.setLayout(new BorderLayout());
                this.add((Component)ssview, "Center");
                ssview.addStructureListener(new StructureListener(){

                    public void structureChanged(StereoMolecule stereoMolecule) {
                        SubstructureRowFilter.this.setFilterStructure(stereoMolecule);
                    }
                });
                this.setPreferredSize(new Dimension(200, 200));
                this.repaint();
            }
        }
    }

    public static class StructureCellRenderer
    extends LeetChemistryCellRenderer {
        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int col) {
            if (value instanceof String) {
                return super.getTableCellEditorComponent(table, (String)value, isSelected, row, col);
            }
            if (value instanceof NDataProvider.StructureWithID) {
                String[] idc = ((NDataProvider.StructureWithID)value).structure;
                return super.getTableCellEditorComponent(table, idc[0] + " " + idc[1], isSelected, row, col);
            }
            return super.getTableCellEditorComponent(table, value, isSelected, row, col);
        }
    }
}

