/*
 * Decompiled with CFR 0.152.
 */
package tech.molecules.leet.table;

import com.actelion.research.chem.IDCodeParser;
import com.actelion.research.chem.StereoMolecule;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.swing.AbstractCellEditor;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.LineBorder;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import tech.molecules.leet.chem.mutator.properties.ChemPropertyCounts;
import tech.molecules.leet.table.NColumn;
import tech.molecules.leet.table.NDataProvider;
import tech.molecules.leet.table.NStructureDataProvider;
import tech.molecules.leet.table.NexusTable;
import tech.molecules.leet.table.NexusTableModel;
import tech.molecules.leet.table.NumericalDatasource;
import tech.molecules.leet.table.gui.DispatchingMouseAdapter;

public class StructureCalculatedPropertiesColumn
implements NColumn<NStructureDataProvider, CalculatedProperties> {
    private NStructureDataProvider dp;

    @Override
    public void setDataProvider(NStructureDataProvider dataprovider) {
        this.dp = dataprovider;
    }

    @Override
    public NStructureDataProvider getDataProvider() {
        return this.dp;
    }

    @Override
    public void startAsyncReinitialization(NexusTableModel model) {
    }

    @Override
    public String getName() {
        return "Properties";
    }

    @Override
    public CalculatedProperties getData(String rowid) {
        NDataProvider.StructureWithID sid = this.dp.getStructureData(rowid);
        StereoMolecule m = new StereoMolecule();
        IDCodeParser icp = new IDCodeParser();
        icp.parse(m, sid.structure[0], sid.structure[1]);
        m.ensureHelperArrays(31);
        HashMap<Integer, Integer> counts = new HashMap<Integer, Integer>();
        for (int zi = 0; zi < ChemPropertyCounts.COUNTS_ALL.length; ++zi) {
            counts.put(zi, (Integer)ChemPropertyCounts.COUNTS_ALL[zi].evaluator.apply(m));
        }
        return new CalculatedProperties(counts);
    }

    public StructureCalculatedPropertiesColumn getThisColumn() {
        return this;
    }

    @Override
    public Map<String, NumericalDatasource<NStructureDataProvider>> getNumericalDataSources() {
        HashMap<String, NumericalDatasource<NStructureDataProvider>> nds = new HashMap<String, NumericalDatasource<NStructureDataProvider>>();
        for (int zi = 0; zi < ChemPropertyCounts.COUNTS_ALL.length; ++zi) {
            nds.put(ChemPropertyCounts.COUNTS_ALL[zi].name, new ChemPropertyCountDatasource(ChemPropertyCounts.COUNTS_ALL[zi]));
        }
        return nds;
    }

    public static double evaluateNumericalDataSource(NStructureDataProvider dp, String datasource, String rowid) {
        StereoMolecule mi = new StereoMolecule();
        IDCodeParser icp = new IDCodeParser();
        icp.parse(mi, dp.getStructureData((String)rowid).structure[0], dp.getStructureData((String)rowid).structure[1]);
        mi.ensureHelperArrays(31);
        switch (datasource) {
            case "hac": {
                return mi.getAtoms();
            }
            case "rb": {
                return mi.getRotatableBondCount();
            }
        }
        return Double.NaN;
    }

    public TableCellRenderer getCellRenderer() {
        return new CalcPropertiesRenderer();
    }

    @Override
    public TableCellEditor getCellEditor() {
        return new CalcPropertiesRenderer();
    }

    @Override
    public List<String> getRowFilterTypes() {
        return null;
    }

    @Override
    public NColumn.NexusRowFilter<NStructureDataProvider> createRowFilter(NexusTableModel tableModel, String name) {
        return null;
    }

    @Override
    public void addColumnDataListener(NColumn.ColumnDataListener cdl) {
    }

    @Override
    public boolean removeColumnDataListener(NColumn.ColumnDataListener cdl) {
        return false;
    }

    public static class CalcPropertiesRenderer
    extends AbstractCellEditor
    implements TableCellEditor,
    TableCellRenderer {
        private static MouseEvent lastPressedMouseEvent = null;
        private static MouseEvent lastClickedMouseEvent = null;
        private static MouseEvent lastReleasedMouseEvent = null;
        private Object lastValue = null;

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean isFocus, int row, int column) {
            System.out.println("Create Table Cell Render Component..");
            NexusTable nt = (NexusTable)table;
            final NexusTable.NexusInteractiveEditorInfrastructure editorInfra = nt.createInteractiveEditorInfrastructure(row);
            final NexusTable.JCellBackgroundPanel pi = editorInfra.panel;
            pi.setOpaque(false);
            if (value == null) {
                pi.removeAll();
            }
            if (value instanceof CalculatedProperties) {
                CalculatedProperties a = (CalculatedProperties)value;
                pi.removeAll();
                pi.setLayout(new GridLayout(4, 4));
                for (int zi = 0; zi < ChemPropertyCounts.COUNTS_ALL.length; ++zi) {
                    final JColorLabel pa = new JColorLabel(ChemPropertyCounts.COUNTS_ALL[zi].shortName + "=" + String.format("%d", a.counts.get(zi)), a.counts.get(zi).intValue(), 0.0, 40.0);
                    pa.setBorder(new LineBorder(Color.blue, 1));
                    pi.add(pa);
                    Supplier<Component> componentSupplier = () -> pi.getParent();
                    DispatchingMouseAdapter mli = new DispatchingMouseAdapter(() -> table){

                        @Override
                        public void mouseEntered(MouseEvent e) {
                            pa.setBorder(new LineBorder(Color.red, 1));
                            pi.repaint();
                        }

                        @Override
                        public void mouseExited(MouseEvent e) {
                            pa.setBorder(new LineBorder(Color.blue, 1));
                            pi.repaint();
                        }

                        @Override
                        public void mouseClicked(MouseEvent e) {
                            System.out.println("mouse clicked! " + e.toString());
                        }

                        @Override
                        public void mousePressed(MouseEvent e) {
                            System.out.println("Mouse Pressed!");
                            editorInfra.dispatchMousePressedEvent(e);
                        }
                    };
                    pa.addMouseListener(mli);
                }
            }
            return pi;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.lastValue = value;
            return this.getTableCellRendererComponent(table, value, isSelected, true, row, column);
        }

        @Override
        public Object getCellEditorValue() {
            return this.lastValue;
        }

        public static class JColorLabel
        extends JLabel {
            public JColorLabel(String text, double val, double va, double vb) {
                super(text);
                double f = (val - va) / (vb - va);
                float value = (float)Math.max(0.0, Math.min(1.0, f));
                float minHue = 0.47058824f;
                float maxHue = 0.0f;
                float hue = value * maxHue + (1.0f - value) * minHue;
                Color ca = new Color(Color.HSBtoRGB(hue, 0.6f, 0.85f));
                Color c = new Color(ca.getRed(), ca.getGreen(), ca.getBlue(), 40);
                this.setOpaque(false);
                this.setBackground(c);
            }

            @Override
            public void paintComponent(Graphics g) {
                Color ci = this.getBackground();
                g.setColor(ci);
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
                super.paintComponent(g);
            }
        }
    }

    public class ChemPropertyCountDatasource
    implements NumericalDatasource<NStructureDataProvider> {
        private ChemPropertyCounts.ChemPropertyCount ci;

        public ChemPropertyCountDatasource(ChemPropertyCounts.ChemPropertyCount ci) {
            this.ci = ci;
        }

        @Override
        public String getName() {
            return this.ci.name;
        }

        @Override
        public NColumn<NStructureDataProvider, ?> getColumn() {
            return StructureCalculatedPropertiesColumn.this.getThisColumn();
        }

        @Override
        public boolean hasValue(String row) {
            return true;
        }

        @Override
        public double getValue(String row) {
            StereoMolecule m = new StereoMolecule();
            IDCodeParser icp = new IDCodeParser();
            icp.parse(m, ((StructureCalculatedPropertiesColumn)StructureCalculatedPropertiesColumn.this).dp.getStructureData((String)row).structure[0], ((StructureCalculatedPropertiesColumn)StructureCalculatedPropertiesColumn.this).dp.getStructureData((String)row).structure[1]);
            m.ensureHelperArrays(31);
            return ((Integer)this.ci.evaluator.apply(m)).intValue();
        }
    }

    public static class CalculatedProperties {
        public Map<Integer, Integer> counts = new HashMap<Integer, Integer>();

        public CalculatedProperties(Map<Integer, Integer> counts) {
            this.counts = new HashMap<Integer, Integer>(counts);
        }
    }
}

