/*
 * Decompiled with CFR 0.152.
 */
package tech.molecules.leet.table;

import com.actelion.research.chem.IDCodeParser;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.descriptor.DescriptorHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.table.TableCellEditor;
import tech.molecules.leet.table.NColumn;
import tech.molecules.leet.table.NDataProvider;
import tech.molecules.leet.table.NSimilarityColumn;
import tech.molecules.leet.table.NexusTableModel;
import tech.molecules.leet.table.NumericalDatasource;

public class PairwiseDistanceColumn
implements NSimilarityColumn<NDataProvider.StructureDataProvider, StereoMolecule> {
    private NDataProvider.StructureDataProvider dp;
    private Map<String, Integer> rowPos;
    private double[][] dist;
    private boolean isSimilarity;
    private boolean isNormalized;
    private boolean isSymmetric;

    public PairwiseDistanceColumn(Map<String, Integer> row_pos, double[][] distances, boolean isSimilarity, boolean isNormalized, boolean isSymmetric) {
        this.rowPos = row_pos;
        this.dist = distances;
        this.isSimilarity = isSimilarity;
        this.isNormalized = isNormalized;
        this.isSymmetric = isSymmetric;
    }

    @Override
    public String getName() {
        return "dist..";
    }

    @Override
    public void setDataProvider(NDataProvider.StructureDataProvider dataprovider) {
        this.dp = dataprovider;
    }

    @Override
    public NDataProvider.StructureDataProvider getDataProvider() {
        return this.dp;
    }

    @Override
    public void startAsyncReinitialization(NexusTableModel model) {
    }

    @Override
    public StereoMolecule getData(String rowid) {
        return null;
    }

    @Override
    public TableCellEditor getCellEditor() {
        return null;
    }

    @Override
    public Map<String, NumericalDatasource<NDataProvider.StructureDataProvider>> getNumericalDataSources() {
        return new HashMap<String, NumericalDatasource<NDataProvider.StructureDataProvider>>();
    }

    @Override
    public void addCellPopupAction(NColumn.CellSpecificAction ca) {
        NSimilarityColumn.super.addCellPopupAction(ca);
    }

    @Override
    public List<String> getRowFilterTypes() {
        return null;
    }

    @Override
    public NColumn.NexusRowFilter<NDataProvider.StructureDataProvider> createRowFilter(NexusTableModel tableModel, String name) {
        return null;
    }

    @Override
    public void addColumnDataListener(NColumn.ColumnDataListener cdl) {
    }

    @Override
    public boolean removeColumnDataListener(NColumn.ColumnDataListener cdl) {
        return false;
    }

    @Override
    public boolean isSimilarity() {
        return this.isSimilarity;
    }

    @Override
    public boolean isNormalized() {
        return this.isNormalized;
    }

    @Override
    public boolean isSymmetric() {
        return this.isSymmetric;
    }

    @Override
    public double evaluateValue(NDataProvider.StructureDataProvider data, String rowid_a, String rowid_b) {
        Integer pa = this.rowPos.get(rowid_a);
        Integer pb = this.rowPos.get(rowid_b);
        if (pa == null || pb == null) {
            return Double.NaN;
        }
        return this.dist[pa][pb];
    }

    public static PairwiseDistanceColumn createFromDescriptor(NDataProvider.StructureDataProvider data, DescriptorHandler dh, List<String> rows) {
        int zi;
        HashMap<String, Integer> pos = new HashMap<String, Integer>();
        ArrayList<Object> dhs = new ArrayList<Object>();
        IDCodeParser icp = new IDCodeParser();
        for (int zi2 = 0; zi2 < rows.size(); ++zi2) {
            pos.put(rows.get(zi2), zi2);
            StereoMolecule mi = new StereoMolecule();
            icp.parse(mi, data.getStructureData((String)rows.get((int)zi2)).structure[0]);
            mi.ensureHelperArrays(31);
            dhs.add(dh.createDescriptor((Object)mi));
        }
        double[][] distdata = new double[rows.size()][rows.size()];
        for (zi = 0; zi < rows.size(); ++zi) {
            distdata[zi][zi] = 1.0;
        }
        for (zi = 0; zi < rows.size() - 1; ++zi) {
            for (int zj = zi + 1; zj < rows.size(); ++zj) {
                double di;
                distdata[zi][zj] = di = (double)dh.getSimilarity(dhs.get(zi), dhs.get(zj));
                distdata[zj][zi] = di;
            }
        }
        return new PairwiseDistanceColumn(pos, distdata, true, true, true);
    }
}

