/*
 * Decompiled with CFR 0.152.
 */
package tech.molecules.leet.table;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.awt.Color;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import tech.molecules.leet.table.NColumn;
import tech.molecules.leet.table.NDataProvider;
import tech.molecules.leet.table.NStructureDataProvider;
import tech.molecules.leet.table.NumericalDatasource;

public class NexusTableModel
extends AbstractTableModel {
    private Map<Integer, Pair<Class, Object>> registry;
    private List<String> allRows = new ArrayList<String>();
    private List<String> visibleRows = new ArrayList<String>();
    private Map<String, Integer> visibleRowPositions = new HashMap<String, Integer>();
    private List<NColumn> columns = new ArrayList<NColumn>();
    private Map<NColumn, NDataProvider> columnDataProviders = new HashMap<NColumn, NDataProvider>();
    Map<NColumn, List<NColumn.NexusRowFilter>> rowFilters = new HashMap<NColumn, List<NColumn.NexusRowFilter>>();
    private Map<NColumn, NColumn.ColumnDataListener> columnListeners = new HashMap<NColumn, NColumn.ColumnDataListener>();
    public final Object lockTable = new Object();
    List<NexusTableModelListener> nexusListeners = new ArrayList<NexusTableModelListener>();
    private Map<String, SelectionType> selectionTypeRegistry = new HashMap<String, SelectionType>();
    public static final String SELECTION_TYPE_SELECTED = "selected";
    public static final String SELECTION_TYPE_MOUSE_OVER = "mouseOver";
    private Map<String, List<SelectionType>> selectionTypes = new HashMap<String, List<SelectionType>>();
    private Map<String, Color> highlightColors = new HashMap<String, Color>();
    private Map<SelectionType, Set<String>> selections = new HashMap<SelectionType, Set<String>>();

    public NexusTableModel() {
        this.initNexusSelectionTypes();
    }

    public void setAllRows(List<String> rowids) {
        this.allRows = rowids;
        this.updateFiltering();
    }

    public List<String> getAllRows() {
        return this.allRows;
    }

    public List<String> getVisibleRows() {
        return this.visibleRows;
    }

    public <U, T> T getDatasetForColumn(NColumn<U, T> col) {
        return (T)this.columnDataProviders.get(col);
    }

    public void setNexusColumnsWithDataProviders(List<Pair<NColumn, NDataProvider>> cols) {
        this.columns = new ArrayList<NColumn>(cols.stream().map(ci -> (NColumn)ci.getLeft()).collect(Collectors.toList()));
        for (int zi = 0; zi < this.columns.size(); ++zi) {
            NColumn cp = this.columns.get(zi);
            this.setDataProviderForColumn(cp, (NDataProvider)cols.get(zi).getRight());
        }
        this.reinitNexusColumns();
    }

    public void addNexusColumn(NDataProvider ndp, NColumn nc) {
        this.setNexusColumnWithDataProvider(this.columns.size(), (Pair<NColumn, NDataProvider>)Pair.of((Object)nc, (Object)ndp));
    }

    public void removeNexusColumn(NColumn nc) {
        this.columns.remove(nc);
        this.rowFilters.remove(nc);
        this.updateFiltering();
    }

    public String getRowIdForVisibleRow(int visible_row_index) {
        return this.visibleRows.get(visible_row_index);
    }

    private void reinitNexusColumns() {
        for (int zi = 0; zi < this.columns.size(); ++zi) {
            NColumn cp = this.columns.get(zi);
            cp.setDataProvider(this.columnDataProviders.get(cp));
            if (this.columnListeners.containsKey(cp)) continue;
            NColumn.ColumnDataListener cdpl = new NColumn.ColumnDataListener(){

                @Override
                public void needFiltering() {
                    NexusTableModel.this.updateFiltering();
                }
            };
            cp.addColumnDataListener(cdpl);
            this.columnListeners.put(cp, cdpl);
        }
        this.updateFiltering();
        this.fireNexusTableStructureChangedEvent();
        this.fireTableStructureChanged();
    }

    public void setNexusColumnWithDataProvider(int idx, Pair<NColumn, NDataProvider> column) {
        this.columns.add(idx, (NColumn)column.getLeft());
        this.setDataProviderForColumn((NColumn)column.getLeft(), (NDataProvider)column.getRight());
        this.reinitNexusColumns();
    }

    private void registerNexusColumn(NColumn nci) {
        Random ri = new Random();
        boolean found = false;
        int ii = -1;
        while (!found) {
            ii = Math.abs(ri.nextInt());
            found = !this.registry.containsKey(ii);
        }
        this.registry.put(ii, (Pair<Class, Object>)Pair.of(nci.getClass(), (Object)nci));
    }

    private void registerNexusDataProvider(NDataProvider ndp) {
        Random ri = new Random();
        boolean found = false;
        int ii = -1;
        while (!found) {
            ii = Math.abs(ri.nextInt());
            found = !this.registry.containsKey(ii);
        }
        this.registry.put(ii, (Pair<Class, Object>)Pair.of(ndp.getClass(), (Object)ndp));
    }

    public <U extends NDataProvider, T> void setDataProviderForColumn(NColumn<U, T> c, U np) {
        this.columnDataProviders.put(c, np);
        c.setDataProvider(np);
    }

    public List<NColumn> getNexusColumns() {
        return this.columns;
    }

    @Override
    public int getRowCount() {
        return this.visibleRows.size();
    }

    @Override
    public int getColumnCount() {
        return this.columns.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.columns.get(columnIndex).getData(this.visibleRows.get(rowIndex));
    }

    public <U, T> void addRowFilter(NColumn<U, T> col, NColumn.NexusRowFilter<T> filter) {
        filter.setupFilter(this, this.getDatasetForColumn(col));
        if (!this.rowFilters.containsKey(col)) {
            this.rowFilters.put(col, new ArrayList());
        }
        this.rowFilters.get(col).add(filter);
        this.updateFiltering();
    }

    private void updateRowIndices() {
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return true;
    }

    public void resetFilters() {
        this.rowFilters.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateFiltering() {
        Object object = this.lockTable;
        synchronized (object) {
            int zi;
            ArrayList<Triple> filters = new ArrayList<Triple>();
            for (Map.Entry<NColumn, List<NColumn.NexusRowFilter>> fiss : this.rowFilters.entrySet()) {
                for (NColumn.NexusRowFilter fi : fiss.getValue()) {
                    filters.add(Triple.of((Object)fiss.getKey(), (Object)((NStructureDataProvider)this.getDatasetForColumn(fiss.getKey())), (Object)fi));
                }
            }
            filters.sort((x, y) -> -Double.compare(((NColumn.NexusRowFilter)x.getRight()).getApproximateFilterSpeed(), ((NColumn.NexusRowFilter)y.getRight()).getApproximateFilterSpeed()));
            BitSet in = new BitSet(this.allRows.size());
            in.set(0, this.allRows.size());
            for (zi = 0; zi < filters.size(); ++zi) {
                in.and(((NColumn.NexusRowFilter)((Triple)filters.get(zi)).getRight()).filterNexusRows(((Triple)filters.get(zi)).getMiddle(), this.allRows, in));
            }
            this.visibleRows = new ArrayList<String>();
            this.visibleRowPositions.clear();
            for (zi = 0; zi < this.allRows.size(); ++zi) {
                if (!in.get(zi)) continue;
                this.visibleRows.add(this.allRows.get(zi));
                this.visibleRowPositions.put(this.allRows.get(zi), this.visibleRows.size() - 1);
            }
            this.fireTableDataChanged();
        }
    }

    public void addNexusListener(NexusTableModelListener li) {
        this.nexusListeners.add(li);
    }

    public void removeNexusListener(NexusTableModelListener li) {
        this.nexusListeners.remove(li);
    }

    public void fireNexusTableStructureChangedEvent() {
        for (final NexusTableModelListener li : this.nexusListeners) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    li.nexusTableStructureChanged();
                }
            });
        }
    }

    public List<Pair<NColumn, NDataProvider>> getNexusColumnsWithDataProviders() {
        ArrayList<Pair<NColumn, NDataProvider>> colwdp = new ArrayList<Pair<NColumn, NDataProvider>>();
        for (NColumn ci : this.columns) {
            colwdp.add((Pair<NColumn, NDataProvider>)Pair.of((Object)ci, (Object)((NDataProvider)this.getDatasetForColumn(ci))));
        }
        return colwdp;
    }

    public Map<NColumn, Map<String, NumericalDatasource>> collectNumericDataSources() {
        HashMap<NColumn, Map<String, NumericalDatasource>> nds = new HashMap<NColumn, Map<String, NumericalDatasource>>();
        for (NColumn nci : this.getNexusColumns()) {
            if (nci.getNumericalDataSources() == null || nci.getNumericalDataSources().size() <= 0) continue;
            nds.put(nci, nci.getNumericalDataSources());
        }
        return nds;
    }

    public String getKeyAtVisiblePosition(int ri) {
        return this.visibleRows.get(ri);
    }

    public int getVisiblePositionOfKey(String ki) {
        return this.visibleRowPositions.get(ki);
    }

    public SelectionType getSelectionType(String name) {
        return this.selectionTypeRegistry.get(name);
    }

    public Set<String> getSelectionTypeRows(String selectionTypeName) {
        return this.selections.get(this.selectionTypeRegistry.get(selectionTypeName));
    }

    private void initNexusSelectionTypes() {
        this.registerSelectionType(new SelectionType(SELECTION_TYPE_SELECTED, Color.red.brighter().brighter()));
        this.registerSelectionType(new SelectionType(SELECTION_TYPE_MOUSE_OVER, Color.cyan.darker()));
    }

    public boolean registerSelectionType(SelectionType type) {
        if (this.selectionTypeRegistry.containsKey(type.getName())) {
            return false;
        }
        this.selectionTypeRegistry.put(type.getName(), type);
        return true;
    }

    public void addSelectionTypeToRows(SelectionType c, Collection<String> rows) {
        for (String rowid : rows) {
            if (!this.selectionTypes.containsKey(rowid)) {
                this.selectionTypes.put(rowid, new ArrayList());
            }
            this.selectionTypes.get(rowid).add(c);
        }
        if (!this.selections.containsKey(c)) {
            this.selections.put(c, new HashSet());
        }
        this.selections.get(c).addAll(rows);
    }

    public void removeSelectionTypeFromRows(SelectionType c, Collection<String> rows) {
        for (String rowid : rows) {
            List<SelectionType> ci = this.selectionTypes.get(rowid);
            if (ci == null) continue;
            ci.remove(c);
        }
        if (this.selections.containsKey(c)) {
            this.selections.get(c).removeAll(rows);
        }
    }

    public void setHighlightColors(Map<String, Color> colors) {
        this.highlightColors = colors;
    }

    public NexusHighlightingAndSelectionStatus getHighlightingAndSelectionStatus(int row) {
        List<SelectionType> selCols = this.selectionTypes.get(this.visibleRows.get(row));
        return new NexusHighlightingAndSelectionStatus(this.highlightColors.get(this.visibleRows.get(row)), selCols);
    }

    public static void equipJacksonSerializer(ObjectMapper mapper) {
    }

    public static void equipJacksonDeserializer(ObjectMapper mapper, Map<Integer, Pair<Class, Object>> registry) {
    }

    public static class NexusHighlightingChangedEvent
    extends NexusEvent {
        Set<String> rows;

        public NexusHighlightingChangedEvent(Object source, Set<String> rows) {
            super(source);
            this.rows = rows;
        }

        public Set<String> getRows() {
            return this.rows;
        }
    }

    public static class NexusSelectionChangedEvent
    extends NexusEvent {
        Set<String> rows;

        public NexusSelectionChangedEvent(Object source, Set<String> rows) {
            super(source);
            this.rows = rows;
        }

        public Set<String> getRows() {
            return this.rows;
        }
    }

    public static class NexusEvent {
        private Object source;

        public NexusEvent(Object source) {
            this.source = source;
        }

        public Object getSource() {
            return this.source;
        }
    }

    public static class SelectionType {
        private String name;
        private Color color;

        public SelectionType(String name, Color color) {
            this.name = name;
            this.color = color;
        }

        public String getName() {
            return this.name;
        }

        public Color getColor() {
            return this.color;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SelectionType that = (SelectionType)o;
            return new EqualsBuilder().append((Object)this.name, (Object)that.name).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder(17, 37).append((Object)this.name).toHashCode();
        }
    }

    public static class NexusHighlightingAndSelectionStatus {
        public final Color highlightingColor;
        public final List<SelectionType> selectionColor;

        public NexusHighlightingAndSelectionStatus(Color highlightingColor, List<SelectionType> selectionColor) {
            this.highlightingColor = highlightingColor;
            this.selectionColor = selectionColor;
        }
    }

    public static interface NexusTableModelListener {
        public void nexusTableStructureChanged();
    }
}

