/*
 * Decompiled with CFR 0.152.
 */
package tech.molecules.leet.table;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.AbstractCellEditor;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.apache.commons.lang3.tuple.Pair;
import tech.molecules.leet.table.NColumn;
import tech.molecules.leet.table.NDataProvider;
import tech.molecules.leet.table.NexusTableModel;
import tech.molecules.leet.table.gui.JFilterPanel;
import tech.molecules.leet.table.gui.JNexusTopPanel;

public class NexusTable
extends JTable {
    private NexusTableModel model;
    private int mouseOverRow = -1;
    private int mouseOverCol = -1;
    private String mouseOverKey = null;
    private Set<String> currentSelection = new HashSet<String>();
    private NexusTableModel.SelectionType selectionTypeSelected;
    private NexusTableModel.SelectionType selectionTypeMouseOver;
    private MouseListener headerMouseListener = null;
    private JNexusTopPanel topPanel;
    private JFilterPanel filterPanel = new JFilterPanel();
    private Color colorMouseOverRow = Color.cyan.darker();
    private Color colorListSelection = Color.orange.darker().darker();

    public NexusTable(final NexusTableModel model) {
        super(model);
        this.selectionTypeSelected = model.getSelectionType("selected");
        this.selectionTypeMouseOver = model.getSelectionType("mouseOver");
        this.setModel(model);
        this.topPanel = new JNexusTopPanel(this);
        this.topPanel.setSliderManually(60);
        this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                HashSet<String> newCurrentSelection = new HashSet<String>();
                model.removeSelectionTypeFromRows(model.getSelectionType("selected"), NexusTable.this.currentSelection);
                for (int ri2 : NexusTable.this.getSelectedRows()) {
                    String kri = model.getKeyAtVisiblePosition(ri2);
                    newCurrentSelection.add(kri);
                }
                model.addSelectionTypeToRows(NexusTable.this.selectionTypeSelected, Arrays.stream(NexusTable.this.getSelectedRows()).mapToObj(ri -> model.getKeyAtVisiblePosition(ri)).collect(Collectors.toList()));
                NexusTable.this.currentSelection = newCurrentSelection;
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                NexusTable.this.mouseOverRow = -1;
                NexusTable.this.mouseOverCol = -1;
                NexusTable.this.repaint();
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                String ki;
                int ci = NexusTable.this.getThisTable().columnAtPoint(e.getPoint());
                int ri = NexusTable.this.getThisTable().rowAtPoint(e.getPoint());
                System.out.println("mm: " + ri + "/" + ci);
                if (ci >= 0 && ri >= 0 && (ki = model.getKeyAtVisiblePosition(ri)) != null && !ki.equals(NexusTable.this.mouseOverKey)) {
                    if (NexusTable.this.mouseOverKey != null) {
                        model.removeSelectionTypeFromRows(NexusTable.this.selectionTypeMouseOver, Collections.singletonList(NexusTable.this.mouseOverKey));
                    }
                    model.addSelectionTypeToRows(NexusTable.this.selectionTypeMouseOver, Collections.singletonList(ki));
                    NexusTable.this.mouseOverKey = ki;
                }
                if (ci >= 0 && ri >= 0) {
                    if (NexusTable.this.mouseOverCol != ci || NexusTable.this.mouseOverRow != ri) {
                        NexusTable.this.mouseOverCol = ci;
                        NexusTable.this.mouseOverRow = ri;
                        System.out.println("set edit cell: " + ri + "/" + ci);
                        NexusTable.this.editCellAt(ri, ci);
                        NexusTable.this.repaint();
                    }
                } else if (NexusTable.this.mouseOverCol != ci || NexusTable.this.mouseOverRow != ri) {
                    model.removeSelectionTypeFromRows(NexusTable.this.selectionTypeMouseOver, Collections.singletonList(model.getKeyAtVisiblePosition(NexusTable.this.mouseOverRow)));
                    NexusTable.this.mouseOverCol = -1;
                    NexusTable.this.mouseOverRow = -1;
                    NexusTable.this.editCellAt(ri, ci);
                    NexusTable.this.repaint();
                }
            }
        });
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
    }

    public NexusTable getThisTable() {
        return this;
    }

    public NexusTableModel getTableModel() {
        return this.model;
    }

    public void updateColumns() {
        final List<Pair<NColumn, NDataProvider>> ncolumns = this.getTableModel().getNexusColumnsWithDataProviders();
        for (int zi = 0; zi < ncolumns.size(); ++zi) {
            if (((NColumn)ncolumns.get(zi).getLeft()).getCellEditor() != null) {
                this.getColumnModel().getColumn(zi).setCellEditor(((NColumn)ncolumns.get(zi).getLeft()).getCellEditor());
                this.getColumnModel().getColumn(zi).setCellRenderer(new DefaultRendererFromEditor(((NColumn)ncolumns.get(zi).getLeft()).getCellEditor()));
            }
            this.getColumnModel().getColumn(zi).setHeaderValue(((NColumn)ncolumns.get(zi).getLeft()).getName());
        }
        this.getTableHeader().removeMouseListener(this.headerMouseListener);
        this.headerMouseListener = new MouseAdapter(){

            private void maybeShowPopup(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    final int column = NexusTable.this.columnAtPoint(e.getPoint());
                    final NColumn col = (NColumn)((Pair)ncolumns.get(column)).getLeft();
                    JPopupMenu popup = new JPopupMenu();
                    JMenu filtering = new JMenu("Add Filter");
                    if (((NColumn)((Pair)ncolumns.get(column)).getLeft()).getRowFilterTypes() != null) {
                        for (final String filtertype : ((NColumn)((Pair)ncolumns.get(column)).getLeft()).getRowFilterTypes()) {
                            JMenuItem ji = new JMenuItem(filtertype);
                            filtering.add(ji);
                            ji.addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    NColumn.NexusRowFilter<Object> filter = ((NColumn)((Pair)ncolumns.get(column)).getLeft()).createRowFilter(NexusTable.this.model, (String)filtertype);
                                    filter.setupFilter(NexusTable.this.model, ((Pair)ncolumns.get(column)).getRight());
                                    NexusTable.this.model.addRowFilter(col, filter);
                                    NexusTable.this.filterPanel.addFilter(filter);
                                    NexusTable.this.filterPanel.invalidate();
                                    NexusTable.this.invalidate();
                                    NexusTable.this.filterPanel.repaint();
                                }
                            });
                        }
                    }
                    popup.add(filtering);
                    popup.show(e.getComponent(), e.getX(), e.getY());
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.maybeShowPopup(e);
            }
        };
        this.getTableHeader().addMouseListener(this.headerMouseListener);
    }

    public JNexusTopPanel getTopPanel() {
        return this.topPanel;
    }

    public void setModel(NexusTableModel model) {
        super.setModel(model);
        this.model = model;
        this.updateColumns();
        this.getTableModel().addNexusListener(new NexusTableModel.NexusTableModelListener(){

            @Override
            public void nexusTableStructureChanged() {
                NexusTable.this.updateColumns();
            }
        });
    }

    public JFilterPanel getFilterPanel() {
        return this.filterPanel;
    }

    public void setMouseOverHighlightingEventColor(boolean useMouseOverHighlighting, Color col) {
        this.colorMouseOverRow = useMouseOverHighlighting ? col : null;
    }

    public void setListSelectionColor(Color col) {
        this.colorListSelection = col;
    }

    public NexusInteractiveEditorInfrastructure createInteractiveEditorInfrastructure(int row) {
        return new NexusInteractiveEditorInfrastructure(row);
    }

    public static class JCellBackgroundPanel
    extends JPanel {
        private int SELECTION_LINE_SIZE = 6;
        private int SELECTION_LINE_LENGTH = 20;
        private NexusTable nt;
        private NexusTableModel.NexusHighlightingAndSelectionStatus status;

        public JCellBackgroundPanel(NexusTable nt, NexusTableModel.NexusHighlightingAndSelectionStatus status) {
            this.nt = nt;
            this.status = status;
            this.setOpaque(false);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    super.mousePressed(e);
                }
            });
        }

        @Override
        protected void paintComponent(Graphics g) {
            Color cia;
            Graphics2D g2 = (Graphics2D)g;
            if (this.status.highlightingColor != null) {
                cia = new Color(this.status.highlightingColor.getRed(), this.status.highlightingColor.getGreen(), this.status.highlightingColor.getBlue(), 80);
                Color cib = new Color(this.status.highlightingColor.getRed(), this.status.highlightingColor.getGreen(), this.status.highlightingColor.getBlue(), 60);
                GradientPaint gpa = new GradientPaint(0.0f, 0.0f, cia, 0.0f, this.getHeight(), cib);
                g2.setPaint(gpa);
                g2.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
            if (this.status.selectionColor != null && this.status.selectionColor.size() > 0) {
                g2.setStroke(new BasicStroke(this.SELECTION_LINE_SIZE));
                if (this.status.selectionColor.size() == 1) {
                    cia = new Color(this.status.selectionColor.get(0).getColor().getRed(), this.status.selectionColor.get(0).getColor().getGreen(), this.status.selectionColor.get(0).getColor().getBlue(), 140);
                    g2.setColor(cia);
                    g2.drawLine(0, 0, this.getWidth(), 0);
                    g2.drawLine(0, this.getHeight(), this.getWidth(), this.getHeight());
                    g2.drawLine(0, 0, 0, this.getHeight());
                    g2.drawLine(this.getWidth(), 0, this.getWidth(), this.getHeight());
                } else {
                    Color cia2;
                    int cxi;
                    int zi = 0;
                    while (zi * this.SELECTION_LINE_LENGTH < this.getWidth()) {
                        int xa = this.SELECTION_LINE_LENGTH * zi;
                        int xb = Math.min(this.getWidth(), xa + this.SELECTION_LINE_LENGTH);
                        cxi = zi % this.status.selectionColor.size();
                        cia2 = new Color(this.status.selectionColor.get(cxi).getColor().getRed(), this.status.selectionColor.get(cxi).getColor().getGreen(), this.status.selectionColor.get(cxi).getColor().getBlue(), 140);
                        g2.setColor(cia2);
                        g2.drawLine(xa, 0, xb, 0);
                        g2.drawLine(xa, this.getHeight(), xb, this.getHeight());
                        ++zi;
                    }
                    zi = 0;
                    while (zi * this.SELECTION_LINE_LENGTH < this.getHeight()) {
                        int ya = this.SELECTION_LINE_LENGTH * zi;
                        int yb = Math.min(this.getHeight(), ya + this.SELECTION_LINE_LENGTH);
                        cxi = zi % this.status.selectionColor.size();
                        cia2 = new Color(this.status.selectionColor.get(cxi).getColor().getRed(), this.status.selectionColor.get(cxi).getColor().getGreen(), this.status.selectionColor.get(cxi).getColor().getBlue(), 140);
                        g2.setColor(cia2);
                        g2.drawLine(0, ya, 0, yb);
                        g2.drawLine(this.getWidth(), ya, this.getWidth(), yb);
                        ++zi;
                    }
                }
            }
        }
    }

    public static class JNexusPanel
    extends JPanel {
        private NexusInteractiveEditorInfrastructure infra;
        private JCellBackgroundPanel bgp;

        public JNexusPanel(final NexusInteractiveEditorInfrastructure infra) {
            this.infra = infra;
            this.setOpaque(false);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    infra.dispatchMousePressedEvent(e);
                }
            });
        }

        @Override
        public void paintComponent(Graphics g) {
            Color ci = this.getBackground();
            g.setColor(ci);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            super.paintComponent(g);
        }
    }

    public class NexusInteractiveEditorInfrastructure {
        public final JCellBackgroundPanel panel;

        public NexusInteractiveEditorInfrastructure(int row) {
            this.panel = new JCellBackgroundPanel(NexusTable.this.getThisTable(), NexusTable.this.getThisTable().getTableModel().getHighlightingAndSelectionStatus(row));
        }

        public void dispatchMousePressedEvent(MouseEvent e) {
            if (e.getButton() == 1) {
                NexusTable ti = NexusTable.this.getThisTable();
                Point tablepoint = SwingUtilities.convertPoint(e.getComponent(), e.getX(), e.getY(), ti);
                ti.changeSelection(ti.rowAtPoint(tablepoint), ti.columnAtPoint(tablepoint), e.isControlDown(), e.isShiftDown());
            }
        }
    }

    public static class DefaultEditorFromRenderer
    extends AbstractCellEditor
    implements TableCellEditor {
        TableCellRenderer ra;
        Object lastValue = null;

        public DefaultEditorFromRenderer(TableCellRenderer ra) {
            this.ra = ra;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.lastValue = value;
            return this.ra.getTableCellRendererComponent(table, value, isSelected, false, row, column);
        }

        @Override
        public Object getCellEditorValue() {
            return this.lastValue;
        }
    }

    public static class DefaultRendererFromEditor
    implements TableCellRenderer {
        private TableCellEditor editor;

        public DefaultRendererFromEditor(TableCellEditor editor) {
            this.editor = editor;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            return this.editor.getTableCellEditorComponent(table, value, isSelected, row, column);
        }
    }
}

