/*
 * Decompiled with CFR 0.152.
 */
package tech.molecules.leet.table;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.BitSet;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import tech.molecules.leet.table.NColumn;
import tech.molecules.leet.table.NexusTableModel;
import tech.molecules.leet.table.NumericalDatasource;
import tech.molecules.leet.table.gui.JExtendedSlimRangeSlider;

public class DefaultNumericRangeFilter<X, T>
implements NColumn.NexusRowFilter<T> {
    private NexusTableModel model;
    private NColumn<X, T> col;
    private NumericalDatasource<X> nds;
    private Double[] rangeRestricted = null;
    private double[] rangeValue = new double[]{0.0, 1.0};

    public DefaultNumericRangeFilter(NColumn<X, T> col, String numericDataSource) {
        this.col = col;
        this.nds = this.col.getNumericalDataSources().get(numericDataSource);
    }

    @Override
    public String getFilterName() {
        return this.nds.getName();
    }

    @Override
    public BitSet filterNexusRows(T data, List<String> ids, BitSet filtered) {
        BitSet filtered2 = (BitSet)filtered.clone();
        for (int zi = 0; zi < ids.size(); ++zi) {
            if (!filtered2.get(zi)) continue;
            double vi = this.nds.getValue(ids.get(zi));
            if (this.rangeRestricted == null) continue;
            if (this.rangeRestricted[0] != null && vi < this.rangeRestricted[0]) {
                filtered2.set(zi);
            }
            if (this.rangeRestricted[1] == null || !(vi > this.rangeRestricted[1])) continue;
            filtered2.set(zi);
        }
        return filtered2;
    }

    @Override
    public double getApproximateFilterSpeed() {
        return 0.95;
    }

    @Override
    public void setupFilter(NexusTableModel model, T dp) {
        this.model = model;
        double lb = Double.POSITIVE_INFINITY;
        double ub = Double.NEGATIVE_INFINITY;
        for (int zi = 0; zi < model.getAllRows().size(); ++zi) {
            double vi = this.nds.getValue(model.getAllRows().get(zi));
            if (!Double.isFinite(vi)) continue;
            lb = Math.min(vi, lb);
            ub = Math.max(vi, ub);
        }
        this.rangeValue = new double[]{lb, ub};
    }

    @Override
    public JPanel getFilterGUI() {
        JPanel pi = new JPanel();
        JExtendedSlimRangeSlider jsl = new JExtendedSlimRangeSlider(this.nds.getName(), this.rangeValue);
        pi.setLayout(new BorderLayout());
        pi.add((Component)jsl, "Center");
        jsl.getRangeSlider().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                DefaultNumericRangeFilter.this.model.updateFiltering();
            }
        });
        return pi;
    }

    @Override
    public boolean isReady() {
        return true;
    }
}

