/*
 * Decompiled with CFR 0.152.
 */
package tech.molecules.leet.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractCellEditor;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.LineBorder;
import javax.swing.table.TableCellEditor;
import tech.molecules.leet.table.NColumn;

public class DefaultNumericCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    private Object lastValue = null;
    private JPanel jp_editor = new JPanel();
    private String formatNumeric = "%.3f";
    private NColumn column;
    private Color c_BG_a = Color.WHITE;
    private Color c_BG_b = new Color(248, 252, 252);

    public DefaultNumericCellEditor(NColumn col) {
        this.column = col;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.lastValue = value;
        this.jp_editor.setOpaque(false);
        if (value == null) {
            this.jp_editor.removeAll();
        }
        if (value instanceof Double) {
            this.jp_editor.removeAll();
            this.jp_editor.setLayout(new FlowLayout());
            String str_a = "";
            double evaluatedNumber = (Double)value;
            str_a = String.format(this.formatNumeric, evaluatedNumber);
            this.jp_editor.add(new JEditorLabel(str_a));
        }
        if (value instanceof double[]) {
            double[] dav = (double[])value;
            this.jp_editor.removeAll();
            this.jp_editor.setLayout(new FlowLayout());
            for (int zi = 0; zi < dav.length; ++zi) {
                String str_a = "";
                double evaluatedNumber = dav[zi];
                str_a = String.format(this.formatNumeric, evaluatedNumber);
                this.jp_editor.add(new JEditorLabel(str_a));
            }
        }
        return this.jp_editor;
    }

    @Override
    public Object getCellEditorValue() {
        return this.lastValue;
    }

    public static class JEditorLabel
    extends JLabel {
        public JEditorLabel(String label) {
            super(label);
            this.setBackground(new Color(252, 252, 252));
            this.setOpaque(false);
            this.setBorder(new LineBorder(new Color(0, 0, 0, 0), 1));
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    super.mouseEntered(e);
                    this.setBorder(new LineBorder(Color.blue, 1));
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    super.mouseExited(e);
                    this.setBorder(new LineBorder(new Color(0, 0, 0, 0), 1));
                }
            });
        }
    }
}

