/*
 * Decompiled with CFR 0.152.
 */
package tech.molecules.leet.table;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import tech.molecules.leet.table.NClassification;

public class DefaultClustering<T>
implements NClassification {
    private List<NClassification.NClass> classes = new ArrayList<NClassification.NClass>();
    private List<NClassification.ClassificationListener> listeners = new ArrayList<NClassification.ClassificationListener>();

    @Override
    public List<NClassification.NClass> getClasses() {
        return null;
    }

    @Override
    public void addClass(NClassification.NClass ci) {
        this.classes.add(ci);
    }

    @Override
    public void removeClass(NClassification.NClass ci) {
        this.classes.remove(ci);
    }

    private void fireClassChanged(NClassification.NClass ci) {
        for (NClassification.ClassificationListener li : this.listeners) {
            li.classChanged(ci);
        }
        this.fireClassificationChanged();
    }

    private void fireClassificationChanged() {
        for (NClassification.ClassificationListener li : this.listeners) {
            li.classificationChanged();
        }
    }

    @Override
    public List<NClassification.NClass> getClassesForRow(String rowid) {
        ArrayList<NClassification.NClass> classes = new ArrayList<NClassification.NClass>();
        for (NClassification.NClass ci : this.classes) {
            if (!ci.isMember(rowid)) continue;
            classes.add(ci);
        }
        return classes;
    }

    @Override
    public void addClassificationListener(NClassification.ClassificationListener li) {
        this.listeners.add(li);
    }

    @Override
    public void removeClassificationListener(NClassification.ClassificationListener li) {
        this.listeners.remove(li);
    }

    public static class DefaultClass
    implements NClassification.NClass {
        private String name;
        private String description;
        private Set<String> members = new HashSet<String>();
        private Color color;

        public DefaultClass(String name, String description, Set<String> members, Color color) {
            this.name = name;
            this.description = description;
            this.members = members;
            this.color = color;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public Color getColor() {
            return this.color;
        }

        @Override
        public boolean isMember(String ki) {
            return this.members.contains(ki);
        }

        @Override
        public Set<String> getMembers() {
            return Collections.unmodifiableSet(this.members);
        }

        @Override
        public void setColor(Color c) {
            this.color = c;
        }
    }
}

