/*
 * Decompiled with CFR 0.152.
 */
package tech.molecules.leet.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import tech.molecules.leet.table.NClassification;
import tech.molecules.leet.table.NColumn;
import tech.molecules.leet.table.NDataProvider;
import tech.molecules.leet.table.NexusTable;
import tech.molecules.leet.table.NexusTableModel;
import tech.molecules.leet.table.NumericalDatasource;

public class ClassificationColumn
implements NColumn<NDataProvider.ClassificationProvider, List<NClassification.NClass>> {
    private NDataProvider.ClassificationProvider dp;
    private NexusTableModel ntm;
    private List<NColumn.CellSpecificAction> cellPopupActions = new ArrayList<NColumn.CellSpecificAction>();

    @Override
    public void setDataProvider(NDataProvider.ClassificationProvider dataprovider) {
        this.dp = dataprovider;
    }

    @Override
    public NDataProvider.ClassificationProvider getDataProvider() {
        return this.dp;
    }

    public ClassificationColumn(NClassification classification) {
        classification.addClassificationListener(new NClassification.ClassificationListener(){

            @Override
            public void classificationChanged() {
            }

            @Override
            public void classChanged(NClassification.NClass ci) {
            }
        });
    }

    @Override
    public String getName() {
        return "Classification";
    }

    @Override
    public void startAsyncReinitialization(NexusTableModel model) {
        this.ntm = model;
    }

    @Override
    public void addCellPopupAction(NColumn.CellSpecificAction ca) {
        this.cellPopupActions.add(ca);
    }

    @Override
    public List<NClassification.NClass> getData(String rowid) {
        return this.dp.getClassification().getClassesForRow(rowid);
    }

    @Override
    public TableCellEditor getCellEditor() {
        return new ClassificationRenderer();
    }

    @Override
    public Map<String, NumericalDatasource<NDataProvider.ClassificationProvider>> getNumericalDataSources() {
        return new HashMap<String, NumericalDatasource<NDataProvider.ClassificationProvider>>();
    }

    @Override
    public List<String> getRowFilterTypes() {
        return new ArrayList<String>();
    }

    @Override
    public NColumn.NexusRowFilter<NDataProvider.ClassificationProvider> createRowFilter(NexusTableModel tableModel, String name) {
        return null;
    }

    @Override
    public void addColumnDataListener(NColumn.ColumnDataListener cdl) {
    }

    @Override
    public boolean removeColumnDataListener(NColumn.ColumnDataListener cdl) {
        return false;
    }

    public static class JColorLabel
    extends JLabel {
        public JColorLabel(String text, Color ca) {
            super(text);
            Color c = new Color(ca.getRed(), ca.getGreen(), ca.getBlue(), 40);
            this.setOpaque(true);
            this.setBackground(c);
        }
    }

    public class ClassificationRenderer
    extends AbstractCellEditor
    implements TableCellEditor,
    TableCellRenderer {
        private JComponent jp_editor = new JPanel();
        private Object lastValue = null;

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean isFocus, int row, int column) {
            if (table instanceof NexusTable) {
                NexusTable nt = (NexusTable)table;
                NexusTable.NexusInteractiveEditorInfrastructure editorInfra = nt.createInteractiveEditorInfrastructure(row);
                this.jp_editor = editorInfra.panel;
            } else {
                this.jp_editor = new JPanel();
            }
            if (value == null) {
                this.jp_editor.removeAll();
            }
            if (value instanceof List) {
                ArrayList classes = new ArrayList();
                ((List)value).stream().filter(ci -> ci instanceof NClassification.NClass).forEach(ci -> classes.add((NClassification.NClass)ci));
                this.jp_editor.removeAll();
                this.jp_editor.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
                this.jp_editor.setLayout(new GridLayout(classes.size(), 1));
                for (int zi = 0; zi < classes.size(); ++zi) {
                    JColorLabel cla = new JColorLabel(((NClassification.NClass)classes.get(zi)).getName(), ((NClassification.NClass)classes.get(zi)).getColor());
                    this.jp_editor.add(cla);
                }
            }
            return this.jp_editor;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            System.out.println("Create cell editor: " + row + "/" + column);
            this.lastValue = value;
            Component ci = this.getTableCellRendererComponent(table, value, isSelected, true, row, column);
            if (ci instanceof JComponent) {
                JComponent p_editor = (JComponent)ci;
                JPopupMenu pop = new JPopupMenu();
                for (NColumn.CellSpecificAction csi : ClassificationColumn.this.cellPopupActions) {
                    pop.add(csi);
                }
                ((JComponent)ci).setComponentPopupMenu(pop);
                return ci;
            }
            System.out.println("[ERROR] we should not end up here (ClassificationColumn.ClassificationRenderer)");
            return ci;
        }

        @Override
        public Object getCellEditorValue() {
            return this.lastValue;
        }
    }
}

