/*
 * Decompiled with CFR 0.152.
 */
package tech.molecules.leet.similarity.gui;

import com.actelion.research.chem.descriptor.DescriptorHandler;
import com.actelion.research.chem.descriptor.DescriptorHandlerFunctionalGroups;
import com.actelion.research.chem.descriptor.DescriptorHandlerHashedCFp;
import com.actelion.research.chem.descriptor.DescriptorHandlerLongFFP512;
import com.actelion.research.chem.descriptor.DescriptorHandlerSkeletonSpheres;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import tech.molecules.leet.clustering.ClusterAppModel;
import tech.molecules.leet.similarity.UMapHelper;
import tech.molecules.leet.table.NColumn;
import tech.molecules.leet.table.NStructureDataProvider;
import tech.molecules.leet.table.NexusTableModel;
import tech.molecules.leet.table.PairwiseDistanceColumn;
import tech.molecules.leet.table.chart.ScatterPlotModel;

public class UmapViewModel {
    private ClusterAppModel clusterAppModel;
    private List<Pair<NColumn, NStructureDataProvider>> similarityColumns = new ArrayList<Pair<NColumn, NStructureDataProvider>>();

    public UmapViewModel(ClusterAppModel clusterAppModel) {
        this.clusterAppModel = clusterAppModel;
        this.initSimilarities(clusterAppModel.getNtm().getVisibleRows());
    }

    public void initSimilarities(List<String> rowids) {
        NStructureDataProvider dsp = this.clusterAppModel.getStructureProvider();
        PairwiseDistanceColumn nc_ffp = PairwiseDistanceColumn.createFromDescriptor(dsp, (DescriptorHandler)DescriptorHandlerLongFFP512.getDefaultInstance(), new ArrayList<String>(rowids));
        PairwiseDistanceColumn nc_ffg = PairwiseDistanceColumn.createFromDescriptor(dsp, (DescriptorHandler)DescriptorHandlerFunctionalGroups.getDefaultInstance(), new ArrayList<String>(rowids));
        PairwiseDistanceColumn nc_skl = PairwiseDistanceColumn.createFromDescriptor(dsp, (DescriptorHandler)DescriptorHandlerSkeletonSpheres.getDefaultInstance(), new ArrayList<String>(rowids));
        PairwiseDistanceColumn nc_flexo = PairwiseDistanceColumn.createFromDescriptor(dsp, (DescriptorHandler)DescriptorHandlerHashedCFp.getDefaultInstance(), new ArrayList<String>(rowids));
        this.similarityColumns = new ArrayList<Pair<NColumn, NStructureDataProvider>>();
        this.similarityColumns.add((Pair<NColumn, NStructureDataProvider>)Pair.of((Object)nc_ffp, (Object)dsp));
        this.similarityColumns.add((Pair<NColumn, NStructureDataProvider>)Pair.of((Object)nc_ffg, (Object)dsp));
        this.similarityColumns.add((Pair<NColumn, NStructureDataProvider>)Pair.of((Object)nc_skl, (Object)dsp));
        this.similarityColumns.add((Pair<NColumn, NStructureDataProvider>)Pair.of((Object)nc_flexo, (Object)dsp));
    }

    public List<ScatterPlotModel> createPlots() {
        List<PairwiseDistanceColumn> columns = this.getSimilarityColumns();
        NStructureDataProvider dsp = this.clusterAppModel.getStructureProvider();
        NexusTableModel ntm = this.getNexusTableModel();
        UMapHelper.UMapXYChartConfig config_a = new UMapHelper.UMapXYChartConfig(dsp, columns.get(0));
        UMapHelper.UMapXYChartConfig config_b = new UMapHelper.UMapXYChartConfig(dsp, columns.get(1));
        UMapHelper.UMapXYChartConfig config_c = new UMapHelper.UMapXYChartConfig(dsp, columns.get(2));
        UMapHelper.UMapXYChartConfig config_d = new UMapHelper.UMapXYChartConfig(dsp, columns.get(3));
        ScatterPlotModel p1 = UMapHelper.createChart2(ntm, config_a);
        ScatterPlotModel p2 = UMapHelper.createChart2(ntm, config_b);
        ScatterPlotModel p3 = UMapHelper.createChart2(ntm, config_c);
        ScatterPlotModel p4 = UMapHelper.createChart2(ntm, config_d);
        ArrayList<ScatterPlotModel> plots = new ArrayList<ScatterPlotModel>();
        plots.add(p1);
        plots.add(p2);
        plots.add(p3);
        plots.add(p4);
        return plots;
    }

    public ClusterAppModel getClusterAppModel() {
        return this.clusterAppModel;
    }

    public NStructureDataProvider getStructureProvider() {
        return this.clusterAppModel.getStructureProvider();
    }

    public List<PairwiseDistanceColumn> getSimilarityColumns() {
        return this.similarityColumns.stream().map(ci -> (PairwiseDistanceColumn)ci.getLeft()).collect(Collectors.toList());
    }

    public NexusTableModel getNexusTableModel() {
        return this.clusterAppModel.getNtm();
    }

    public static interface UmapViewListener {
        public void highlightingChanged();

        public void selectionChanged();
    }
}

