/*
 * Decompiled with CFR 0.152.
 */
package tech.molecules.leet.similarity.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.apache.commons.lang3.tuple.Pair;
import org.jfree.chart.renderer.PaintScale;
import tech.molecules.leet.clustering.ClusterAppModel;
import tech.molecules.leet.similarity.gui.UmapViewModel;
import tech.molecules.leet.table.NClassification;
import tech.molecules.leet.table.NexusTableModel;
import tech.molecules.leet.table.chart.JFreeChartScatterPlot;
import tech.molecules.leet.table.chart.JFreeChartScatterPlot2;
import tech.molecules.leet.table.chart.JScatterPlotConfigurationMenuBar;
import tech.molecules.leet.table.chart.ScatterPlotModel;

public class JUmapView
extends JPanel {
    private UmapViewModel model;
    private boolean showClusteringAnnotations = true;
    private JPanel jp_top;
    private JPanel jp_plots;
    private JMenuBar jmb_main;
    private List<JFreeChartScatterPlot2> plots = new ArrayList<JFreeChartScatterPlot2>();
    private Map<String, List<double[]>> contactPositions = new HashMap<String, List<double[]>>();

    public JUmapView(UmapViewModel model) {
        this.model = model;
        this.reinit();
    }

    private void reinit() {
        this.removeAll();
        List<ScatterPlotModel> plots_n = this.model.createPlots();
        this.jp_top = new JPanel();
        this.jp_plots = new JPanel();
        this.setLayout(new BorderLayout());
        this.jmb_main = new JMenuBar();
        this.add((Component)this.jp_plots, "Center");
        this.add((Component)this.jp_top, "North");
        this.jp_top.setLayout(new BorderLayout());
        this.jp_top.add((Component)this.jmb_main, "Center");
        this.jp_plots.setLayout(new GridLayout(2, 2));
        for (int zi = 0; zi < 4; ++zi) {
            JFreeChartScatterPlot2 jfcsp = new JFreeChartScatterPlot2(plots_n.get(zi), false);
            this.plots.add(jfcsp);
            this.jp_plots.add(this.plots.get(zi));
        }
        JScatterPlotConfigurationMenuBar.initMenuBar(this.jmb_main, this.model.getNexusTableModel(), this.plots.stream().map(pi -> pi.getModel()).collect(Collectors.toList()));
        JFreeChartScatterPlot.ScatterPlotListener listener = new JFreeChartScatterPlot.ScatterPlotListener(){

            @Override
            public void highlightingChanged(NexusTableModel.NexusHighlightingChangedEvent e) {
                JUmapView.this.contactPositions.clear();
                for (JFreeChartScatterPlot2 pi : JUmapView.this.plots) {
                    pi.getModel().setHighlight(e.getRows(), false);
                    for (String pki : e.getRows()) {
                        double[] pkip = pi.getPositionOfKey(pki);
                        JUmapView.this.contactPositions.put(pki, Collections.singletonList(pkip));
                    }
                }
                JUmapView.this.model.getClusterAppModel().setHighlighted(new ArrayList<String>(e.getRows()));
            }

            @Override
            public void selectionChanged(NexusTableModel.NexusSelectionChangedEvent e) {
            }
        };
        this.model.getClusterAppModel().addClusterAppModelListener(new ClusterAppModel.ClusterAppModelListener(){

            @Override
            public void selectionChanged(NexusTableModel.NexusSelectionChangedEvent e) {
                for (JFreeChartScatterPlot2 pi : JUmapView.this.plots) {
                    pi.getModel().setSelection(e.getRows());
                    pi.getModel().setHighlightNNearestNeighbors(-1);
                }
            }

            @Override
            public void highlightingChanged(NexusTableModel.NexusHighlightingChangedEvent e) {
                for (JFreeChartScatterPlot2 pi : JUmapView.this.plots) {
                    pi.getModel().setHighlight(new HashSet<String>(e.getRows()), false);
                }
            }

            @Override
            public void clustersChanged() {
                if (JUmapView.this.showClusteringAnnotations) {
                    AbstractAction colorByClustering = new AbstractAction(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            List<Pair<Color, List<String>>> coloring = JUmapView.this.model.getClusterAppModel().getClusters().stream().map(si -> Pair.of((Object)si.getColor(), new ArrayList<String>(si.getMembers()))).collect(Collectors.toList());
                            for (JFreeChartScatterPlot2 csp : JUmapView.this.plots) {
                                ScatterPlotModel scatterPlotModel = csp.getModel();
                                Objects.requireNonNull(scatterPlotModel);
                                scatterPlotModel.new ScatterPlotModel.SetClusteringAnnotationsAction("", coloring).actionPerformed(e);
                            }
                        }
                    };
                    colorByClustering.actionPerformed(null);
                }
            }
        });
        for (JFreeChartScatterPlot2 pi2 : this.plots) {
            pi2.getModel().addScatterPlotListener(listener);
            pi2.getModel().setHighlightNNearestNeighbors(5);
            pi2.getModel().setWithoutAxisAndLegend();
        }
        this.initContextMenu();
    }

    public void initContextMenu() {
        AbstractAction colorAnnotationsByClustering = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List<Pair<Color, List<String>>> coloring = JUmapView.this.model.getClusterAppModel().getClusters().stream().map(si -> Pair.of((Object)si.getColor(), new ArrayList<String>(si.getMembers()))).collect(Collectors.toList());
                for (JFreeChartScatterPlot2 csp : JUmapView.this.plots) {
                    ScatterPlotModel scatterPlotModel = csp.getModel();
                    Objects.requireNonNull(scatterPlotModel);
                    scatterPlotModel.new ScatterPlotModel.SetClusteringAnnotationsAction("", coloring).actionPerformed(e);
                }
            }
        };
        colorAnnotationsByClustering.putValue("Name", "Set annotations by clustering");
        AbstractAction colorByClustering = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HashMap<ClusterAppModel.Cluster, Integer> clusterintmap = new HashMap<ClusterAppModel.Cluster, Integer>();
                HashMap<ClusterAppModel.Cluster, Color> clustercolmap = new HashMap<ClusterAppModel.Cluster, Color>();
                HashMap<String, Integer> clustervalues = new HashMap<String, Integer>();
                for (int zi = 0; zi < JUmapView.this.model.getClusterAppModel().getClusters().size(); ++zi) {
                    clusterintmap.put(JUmapView.this.model.getClusterAppModel().getClusters().get(zi), zi);
                    clustercolmap.put(JUmapView.this.model.getClusterAppModel().getClusters().get(zi), JUmapView.this.model.getClusterAppModel().getClusters().get(zi).getColor());
                }
                for (String si : JUmapView.this.model.getNexusTableModel().getAllRows()) {
                    List<NClassification.NClass> ci = JUmapView.this.model.getClusterAppModel().getClassification().getClassesForRow(si);
                    if (ci.size() > 0) {
                        clustervalues.put(si, (Integer)clusterintmap.get(ci.get(0)));
                        continue;
                    }
                    clustervalues.put(si, -1);
                }
                PaintScale psc = new PaintScale(){

                    public double getLowerBound() {
                        return -1.5;
                    }

                    public double getUpperBound() {
                        return JUmapView.this.model.getClusterAppModel().getClusters().size() + 1;
                    }

                    public Paint getPaint(double v) {
                        if (v >= 0.0) {
                            return JUmapView.this.model.getClusterAppModel().getClusters().get((int)v).getColor();
                        }
                        return Color.gray;
                    }
                };
                for (JFreeChartScatterPlot2 csp : JUmapView.this.plots) {
                    csp.getModel().setColorExpclicit(psc, clustervalues);
                }
            }
        };
        colorByClustering.putValue("Name", "Set color by clustering");
        JPopupMenu jpop = new JPopupMenu();
        jpop.add(new SelectionAction());
        jpop.add(new UnselectAllAction());
        jpop.add(new ActivateNeighborhoodHighlightingAction());
        jpop.add(colorByClustering);
        for (JFreeChartScatterPlot2 csp : this.plots) {
            csp.getChartPanel().setPopupMenu(jpop);
        }
    }

    public Map<String, List<double[]>> getLinkContacts() {
        return this.contactPositions;
    }

    public double[] getLeftUpperCorner() {
        return new double[]{this.getLocation().x, this.getLocation().y};
    }

    private class ActivateNeighborhoodHighlightingAction
    extends AbstractAction {
        public ActivateNeighborhoodHighlightingAction() {
            super("Activate highlighting");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JUmapView.this.plots.forEach(pi -> pi.getModel().setHighlightNNearestNeighbors(5));
        }
    }

    private class UnselectAllAction
    extends AbstractAction {
        public UnselectAllAction() {
            super("Unselect all");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JUmapView.this.model.getClusterAppModel().setSelection(new ArrayList<String>());
        }
    }

    private class SelectionAction
    extends AbstractAction {
        public SelectionAction() {
            super("Select");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JUmapView.this.model.getClusterAppModel().setSelection(JUmapView.this.model.getClusterAppModel().getHighlighted());
        }
    }
}

