/*
 * Decompiled with CFR 0.152.
 */
package tech.molecules.leet.similarity;

import com.actelion.research.chem.StereoMolecule;
import com.formdev.flatlaf.FlatLightLaf;
import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Random;
import java.util.stream.Collectors;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import org.jfree.data.general.DefaultKeyedValuesDataset;
import org.jfree.data.general.KeyedValuesDataset;
import org.knowm.xchart.XChartPanel;
import org.knowm.xchart.XYChart;
import org.knowm.xchart.XYChartBuilder;
import org.knowm.xchart.XYSeries;
import org.knowm.xchart.internal.chartpart.Chart;
import org.knowm.xchart.style.XYStyler;
import tagbio.umap.Umap;
import tech.molecules.leet.chem.ChemUtils;
import tech.molecules.leet.clustering.action.CreateClusteringToolAction;
import tech.molecules.leet.table.DefaultStructureDataProvider;
import tech.molecules.leet.table.NSimilarityColumn;
import tech.molecules.leet.table.NStructureDataProvider;
import tech.molecules.leet.table.NexusTable;
import tech.molecules.leet.table.NexusTableModel;
import tech.molecules.leet.table.StructureColumn;
import tech.molecules.leet.table.chart.ScatterPlotModel;
import tech.molecules.leet.table.chart.XYChartCreator;

public class UMapHelper {
    public static JPanel createChart(NexusTableModel ntm, UMapXYChartConfig conf) {
        double[][] Sim = XYChartCreator.evaluateSimilarityDS(conf.dataset, conf.xCol, ntm.getVisibleRows());
        double[][] umap = UMapHelper.computeUMap(ntm.getVisibleRows().toArray(new String[0]), Sim);
        double[] umapx = new double[umap.length];
        double[] umapy = new double[umap.length];
        for (int zi = 0; zi < umapx.length; ++zi) {
            umapx[zi] = umap[zi][0];
            umapy[zi] = umap[zi][1];
        }
        XYChart chart = ((XYChartBuilder)((XYChartBuilder)((XYChartBuilder)new XYChartBuilder().width(600)).height(600)).title("test")).xAxisTitle("umap1").yAxisTitle("umap2").build();
        ((XYStyler)chart.getStyler()).setDefaultSeriesRenderStyle(XYSeries.XYSeriesRenderStyle.Scatter);
        chart.addSeries("umap", umapx, umapy);
        XChartPanel panel = new XChartPanel((Chart)chart);
        return panel;
    }

    public static ScatterPlotModel createChart2(NexusTableModel ntm, UMapXYChartConfig conf) {
        double[][] Sim = XYChartCreator.evaluateSimilarityDS(conf.dataset, conf.xCol, ntm.getVisibleRows());
        double[][] umap = UMapHelper.computeUMap(ntm.getVisibleRows().toArray(new String[0]), Sim);
        double[] umapx = new double[umap.length];
        double[] umapy = new double[umap.length];
        for (int zi = 0; zi < umapx.length; ++zi) {
            umapx[zi] = umap[zi][0];
            umapy[zi] = umap[zi][1];
        }
        ArrayList<String> keys_a = new ArrayList<String>();
        DefaultKeyedValuesDataset data_x = new DefaultKeyedValuesDataset();
        DefaultKeyedValuesDataset data_y = new DefaultKeyedValuesDataset();
        DefaultKeyedValuesDataset data_z = new DefaultKeyedValuesDataset();
        Random r = new Random();
        for (int zi = 0; zi < ntm.getVisibleRows().size(); ++zi) {
            keys_a.add(ntm.getVisibleRows().get(zi));
            data_x.setValue((Comparable)keys_a.get(zi), umapx[zi]);
            data_y.setValue((Comparable)keys_a.get(zi), umapy[zi]);
        }
        ScatterPlotModel spm = new ScatterPlotModel(ntm, (KeyedValuesDataset)data_x, (KeyedValuesDataset)data_y);
        return spm;
    }

    public static double[][] computeUMap(String[] data, double[][] dist) {
        Umap umap = new Umap();
        umap.setNumberComponents(2);
        umap.setNumberNearestNeighbours(8);
        umap.setThreads(4);
        double[][] result = umap.fitTransform(dist);
        return result;
    }

    public static void main(String[] args) {
        FlatLightLaf.setup();
        try {
            UIManager.setLookAndFeel((LookAndFeel)new FlatLightLaf());
        }
        catch (Exception ex) {
            System.err.println("Failed to initialize LaF");
        }
        String fa = "C:\\datasets\\hitexp_examples\\orexin\\structures_a.txt";
        ArrayList<StereoMolecule> mols = new ArrayList<StereoMolecule>();
        try (BufferedReader in = new BufferedReader(new FileReader(fa));){
            String line = null;
            while ((line = in.readLine()) != null) {
                mols.add(ChemUtils.parseIDCode((String)line));
            }
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        NexusTableModel ntm = new NexusTableModel();
        ArrayList<String[]> mols_a = new ArrayList<String[]>();
        for (int zi = 0; zi < mols.size(); ++zi) {
            mols_a.add(new String[]{"Mol-" + String.format("%04d", zi), ((StereoMolecule)mols.get(zi)).getIDCode()});
        }
        DefaultStructureDataProvider sdp = new DefaultStructureDataProvider(mols_a);
        ntm.addNexusColumn(sdp, new StructureColumn(true));
        NexusTable nt = new NexusTable(ntm);
        JScrollPane jsp = new JScrollPane(nt);
        ntm.updateFiltering();
        ntm.setAllRows(mols_a.stream().map(si -> si[0]).collect(Collectors.toList()));
        JFrame fi = new JFrame();
        fi.setDefaultCloseOperation(2);
        fi.getContentPane().setLayout(new BorderLayout());
        fi.getContentPane().add(jsp);
        fi.setSize(800, 600);
        fi.setVisible(true);
        nt.setRowHeight(100);
        CreateClusteringToolAction ccta = new CreateClusteringToolAction("Clustering", ntm, sdp, null);
        ccta.actionPerformed(new ActionEvent(fi, 13, "GO!"));
    }

    public static class UMapXYChartConfig {
        public final NStructureDataProvider dataset;
        public final NSimilarityColumn xCol;

        public UMapXYChartConfig(NStructureDataProvider dataset, NSimilarityColumn xCol) {
            this.dataset = dataset;
            this.xCol = xCol;
        }
    }
}

