/*
 * Decompiled with CFR 0.152.
 */
package tech.molecules.leet.histogram;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Paint;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Rectangle2D;
import java.util.Random;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.data.statistics.HistogramDataset;
import org.jfree.data.xy.IntervalXYDataset;

public class JHistogramPanel
extends JPanel {
    private double threshold = 0.5;
    private JFreeChart chart;
    private ChartPanel chartPanel;
    private JSlider slider;
    private ValueMarker marker;

    public JHistogramPanel() {
        IntervalXYDataset dataset = this.createDataset();
        this.chart = ChartFactory.createHistogram((String)"Histogram", (String)"X", (String)"Y", (IntervalXYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        final XYPlot plot = (XYPlot)this.chart.getPlot();
        XYBarRenderer renderer = (XYBarRenderer)plot.getRenderer();
        renderer.setDrawBarOutline(false);
        final ValueAxis domainAxis = plot.getDomainAxis();
        this.marker = new ValueMarker(this.threshold);
        this.marker.setPaint((Paint)Color.RED);
        plot.addDomainMarker((Marker)this.marker);
        this.chartPanel = new ChartPanel(this.chart);
        this.chartPanel.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Rectangle2D dataArea = JHistogramPanel.this.chartPanel.getScreenDataArea();
                JHistogramPanel.this.threshold = domainAxis.java2DToValue((double)e.getX(), dataArea, plot.getDomainAxisEdge());
                JHistogramPanel.this.marker.setValue(JHistogramPanel.this.threshold);
                JHistogramPanel.this.slider.setValue((int)JHistogramPanel.this.threshold);
            }
        });
        this.slider = new JSlider(0, 100, (int)this.threshold);
        this.slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JHistogramPanel.this.threshold = JHistogramPanel.this.slider.getValue();
                JHistogramPanel.this.marker.setValue(JHistogramPanel.this.threshold);
            }
        });
        this.setLayout(new BorderLayout());
        this.add((Component)this.chartPanel, "Center");
        this.add((Component)this.slider, "North");
    }

    public IntervalXYDataset createDataset() {
        Random r = new Random();
        HistogramDataset hd = new HistogramDataset();
        double[] ri = new double[200];
        for (int zi = 0; zi < ri.length; ++zi) {
            ri[zi] = r.nextGaussian();
        }
        hd.addSeries((Comparable)((Object)"A"), ri, 20);
        return hd;
    }

    public static void main(String[] args) {
        JFrame fi = new JFrame();
        JHistogramPanel da = new JHistogramPanel();
        fi.getContentPane().setLayout(new BorderLayout());
        fi.add((Component)da, "Center");
        fi.setSize(600, 600);
        fi.setVisible(true);
    }
}

