/*
 * Decompiled with CFR 0.152.
 */
package tech.molecules.leet.clustering.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import tech.molecules.leet.clustering.ClusterAppModel;
import tech.molecules.leet.clustering.gui.JClusterAndColorConfig;
import tech.molecules.leet.similarity.gui.UmapViewModel;
import tech.molecules.leet.table.NDataProvider;
import tech.molecules.leet.table.NexusTableModel;
import tech.molecules.leet.table.gui.JStructureGridPanel;

public class JStructureSelectionPanel
extends JPanel {
    private StructureSelectionModel model;
    private Map<String, double[]> linkPoints = new HashMap<String, double[]>();
    private int selectionRows = 2;
    private int selectionCols = 3;
    private int mouseOverRows = 2;
    private int mouseOverCols = 3;
    private JTabbedPane jtp_Main = new JTabbedPane();
    private JStructureGridPanel jp_mouseOver;
    private JStructureGridPanel jp_selection;
    private int jtpIdxMouseOver = -1;
    private int jtpIdxSelection = -1;
    private Map<String, List<double[]>> linkContacts = new HashMap<String, List<double[]>>();

    public JStructureSelectionPanel(StructureSelectionModel model) {
        this.model = model;
        this.init();
    }

    private void init() {
        this.removeAll();
        BorderLayout borderLayout = new BorderLayout();
        this.setLayout(borderLayout);
        this.jtp_Main = new JTabbedPane();
        this.jp_selection = new JStructureGridPanel(new ArrayList<NDataProvider.StructureWithID>(), this.selectionRows, this.selectionCols);
        this.jp_mouseOver = new JStructureGridPanel(new ArrayList<NDataProvider.StructureWithID>(), this.mouseOverRows, this.mouseOverCols);
        this.add((Component)this.jtp_Main, "Center");
        this.jtp_Main.addTab("Highlighted", this.jp_mouseOver);
        this.jtpIdxMouseOver = this.jtp_Main.getSelectedIndex();
        this.jtp_Main.addTab("Selection", this.jp_selection);
        this.jtpIdxSelection = this.jtp_Main.getSelectedIndex();
        this.model.addModelListener(new StructureSelectionModel.ModelListener(){

            @Override
            public void guiChanged(boolean setSelectionToFront, boolean setMouseOverToFront) {
                if (setSelectionToFront) {
                    JStructureSelectionPanel.this.jtp_Main.setSelectedComponent(JStructureSelectionPanel.this.jp_selection);
                }
                if (setMouseOverToFront) {
                    JStructureSelectionPanel.this.jtp_Main.setSelectedComponent(JStructureSelectionPanel.this.jp_mouseOver);
                }
                JStructureSelectionPanel.this.jp_selection.repaint();
                JStructureSelectionPanel.this.jp_mouseOver.repaint();
            }
        });
        this.model.getClusterAppModel().addClusterAppModelListener(new ClusterAppModel.ClusterAppModelListener(){

            @Override
            public void selectionChanged(NexusTableModel.NexusSelectionChangedEvent e) {
                int lines = e.getRows().size() / 4 + 1;
                List<NDataProvider.StructureWithID> structures_h = JStructureSelectionPanel.this.model.getClusterAppModel().getHighlighted().stream().map(xi -> JStructureSelectionPanel.this.model.getClusterAppModel().getStructureProvider().getStructureData((String)xi)).collect(Collectors.toList());
                JStructureSelectionPanel.this.jp_selection.setData(structures_h, 4, lines, JStructureSelectionPanel.this.model.getClusterAppModel().getClusterColoring(), null, null);
            }

            @Override
            public void highlightingChanged(NexusTableModel.NexusHighlightingChangedEvent e) {
                List<NDataProvider.StructureWithID> structures_h = JStructureSelectionPanel.this.model.getClusterAppModel().getHighlighted().stream().map(xi -> JStructureSelectionPanel.this.model.getClusterAppModel().getStructureProvider().getStructureData((String)xi)).collect(Collectors.toList());
                JStructureSelectionPanel.this.jp_mouseOver.setData(structures_h, 2, 3, null, null, null);
            }

            @Override
            public void clustersChanged() {
                JPopupMenu jpop_selection = JStructureSelectionPanel.createPopupMenuForStructureGridPanel(JStructureSelectionPanel.this.model.getClusterAppModel(), JStructureSelectionPanel.this.jp_selection);
                JStructureSelectionPanel.this.jp_selection.setContextMenu(jpop_selection);
                JStructureSelectionPanel.this.jp_selection.setData(new ArrayList<NDataProvider.StructureWithID>(JStructureSelectionPanel.this.model.getClusterAppModel().getSelection().stream().map(xi -> JStructureSelectionPanel.this.model.getClusterAppModel().getStructureData((String)xi)).collect(Collectors.toList())), 2, 3, JStructureSelectionPanel.this.model.getClusterAppModel().getClusterColoring(), null, null);
            }
        });
        JPopupMenu jpop_selection = JStructureSelectionPanel.createPopupMenuForStructureGridPanel(this.model.getClusterAppModel(), this.jp_selection);
        this.jp_selection.setContextMenu(jpop_selection);
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(400, 400);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(600, 600);
    }

    public static JPopupMenu createPopupMenuForStructureGridPanel(ClusterAppModel app, JStructureGridPanel jgp_selection) {
        JPopupMenu jpop_selection = new JPopupMenu();
        ClusterAppModel clusterAppModel = app;
        Objects.requireNonNull(clusterAppModel);
        ClusterAppModel.CreateClusterAction ccaction = clusterAppModel.new ClusterAppModel.CreateClusterAction("Create cluster", () -> {
            Container container = jgp_selection.getThisJPanel().getParent();
            ClusterAppModel clusterAppModel = app;
            Objects.requireNonNull(clusterAppModel);
            return JClusterAndColorConfig.showDialog(container, clusterAppModel.new ClusterAppModel.Cluster("", "", new ArrayList<String>()));
        }, () -> jgp_selection.getSelected().stream().map(xi -> xi.molid).collect(Collectors.toList()));
        JMenu jm_addToCluster = new JMenu("Add to cluster");
        for (ClusterAppModel.Cluster ci : app.getClusters()) {
            ClusterAppModel clusterAppModel2 = app;
            Objects.requireNonNull(clusterAppModel2);
            ClusterAppModel.AddMembersToClusterAction addToClusterAction = clusterAppModel2.new ClusterAppModel.AddMembersToClusterAction("" + ci.getName(), () -> jgp_selection.getSelected().stream().map(xi -> xi.molid).collect(Collectors.toList()), ci.getName());
            jm_addToCluster.add(addToClusterAction);
        }
        jpop_selection.add(ccaction);
        jpop_selection.add(jm_addToCluster);
        return jpop_selection;
    }

    public static class StructureSelectionModel {
        private UmapViewModel umap;
        private List<ModelListener> listeners = new ArrayList<ModelListener>();

        public StructureSelectionModel(UmapViewModel umap) {
            this.umap = umap;
            this.initModel();
        }

        private void initModel() {
            this.umap.getClusterAppModel().addClusterAppModelListener(new ClusterAppModel.ClusterAppModelListener(){

                @Override
                public void selectionChanged(NexusTableModel.NexusSelectionChangedEvent e) {
                    this.fireGuiChangedEvent(false, false);
                }

                @Override
                public void highlightingChanged(NexusTableModel.NexusHighlightingChangedEvent e) {
                    this.fireGuiChangedEvent(false, true);
                }

                @Override
                public void clustersChanged() {
                    this.fireGuiChangedEvent(false, false);
                }
            });
        }

        public void addModelListener(ModelListener li) {
            this.listeners.add(li);
        }

        public void removeModelListener(ModelListener li) {
            this.listeners.remove(li);
        }

        private void fireGuiChangedEvent(boolean setSelectionToFront, boolean setMouseOverToFront) {
            for (ModelListener li : this.listeners) {
                li.guiChanged(setSelectionToFront, setMouseOverToFront);
            }
        }

        public UmapViewModel getUmapViewModel() {
            return this.umap;
        }

        public ClusterAppModel getClusterAppModel() {
            return this.umap.getClusterAppModel();
        }

        public static interface ModelListener {
            public void guiChanged(boolean var1, boolean var2);
        }
    }
}

