/*
 * Decompiled with CFR 0.152.
 */
package tech.molecules.leet.clustering;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.table.AbstractTableModel;
import org.apache.commons.lang3.tuple.Pair;
import tech.molecules.leet.table.ClassificationColumn;
import tech.molecules.leet.table.NClassification;
import tech.molecules.leet.table.NColumn;
import tech.molecules.leet.table.NDataProvider;
import tech.molecules.leet.table.NStructureDataProvider;
import tech.molecules.leet.table.NexusTableModel;
import tech.molecules.leet.util.ColorMapHelper;

public class ClusterAppModel
implements NDataProvider.StructureDataProvider,
NClassification,
NDataProvider.NClassificationProvider {
    private NStructureDataProvider dsp;
    private List<NClassification.ClassificationListener> classificationListeners = new ArrayList<NClassification.ClassificationListener>();
    private NexusTableModel ntm;
    private List<String> highlighted = new ArrayList<String>();
    private List<String> selection = new ArrayList<String>();
    private List<Cluster> clusters = new ArrayList<Cluster>();
    private NexusTableModel.SelectionType selectionTypMouseOver;
    public static final String CLUSTER_FLAG_DEFINING = "defining";
    private List<ClusterAppModelListener> listeners = new ArrayList<ClusterAppModelListener>();
    private ClusterListModel clusterListModel = new ClusterListModel();
    private ClusterTableModel clusterTableModel = new ClusterTableModel();

    @Override
    public NDataProvider.StructureWithID getStructureData(String rowid) {
        return this.dsp.getStructureData(rowid);
    }

    @Override
    public NClassification getClassification() {
        return this;
    }

    @Override
    public List<NClassification.NClass> getClasses() {
        return new ArrayList<NClassification.NClass>(this.clusters);
    }

    @Override
    public void addClass(NClassification.NClass ci) {
        try {
            this.createCluster(ci.getName(), ci.getColor(), new ArrayList<String>(ci.getMembers()));
        }
        catch (ClusterHandlingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void removeClass(NClassification.NClass ci) {
        throw new RuntimeException("Not yet supported");
    }

    @Override
    public void addClassificationListener(NClassification.ClassificationListener li) {
        this.classificationListeners.add(li);
    }

    @Override
    public void removeClassificationListener(NClassification.ClassificationListener li) {
        this.classificationListeners.remove(li);
    }

    @Override
    public List<NClassification.NClass> getClassesForRow(String id) {
        ArrayList<NClassification.NClass> i_clusters = new ArrayList<NClassification.NClass>();
        for (Cluster ic : this.clusters) {
            if (!ic.getMembers().contains(id)) continue;
            i_clusters.add(ic);
        }
        return i_clusters;
    }

    public ClusterAppModel(NexusTableModel ntm, NStructureDataProvider dsp) {
        this.init(ntm);
        this.dsp = dsp;
    }

    public void init(NexusTableModel ntm) {
        this.ntm = ntm;
        boolean successRegisterType = false;
        String typeName = "ClusterAppMouseOver";
        int zi = 0;
        do {
            String typeName_a = typeName + "_" + ++zi;
            this.selectionTypMouseOver = new NexusTableModel.SelectionType(typeName_a, Color.orange);
        } while (!(successRegisterType = ntm.registerSelectionType(this.selectionTypMouseOver)));
    }

    public void setSelection(List<String> s) {
        this.selection.clear();
        this.selection.addAll(s);
        this.fireSelectionChanged();
    }

    public void setHighlighted(List<String> s) {
        this.highlighted.clear();
        this.highlighted.addAll(s);
        this.fireHighlightingChanged();
    }

    public List<String> getHighlighted() {
        return this.highlighted;
    }

    public NStructureDataProvider getStructureProvider() {
        return this.dsp;
    }

    public ClassificationColumn getClassificationColumn() {
        ClassificationColumn cc = new ClassificationColumn(this);
        cc.setDataProvider(this);
        cc.startAsyncReinitialization(this.ntm);
        cc.addCellPopupAction(new CreateClusterFromCellAction("Create cluster from this row", cc, () -> new ArrayList<String>(this.ntm.getSelectionTypeRows("mouseOver"))));
        cc.addCellPopupAction(new CreateClusterFromCellAction("Create cluster from selected rows", cc, () -> new ArrayList<String>(this.ntm.getSelectionTypeRows("selected"))));
        return cc;
    }

    public NexusTableModel getNtm() {
        return this.ntm;
    }

    public List<Cluster> getClusters() {
        return Collections.unmodifiableList(this.clusters);
    }

    private static Color getRandomColor() {
        Random r = new Random();
        Color col = Color.getHSBColor(r.nextFloat(), 0.85f, 0.95f);
        return col;
    }

    public List<String> getSelection() {
        return Collections.unmodifiableList(this.selection);
    }

    public Map<String, List<Color>> getClusterColoring() {
        HashMap<String, List<Color>> ccm = new HashMap<String, List<Color>>();
        for (String ri : this.getNtm().getAllRows()) {
            ccm.put(ri, this.getClassesForRow(ri).stream().map(nci -> nci.getColor()).collect(Collectors.toList()));
        }
        return ccm;
    }

    public Cluster createCluster(String name, Color color, List<String> ids) throws ClusterHandlingException {
        Cluster ci = new Cluster(name, "", color, ids);
        if (this.clusters.stream().anyMatch(cx -> cx.getName().equals(name))) {
            throw new ClusterHandlingException("Cluster with name already exists");
        }
        this.clusters.add(ci);
        this.fireClustersChanged();
        return ci;
    }

    public Cluster getClusterByName(String c) {
        for (Cluster ci : this.clusters) {
            if (!ci.getName().equals(c)) continue;
            return ci;
        }
        return null;
    }

    public void addClusterAppModelListener(ClusterAppModelListener li) {
        this.listeners.add(li);
    }

    public void removeClusterAppModelListener(ClusterAppModelListener li) {
        this.listeners.remove(li);
    }

    private void fireClustersChanged() {
        for (ClusterAppModelListener clusterAppModelListener : this.listeners) {
            clusterAppModelListener.clustersChanged();
        }
        for (NClassification.ClassificationListener classificationListener : this.classificationListeners) {
            classificationListener.classificationChanged();
        }
        this.clusterListModel.fireClustersChanged();
        this.clusterTableModel.fireClustersChanged();
    }

    private void fireSelectionChanged() {
        for (ClusterAppModelListener li : this.listeners) {
            li.selectionChanged(new NexusTableModel.NexusSelectionChangedEvent(this, new HashSet<String>(this.selection)));
        }
    }

    private void fireHighlightingChanged() {
        for (ClusterAppModelListener li : this.listeners) {
            li.highlightingChanged(new NexusTableModel.NexusHighlightingChangedEvent(this, new HashSet<String>(this.highlighted)));
        }
    }

    public ClusterListModel getClusterListModel() {
        return this.clusterListModel;
    }

    public ClusterTableModel getClusterTableModel() {
        return this.clusterTableModel;
    }

    public class AddMembersToClusterAction
    extends AbstractAction {
        private Supplier<List<String>> structureSupplier;
        private String cluster;

        public AddMembersToClusterAction(String name, Supplier<List<String>> idsupplier, String cluster) {
            super(name);
            this.structureSupplier = idsupplier;
            this.cluster = cluster;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            List<String> si = this.structureSupplier.get();
            Cluster ci = ClusterAppModel.this.getClusterByName(this.cluster);
            if (ci != null) {
                ci.addMembers(si);
            }
        }
    }

    public class CreateClusterAction
    extends AbstractAction {
        private Supplier<List<String>> structureSupplier;
        private Supplier<Pair<String, Color>> clusterSupplier;

        public CreateClusterAction(String name, Supplier<Pair<String, Color>> clustersupplier, Supplier<List<String>> structuresupplier) {
            super(name);
            this.structureSupplier = structuresupplier;
            this.clusterSupplier = clustersupplier;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ArrayList<String> si = new ArrayList<String>();
            if (this.structureSupplier != null) {
                si.addAll((Collection)this.structureSupplier.get());
            }
            Pair<String, Color> scp = this.clusterSupplier.get();
            String cluster = (String)scp.getLeft();
            Color col = (Color)scp.getRight();
            Cluster ci = ClusterAppModel.this.getClusterByName(cluster);
            if (ci == null) {
                try {
                    ClusterAppModel.this.createCluster(cluster, col, si);
                }
                catch (ClusterHandlingException clusterHandlingException) {
                    clusterHandlingException.printStackTrace();
                }
            }
        }
    }

    public class CreateClusterFromSelectedCellsAction
    extends AbstractAction {
        public CreateClusterFromSelectedCellsAction(String name) {
            super(name);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    }

    public class CreateClusterFromCellAction
    extends NColumn.CellSpecificAction {
        public CreateClusterFromCellAction(String name, NColumn column, Supplier<List<String>> rowid) {
            super(name, column, rowid);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                ClusterAppModel.this.createCluster("C" + String.format("%.3f", Math.random()), ColorMapHelper.createRandomColor(), this.getEvaluatedRowIds());
            }
            catch (ClusterHandlingException clusterHandlingException) {
                clusterHandlingException.printStackTrace();
            }
        }

        @Override
        public NColumn.CellSpecificAction createArmedVersion(String name, Supplier<List<String>> rowids) {
            return new CreateClusterFromCellAction(name, this.getColumn(), rowids);
        }
    }

    public static class ClusterHandlingException
    extends Exception {
        public ClusterHandlingException(String msg) {
            super(msg);
        }
    }

    public class ClusterTableModel
    extends AbstractTableModel {
        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "Name";
                }
                case 1: {
                    return "Size";
                }
                case 2: {
                    return "Color";
                }
            }
            return "<ERROR>";
        }

        @Override
        public int getRowCount() {
            return ClusterAppModel.this.clusters.size();
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (rowIndex >= ClusterAppModel.this.clusters.size()) {
                return null;
            }
            Cluster ci = (Cluster)ClusterAppModel.this.clusters.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return ci.getName();
                }
                case 1: {
                    return ci.getStructures().size();
                }
                case 2: {
                    return ci.getColor();
                }
            }
            return null;
        }

        public void fireClustersChanged() {
            this.fireTableDataChanged();
        }
    }

    public class ClusterListModel
    extends AbstractListModel<Cluster> {
        @Override
        public int getSize() {
            return ClusterAppModel.this.clusters.size();
        }

        @Override
        public Cluster getElementAt(int index) {
            return (Cluster)ClusterAppModel.this.clusters.get(index);
        }

        public void fireClustersChanged() {
            this.fireContentsChanged(this, 0, ClusterAppModel.this.clusters.size());
        }
    }

    public static interface ClusterAppModelListener {
        public void selectionChanged(NexusTableModel.NexusSelectionChangedEvent var1);

        public void highlightingChanged(NexusTableModel.NexusHighlightingChangedEvent var1);

        public void clustersChanged();
    }

    public class Cluster
    implements NClassification.NClass {
        private String name;
        private String description;
        private HashSet<String> ids;
        private Map<String, Set<String>> flags;
        private Color color;

        public Cluster(String name, String description, Collection<String> structures) {
            this(name, description, ClusterAppModel.getRandomColor(), structures);
        }

        @Override
        public boolean isMember(String ki) {
            return this.ids.contains(ki);
        }

        @Override
        public Set<String> getMembers() {
            return Collections.unmodifiableSet(this.ids);
        }

        public Cluster(String name, String description, Color col, Collection<String> ids) {
            this.setName(name);
            this.setDescription(description);
            this.ids = new HashSet<String>(ids);
            Random r = new Random();
            this.color = col;
        }

        public void addMembers(Collection<String> s) {
            this.ids.addAll(s);
            ClusterAppModel.this.fireClustersChanged();
        }

        @Override
        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        @Override
        public Color getColor() {
            return this.color;
        }

        public List<String[]> getStructures() {
            return new ArrayList<String[]>(this.ids.stream().map(si -> ((ClusterAppModel)ClusterAppModel.this).dsp.getStructureData((String)si).structure).collect(Collectors.toList()));
        }

        @Override
        public void setColor(Color c_new) {
            this.color = c_new;
        }
    }
}

