/*
 * Decompiled with CFR 0.152.
 */
package tech.molecules.chem.coredb.sql.util;

import com.actelion.research.chem.StereoMolecule;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Random;
import tech.molecules.chem.coredb.Assay;
import tech.molecules.chem.coredb.AssayParameter;
import tech.molecules.chem.coredb.AssayResult;
import tech.molecules.chem.coredb.Batch;
import tech.molecules.chem.coredb.Compound;
import tech.molecules.chem.coredb.CoreDBException;
import tech.molecules.chem.coredb.DataType;
import tech.molecules.chem.coredb.Project;
import tech.molecules.chem.coredb.Tube;
import tech.molecules.chem.coredb.sql.DBManager;
import tech.molecules.chem.coredb.sql.DBManagerHelper;
import tech.molecules.chem.coredb.sql.DataValueImpl;

public class ToyDataGenerator {
    private static final String PROJECT_NAME = "ProtA Blocker";
    private static final String[] ASSAY_NAMES = new String[]{"IC50_ProtA", "HLM", "Solubility"};
    private static final int NUMBER_OF_COMPOUNDS = 200;
    private static final int BATCHES_PER_COMPOUND = 2;
    private static final double MEASUREMENT_VARIABILITY = 0.2;
    private static final Random random = new Random();

    public static void main(String[] args) {
        long ts_a = System.currentTimeMillis();
        ToyDataGenerator.generateToyData_A("sqlite");
        long ts_b = System.currentTimeMillis();
        ToyDataGenerator.generateToyData_A("h2db_mem");
        long ts_c = System.currentTimeMillis();
        System.out.println("sqlite:   " + (ts_b - ts_a));
        System.out.println("h2db_mem: " + (ts_c - ts_b));
    }

    public static DBManager generateToyData_A(String db) {
        Random ri = new Random();
        int rii = Math.abs(ri.nextInt()) % 10000;
        DBManager dbManager = null;
        try {
            String dbUrl = "";
            try {
                if (db.equals("sqlite")) {
                    dbUrl = "jdbc:sqlite:chemdb_test_" + rii + ".db";
                    dbManager = DBManagerHelper.getSQLite(dbUrl);
                } else if (db.contains("h2db")) {
                    dbUrl = "jdbc:h2:mem:";
                    dbManager = DBManagerHelper.getH2(dbUrl);
                } else if (db.equals("postgres")) {
                    dbUrl = "jdbc:postgresql://localhost:5432/leet_chem_01";
                    dbManager = DBManagerHelper.getPostgres(dbUrl, "postgres", "a");
                }
                dbManager.createDatabaseSchema();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Project project = dbManager.createProject(PROJECT_NAME, PROJECT_NAME);
            System.out.println("Created project: " + project.getName());
            DataType numericDataType = DataType.NUMERIC;
            ArrayList<Assay> assays = new ArrayList<Assay>();
            for (String assayName : ASSAY_NAMES) {
                Assay assay = dbManager.createAssay(assayName, project);
                AssayParameter parameter = dbManager.createAssayParameter(assay, numericDataType, "value");
                assays.add(assay);
                System.out.println("Created assay: " + assay.getName());
                assay.getParameter().add(parameter);
            }
            for (int i = 1; i <= 200; ++i) {
                String compoundId = "C" + i;
                StereoMolecule molecule = new StereoMolecule();
                Compound compound = dbManager.createCompound(compoundId, molecule);
                for (int j = 1; j <= 2; ++j) {
                    String batchId = compoundId + "_B" + j;
                    Batch batch = dbManager.createBatch(batchId, compound);
                    String tubeId = batchId + "_T";
                    Tube tube = dbManager.createTube(tubeId, batch);
                    for (Assay assay : assays) {
                        Date date = new Date(System.currentTimeMillis());
                        AssayResult assayResult = dbManager.createAssayResult(assay, date, tube);
                        AssayParameter parameter = assay.getParameter().get(0);
                        double value = 1.0 + 0.2 * (random.nextDouble() * 2.0 - 1.0);
                        DataValueImpl dataValue = new DataValueImpl(value, "" + value);
                        dbManager.addDataValue(assayResult, parameter, dataValue);
                    }
                }
            }
            System.out.println("Inserted toy data.");
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        catch (CoreDBException e) {
            throw new RuntimeException(e);
        }
        return dbManager;
    }
}

