/*
 * Decompiled with CFR 0.152.
 */
package tech.molecules.chem.coredb.sql;

public interface SQLHelper {
    public String getInsertOrIgnoreStatement(String var1, String var2, String var3);

    public static class PostgresHelper
    implements SQLHelper {
        @Override
        public String getInsertOrIgnoreStatement(String tableName, String columns, String values) {
            return "INSERT INTO " + tableName + " (" + columns + ") VALUES (" + values + ") ON CONFLICT DO NOTHING";
        }
    }

    public static class H2Helper
    implements SQLHelper {
        @Override
        public String getInsertOrIgnoreStatement(String tableName, String columns, String values) {
            return "MERGE INTO " + tableName + " (" + columns + ") KEY(" + columns + ") VALUES (" + values + ")";
        }
    }

    public static class SqliteHelper
    implements SQLHelper {
        @Override
        public String getInsertOrIgnoreStatement(String tableName, String columns, String values) {
            return "INSERT OR IGNORE INTO " + tableName + " (" + columns + ") VALUES (" + values + ")";
        }
    }
}

